/*
 * Decompiled with CFR 0.152.
 */
package net.java.truecommons.io;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import javax.annotation.concurrent.NotThreadSafe;
import net.java.truecommons.io.DecoratingSeekableChannel;

@NotThreadSafe
public abstract class DisconnectingSeekableChannel
extends DecoratingSeekableChannel {
    protected DisconnectingSeekableChannel() {
    }

    protected DisconnectingSeekableChannel(SeekableByteChannel channel2) {
        super(channel2);
    }

    @Override
    public abstract boolean isOpen();

    @Override
    public int read(ByteBuffer dst) throws IOException {
        this.checkOpen();
        return this.channel.read(dst);
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        this.checkOpen();
        return this.channel.write(src);
    }

    @Override
    public long position() throws IOException {
        this.checkOpen();
        return this.channel.position();
    }

    @Override
    public SeekableByteChannel position(long newPosition) throws IOException {
        this.checkOpen();
        this.channel.position(newPosition);
        return this;
    }

    @Override
    public long size() throws IOException {
        this.checkOpen();
        return this.channel.size();
    }

    @Override
    public SeekableByteChannel truncate(long size2) throws IOException {
        this.checkOpen();
        this.channel.truncate(size2);
        return this;
    }

    @Override
    public abstract void close() throws IOException;
}

