/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tahiti.util.xml;

import com.sun.tahiti.util.xml.DOMVisitor;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.LocatorImpl;

public class SAXEventGenerator {
    public static void parse(Document dom, final ContentHandler handler) throws SAXException {
        DOMVisitor visitor = new DOMVisitor(){

            @Override
            public void visit(Element e) {
                int attLen = e.getAttributes().getLength();
                AttributesImpl atts = new AttributesImpl();
                for (int i = 0; i < attLen; ++i) {
                    Attr a = (Attr)e.getAttributes().item(i);
                    atts.addAttribute(a.getNamespaceURI(), a.getLocalName(), a.getName(), null, a.getValue());
                }
                try {
                    handler.startElement(e.getNamespaceURI(), e.getLocalName(), e.getNodeName(), atts);
                    super.visit(e);
                    handler.endElement(e.getNamespaceURI(), e.getLocalName(), e.getNodeName());
                }
                catch (SAXException x) {
                    throw new SAXWrapper(x);
                }
            }

            @Override
            public void visitNode(Node n) {
                block5: {
                    block4: {
                        if (n.getNodeType() == 3) break block4;
                        if (n.getNodeType() != 4) break block5;
                    }
                    String text = n.getNodeValue();
                    try {
                        handler.characters(text.toCharArray(), 0, text.length());
                    }
                    catch (SAXException x) {
                        throw new SAXWrapper(x);
                    }
                }
                super.visitNode(n);
            }
        };
        handler.setDocumentLocator(new LocatorImpl());
        handler.startDocument();
        try {
            visitor.visit(dom);
        }
        catch (SAXWrapper w) {
            throw w.e;
        }
        handler.endDocument();
    }

    private static class SAXWrapper
    extends RuntimeException {
        SAXException e;

        SAXWrapper(SAXException e) {
            this.e = e;
        }
    }
}

