/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tahiti.runtime.sm;

import com.sun.msv.datatype.DatabindableDatatype;
import com.sun.tahiti.runtime.sm.Marshaller;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DOMMarshaller
implements Marshaller {
    private final Document document;
    private Node parent;

    public DOMMarshaller() throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        this.document = factory.newDocumentBuilder().newDocument();
        this.parent = this.document;
    }

    public DOMMarshaller(Document emptyDom) {
        if (emptyDom.getChildNodes().getLength() != 0) {
            throw new IllegalArgumentException();
        }
        this.document = emptyDom;
        this.parent = this.document;
    }

    public Document getResult() {
        return this.document;
    }

    @Override
    public void startElement(String namespaceURI, String localName) {
        Element e = this.document.createElementNS(namespaceURI, localName);
        this.parent.appendChild(e);
        this.parent = e;
    }

    @Override
    public void endElement(String namespaceURI, String localName) {
        this.parent = this.parent.getParentNode();
    }

    @Override
    public void startAttribute(String namespaceURI, String localName) {
        Attr a = this.document.createAttributeNS(namespaceURI, localName);
        ((Element)this.parent).setAttributeNodeNS(a);
        this.parent = a;
    }

    @Override
    public void endAttribute(String namespaceURI, String localName) {
        this.parent = ((Attr)this.parent).getOwnerElement();
    }

    @Override
    public void data(Object data, DatabindableDatatype type) {
        if (this.parent instanceof Attr) {
            Attr a = (Attr)this.parent;
            a.setValue(a.getValue() + data.toString());
        } else {
            this.parent.appendChild(this.document.createTextNode(data.toString()));
        }
    }
}

