/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tahiti.runtime.ll;

import com.sun.msv.datatype.DatabindableDatatype;
import com.sun.msv.datatype.xsd.XSDatatype;
import com.sun.msv.grammar.NameClassAndExpression;
import com.sun.tahiti.runtime.ll.Filter;
import com.sun.tahiti.runtime.ll.IntermediateSymbol;
import com.sun.tahiti.runtime.ll.LLAttributeExp;
import com.sun.tahiti.runtime.ll.LLElementExp;
import com.sun.tahiti.runtime.ll.LLParserTable;
import com.sun.tahiti.runtime.ll.NamedSymbol;
import com.sun.tahiti.runtime.ll.NonTerminalSymbol;
import com.sun.tahiti.runtime.ll.Packet;
import com.sun.tahiti.runtime.ll.Rule;
import java.io.PrintStream;
import java.util.HashSet;
import java.util.Set;
import org.relaxng.datatype.ValidationContext;

public final class LLParser {
    private static PrintStream debug = System.out;
    private static final Object removeInterleaveSymbol = new Object();
    public static final Receiver ignoreReceiver = new CharacterReceiver(){

        @Override
        public void start() {
        }

        @Override
        public void end() {
        }

        @Override
        public void action(DatabindableDatatype datatype, String characterContents, ValidationContext context) {
        }
    };
    Packet[] inputs;
    protected StackItem stackTop;
    protected InputReader reader;
    protected BackTrackRecord backTrackLog;
    protected Action[] actions = new Action[16];
    protected int actionPos = 0;
    protected ValidationContext context;
    private final Set applicableRules = new HashSet();

    private void addAction(Action act) {
        if (this.actions.length == this.actionPos) {
            Action[] n = new Action[this.actionPos * 2];
            System.arraycopy(this.actions, 0, n, 0, this.actionPos);
            this.actions = n;
        }
        this.actions[this.actionPos++] = act;
    }

    public Packet.ItemPacket unmarshall(Object startSymbol, Packet[] _inputs, Packet[] _attributes, ValidationContext context, LLParserTable table) throws Exception {
        StackItem startRule;
        assert (table != null);
        this.context = context;
        this.inputs = _inputs;
        this.reader = new InputReader(_attributes, _attributes.length);
        this.stackTop = null;
        this.actionPos = 0;
        Packet.ItemPacket root = new Packet.ItemPacket(startSymbol);
        this.stackTop = startRule = new StackItem(startSymbol, root);
        block0: while (true) {
            Packet current = this.reader.current();
            if (this.stackTop == null) {
                if (this.reader.attLen == 0 && current == null) break;
                if (debug != null) {
                    debug.println("stack is empty but there are unconsumed tokens");
                    if (this.reader.attLen != 0) {
                        debug.println("attribute is left");
                    }
                    if (current != null) {
                        debug.println("input token " + LLParser.symbolToStr(current) + " is left");
                    }
                }
                this.doBackTrack();
                continue;
            }
            if (this.stackTop.symbol == removeInterleaveSymbol) {
                if (debug != null) {
                    debug.println("removing an interleave filter");
                }
                this.reader.removeFilter();
                this.popStack();
                continue;
            }
            if (this.stackTop.symbol instanceof EndNonTerminalAction) {
                this.addAction((Action)this.stackTop.symbol);
                this.popStack();
                continue;
            }
            if (LLParser.isNonTerminal(this.stackTop.symbol) || this.stackTop == startRule) {
                Rule[] rules = null;
                Object currentSymbol = current != null ? current.symbol : null;
                this.applicableRules.clear();
                for (int i = 0; i < this.reader.attLen; ++i) {
                    Rule[] more = table.get(this.stackTop.symbol, this.reader.attributes[i].symbol);
                    if (more == null) continue;
                    if (rules == null) {
                        rules = more;
                        continue;
                    }
                    for (int j = 0; j < more.length; ++j) {
                        this.applicableRules.add(more[j]);
                    }
                }
                Rule[] more = table.get(this.stackTop.symbol, currentSymbol);
                if (more != null) {
                    if (rules == null) {
                        rules = more;
                    } else {
                        for (int j = 0; j < more.length; ++j) {
                            this.applicableRules.add(more[j]);
                        }
                    }
                }
                if (rules == null) {
                    if (debug != null) {
                        debug.println("error: top(" + LLParser.symbolToStr(this.stackTop.symbol) + ") input(" + LLParser.symbolToStr(currentSymbol) + ")");
                        String r = "";
                        for (int i = 0; i < this.reader.attLen; ++i) {
                            r = r + " " + LLParser.symbolToStr(this.reader.attributes[i].symbol);
                        }
                        debug.println("  available attributes:" + r);
                    }
                    this.doBackTrack();
                } else {
                    if (rules.length > 1) {
                        for (int j = 1; j < rules.length; ++j) {
                            this.applicableRules.add(rules[j]);
                        }
                    }
                    this.applyRule(rules[0]);
                }
                if (this.applicableRules.size() == 0) continue;
                this.backTrackLog = new BackTrackRecord(this.applicableRules.toArray(new Rule[0]), 0);
                continue;
            }
            if (this.stackTop.symbol instanceof LLAttributeExp) {
                for (int i = 0; i < this.reader.attLen; ++i) {
                    if (this.reader.attributes[i].symbol != this.stackTop.symbol) continue;
                    this.addAction(new InvokeReceiverAction(this.stackTop.receiver, this.reader.attributes[i]));
                    if (debug != null) {
                        debug.println("consuming an att token: " + LLParser.symbolToStr(this.reader.attributes[i].symbol));
                    }
                    this.reader.consumeAttribute(i);
                    this.popStack();
                    continue block0;
                }
            }
            if (current.symbol != this.stackTop.symbol) {
                this.doBackTrack();
                continue;
            }
            if (debug != null) {
                debug.println("consuming a token: " + LLParser.symbolToStr(this.stackTop.symbol));
            }
            this.addAction(new InvokeReceiverAction(this.stackTop.receiver, current));
            current = this.reader.consume();
            this.popStack();
        }
        for (int i = 0; i < this.actionPos; ++i) {
            this.actions[i].run();
        }
        return root;
    }

    private void doBackTrack() {
        assert (this.backTrackLog != null);
        this.backTrackLog.doBackTrack();
    }

    private void applyRule(Rule rule) {
        Receiver receiver;
        Object left = this.stackTop.symbol;
        if (left instanceof NameClassAndExpression) {
            receiver = this.stackTop.receiver;
        } else {
            assert (LLParser.isNonTerminal(left));
            receiver = ((NonTerminalSymbol)left).createReceiver(this.stackTop.receiver);
        }
        if (debug != null) {
            StringBuffer buf = new StringBuffer();
            buf.append("expanding a rule : ");
            buf.append(LLParser.symbolToStr(this.stackTop.symbol));
            buf.append(" --> ");
            for (int i = 0; i < rule.right.length; ++i) {
                if (i != 0) {
                    if (rule.isInterleave) {
                        buf.append(" & ");
                    } else {
                        buf.append(' ');
                    }
                }
                buf.append(LLParser.symbolToStr(rule.right[i]));
            }
            debug.println(buf);
        }
        this.popStack();
        if (!(left instanceof IntermediateSymbol)) {
            this.addAction(new StartNonTerminalAction(receiver));
            this.stackTop = new StackItem(new EndNonTerminalAction(receiver), null);
        }
        if (!rule.isInterleave) {
            for (int j = rule.right.length - 1; j >= 0; --j) {
                this.stackTop = new StackItem(rule.right[j], receiver);
            }
        } else {
            int j;
            for (j = rule.right.length - 1; j >= 0; --j) {
                if (j != rule.right.length - 1) {
                    this.stackTop = new StackItem(removeInterleaveSymbol, null);
                }
                this.stackTop = new StackItem(rule.right[j], receiver);
            }
            for (j = rule.right.length - 2; j >= 0; --j) {
                this.reader.applyFilter(rule.filters[j]);
            }
        }
    }

    private static boolean isNonTerminal(Object symbol) {
        return symbol instanceof NonTerminalSymbol;
    }

    public static String symbolToStr(Object symbol) {
        if (symbol instanceof NonTerminalSymbol) {
            return symbol.toString();
        }
        if (symbol instanceof XSDatatype) {
            return "D<" + ((XSDatatype)symbol).displayName() + ">";
        }
        if (symbol instanceof DatabindableDatatype) {
            return "D<" + symbol.getClass().getName() + ">";
        }
        if (symbol instanceof LLElementExp) {
            return "E<" + ((LLElementExp)((Object)symbol)).getNameClass() + ">";
        }
        if (symbol instanceof LLAttributeExp) {
            return "A<" + ((LLAttributeExp)((Object)symbol)).getNameClass() + ">";
        }
        if (symbol == null) {
            return "$$$";
        }
        throw new Error(symbol.toString());
    }

    private void popStack() {
        this.stackTop = this.stackTop.previous;
    }

    private static interface Action {
        public void run() throws Exception;
    }

    class InputReader {
        private boolean[] used;
        private int base;
        private int idx;
        public Packet[] attributes;
        public int attLen;
        private FilterChain filter = null;

        InputReader(Packet[] attributes, int len) {
            this.used = new boolean[LLParser.this.inputs.length];
            this.attributes = new Packet[len];
            System.arraycopy(attributes, 0, this.attributes, 0, len);
            this.attLen = len;
            this.idx = 0;
            this.base = 0;
        }

        public int getCurrentIndex() {
            return this.idx;
        }

        public Packet current() {
            if (this.idx == LLParser.this.inputs.length) {
                return null;
            }
            return LLParser.this.inputs[this.idx];
        }

        public Packet consume() {
            this.used[this.idx++] = true;
            this.skipFilteredToken();
            return this.current();
        }

        private void skipFilteredToken() {
            while (this.idx < LLParser.this.inputs.length && (this.used[this.idx] || this.filter != null && this.filter.rejects(LLParser.this.inputs[this.idx].symbol))) {
                ++this.idx;
            }
            while (this.base < LLParser.this.inputs.length && this.used[this.base]) {
                ++this.base;
            }
        }

        public void consumeAttribute(int idx) {
            assert (idx < this.attLen);
            this.attributes[idx] = this.attributes[--this.attLen];
        }

        public void applyFilter(Filter f) {
            this.filter = new FilterChain(f, this.filter);
        }

        public void removeFilter() {
            this.idx = this.base;
            this.filter = this.filter.previous;
            this.skipFilteredToken();
        }

        public InputReader copy() {
            InputReader n = new InputReader(this.attributes, this.attLen);
            n.base = this.base;
            n.idx = this.idx;
            n.filter = this.filter;
            n.attLen = this.attLen;
            System.arraycopy(this.used, 0, n.used, 0, this.used.length);
            return n;
        }

        private final class FilterChain {
            final Filter filter;
            final FilterChain previous;

            FilterChain(Filter filter, FilterChain previous) {
                this.previous = previous;
                this.filter = filter;
            }

            boolean rejects(Object sym) {
                FilterChain f = this;
                while (f != null) {
                    if (f.filter.rejects(sym)) {
                        return true;
                    }
                    f = f.previous;
                }
                return false;
            }
        }
    }

    class StackItem {
        public final StackItem previous;
        public final Object symbol;
        public final Receiver receiver;

        public StackItem(Object symbol, Receiver receiver) {
            this.symbol = symbol;
            this.receiver = receiver;
            this.previous = LLParser.this.stackTop;
        }
    }

    public static interface Receiver {
        public void start() throws Exception;

        public void end() throws Exception;
    }

    private class EndNonTerminalAction
    implements Action {
        private final Receiver rcv;

        EndNonTerminalAction(Receiver rcv) {
            this.rcv = rcv;
        }

        @Override
        public void run() throws Exception {
            this.rcv.end();
        }
    }

    class BackTrackRecord {
        private final BackTrackRecord previous;
        public final StackItem _stackTop;
        public InputReader _reader;
        public final int _actionPos;
        public int nextRuleIdx;
        public final Rule[] rules;

        public BackTrackRecord(Rule[] rules, int index) {
            this._stackTop = LLParser.this.stackTop;
            this._reader = LLParser.this.reader.copy();
            this._actionPos = LLParser.this.actionPos;
            this.nextRuleIdx = index;
            this.rules = rules;
            this.previous = LLParser.this.backTrackLog;
        }

        public void doBackTrack() {
            Rule r = this.rules[this.nextRuleIdx++];
            LLParser.this.stackTop = this._stackTop;
            LLParser.this.reader = this._reader;
            LLParser.this.actionPos = this._actionPos;
            if (this.nextRuleIdx == this.rules.length) {
                LLParser.this.backTrackLog = this.previous;
            } else {
                this._reader = LLParser.this.reader.copy();
            }
            if (debug != null) {
                debug.println("-- backtrack -------");
                StackItem s = LLParser.this.stackTop;
                String str = "";
                while (s != null) {
                    str = " " + LLParser.symbolToStr(s.symbol) + str;
                    s = s.previous;
                }
                debug.println("token stack:" + str);
                debug.println("next token : (" + LLParser.this.reader.getCurrentIndex() + ") " + LLParser.symbolToStr(LLParser.this.reader.current().symbol));
                debug.println("--------------------");
            }
            LLParser.this.applyRule(r);
        }
    }

    private class InvokeReceiverAction
    implements Action {
        private final Receiver rcv;
        private final Packet p;

        InvokeReceiverAction(Receiver rcv, Packet p) {
            this.rcv = rcv;
            this.p = p;
        }

        @Override
        public void run() throws Exception {
            this.p.dispatch(this.rcv, LLParser.this.context);
        }
    }

    private class StartNonTerminalAction
    implements Action {
        private final Receiver rcv;

        StartNonTerminalAction(Receiver rcv) {
            this.rcv = rcv;
        }

        @Override
        public void run() throws Exception {
            this.rcv.start();
        }
    }

    public static interface CharacterReceiver
    extends Receiver {
        public void action(DatabindableDatatype var1, String var2, ValidationContext var3) throws Exception;
    }

    public static interface ObjectReceiver
    extends Receiver {
        public void action(Object var1) throws Exception;
    }

    public static interface FieldReceiver
    extends Receiver {
        public void action(Object var1, NamedSymbol var2) throws Exception;
    }
}

