/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tahiti.reader.annotator;

import com.sun.msv.datatype.DatabindableDatatype;
import com.sun.msv.datatype.xsd.StringType;
import com.sun.msv.datatype.xsd.XSDatatype;
import com.sun.msv.grammar.AttributeExp;
import com.sun.msv.grammar.ChoiceExp;
import com.sun.msv.grammar.ElementExp;
import com.sun.msv.grammar.Expression;
import com.sun.msv.grammar.ExpressionCloner;
import com.sun.msv.grammar.ExpressionVisitorExpression;
import com.sun.msv.grammar.ExpressionVisitorVoid;
import com.sun.msv.grammar.MixedExp;
import com.sun.msv.grammar.OtherExp;
import com.sun.msv.grammar.ReferenceExp;
import com.sun.msv.grammar.trex.ElementPattern;
import com.sun.msv.grammar.util.ExpressionPrinter;
import com.sun.msv.grammar.util.ExpressionWalker;
import com.sun.tahiti.grammar.AnnotatedGrammar;
import com.sun.tahiti.grammar.ClassItem;
import com.sun.tahiti.grammar.FieldItem;
import com.sun.tahiti.grammar.IgnoreItem;
import com.sun.tahiti.grammar.InterfaceItem;
import com.sun.tahiti.grammar.JavaItem;
import com.sun.tahiti.grammar.PrimitiveItem;
import com.sun.tahiti.grammar.SuperClassItem;
import com.sun.tahiti.grammar.util.Multiplicity;
import com.sun.tahiti.grammar.util.MultiplicityCounter;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

class ChoiceAnnotator {
    private static PrintStream debug = null;
    private final Map annotatedRefs = new HashMap();
    private final AnnotatedGrammar grammar;

    public static void annotate(AnnotatedGrammar g) {
        ChoiceAnnotator ann = new ChoiceAnnotator(g);
        ClassItem[] classes = g.getClasses();
        for (int i = 0; i < classes.length; ++i) {
            ClassItem classItem = classes[i];
            Expression expression = classes[i].exp;
            ChoiceAnnotator choiceAnnotator = ann;
            Objects.requireNonNull(choiceAnnotator);
            classItem.exp = expression.visit((ExpressionVisitorExpression)choiceAnnotator.new Annotator(classes[i]));
        }
    }

    private ChoiceAnnotator(AnnotatedGrammar g) {
        this.grammar = g;
    }

    private class Annotator
    extends ExpressionCloner {
        private final ClassItem owner;
        private int iota;
        private RuntimeException eureka;

        private Annotator(ClassItem owner) {
            super(ChoiceAnnotator.this.grammar.getPool());
            this.iota = 0;
            this.eureka = new RuntimeException();
            this.owner = owner;
        }

        public Expression onRef(ReferenceExp exp) {
            Expression r = (Expression)ChoiceAnnotator.this.annotatedRefs.get(exp);
            if (r != null) {
                return r;
            }
            return exp.exp.visit((ExpressionVisitorExpression)this);
        }

        public Expression onOther(OtherExp exp) {
            if (exp instanceof PrimitiveItem || exp instanceof InterfaceItem || exp instanceof ClassItem || exp instanceof IgnoreItem || exp instanceof SuperClassItem || exp instanceof FieldItem) {
                return exp;
            }
            return exp.exp.visit((ExpressionVisitorExpression)this);
        }

        public Expression onAttribute(AttributeExp exp) {
            Expression body = exp.exp.visit((ExpressionVisitorExpression)this);
            if (body == exp.exp) {
                return exp;
            }
            return this.pool.createAttribute(exp.nameClass, body, exp.getDefaultValue());
        }

        public Expression onElement(ElementExp exp) {
            Expression body = exp.contentModel.visit((ExpressionVisitorExpression)this);
            if (body == exp.contentModel) {
                return exp;
            }
            return new ElementPattern(exp.getNameClass(), body);
        }

        public Expression onChoice(ChoiceExp exp) {
            int i;
            Expression[] b = exp.getChildren();
            boolean[] complexBranch = new boolean[b.length];
            boolean[] fieldlessBranch = new boolean[b.length];
            int numLiveBranch = 0;
            boolean bBranchWithField = false;
            final boolean[] bBranchWithPrimitive = new boolean[1];
            if (debug != null) {
                debug.println("Processing Choice: " + ExpressionPrinter.printContentModel((Expression)exp));
                debug.println("checking each branch");
            }
            for (i = 0; i < b.length; ++i) {
                final boolean[] hasChildFieldItem = new boolean[1];
                Multiplicity m = Multiplicity.calc(b[i], new MultiplicityCounter(){

                    @Override
                    protected Multiplicity isChild(Expression exp) {
                        if (exp instanceof FieldItem) {
                            hasChildFieldItem[0] = true;
                        }
                        if (exp instanceof PrimitiveItem) {
                            bBranchWithPrimitive[0] = true;
                        }
                        if (exp instanceof IgnoreItem) {
                            return Multiplicity.zero;
                        }
                        if (exp instanceof JavaItem) {
                            return Multiplicity.one;
                        }
                        return null;
                    }
                });
                if (debug != null) {
                    debug.println("  Branch: " + ExpressionPrinter.printContentModel((Expression)b[i]));
                    debug.println("    multiplicity:" + m + "  hasChildFieldItem:" + hasChildFieldItem[0]);
                }
                if (m.isZero()) continue;
                ++numLiveBranch;
                if (!m.isAtMostOnce()) {
                    complexBranch[i] = true;
                    continue;
                }
                if (!hasChildFieldItem[0]) {
                    fieldlessBranch[i] = true;
                    continue;
                }
                bBranchWithField = true;
                b[i] = b[i].visit((ExpressionVisitorExpression)this);
            }
            if (numLiveBranch <= 1) {
                for (i = 0; i < b.length; ++i) {
                    if (!fieldlessBranch[i] && !complexBranch[i]) continue;
                    b[i] = b[i].visit((ExpressionVisitorExpression)this);
                }
                Expression r = Expression.nullSet;
                for (int i2 = 0; i2 < b.length; ++i2) {
                    r = this.pool.createChoice(r, b[i2]);
                }
                return r;
            }
            for (i = 0; i < b.length; ++i) {
                if (!complexBranch[i]) continue;
                if (debug != null) {
                    debug.println("  Insert a wrapper class on: " + ExpressionPrinter.printContentModel((Expression)exp));
                }
                String className = this.owner.getTypeName() + "Subordinate" + ++this.iota;
                ClassItem ci = ChoiceAnnotator.this.grammar.createClassItem(className, b[i].visit((ExpressionVisitorExpression)this));
                ci.isTemporary = true;
                b[i] = ci;
            }
            Object r = Expression.nullSet;
            for (int i3 = 0; i3 < b.length; ++i3) {
                r = this.pool.createChoice(r, b[i3]);
            }
            if (!bBranchWithField && !bBranchWithPrimitive[0]) {
                String packagePrefix = this.owner.getPackageName();
                packagePrefix = packagePrefix == null ? "" : packagePrefix + ".";
                String intfName = "I" + this.owner.getBareName() + "Content";
                if (((ChoiceAnnotator)ChoiceAnnotator.this).grammar.interfaces.containsKey(packagePrefix + intfName)) {
                    int cnt = 2;
                    while (((ChoiceAnnotator)ChoiceAnnotator.this).grammar.interfaces.containsKey(packagePrefix + intfName + cnt)) {
                        ++cnt;
                    }
                    intfName = intfName + cnt;
                }
                if (debug != null) {
                    debug.println("  Wrap it by an interface iem: " + packagePrefix + intfName);
                    debug.println("  " + ExpressionPrinter.printContentModel((Expression)r));
                }
                r = ChoiceAnnotator.this.grammar.createInterfaceItem(packagePrefix + intfName, (Expression)r);
            }
            return r;
        }

        public Expression onMixed(MixedExp exp) {
            Expression expanded = this.pool.createInterleave(this.pool.createZeroOrMore((Expression)new PrimitiveItem((DatabindableDatatype)StringType.theInstance, this.pool.createData((XSDatatype)StringType.theInstance))), exp.exp);
            try {
                exp.exp.visit((ExpressionVisitorVoid)new ExpressionWalker(){

                    public void onOther(OtherExp exp) {
                        if (exp instanceof FieldItem) {
                            throw Annotator.this.eureka;
                        }
                        if (exp instanceof JavaItem) {
                            return;
                        }
                        super.onOther(exp);
                    }
                });
            }
            catch (RuntimeException e) {
                assert (e == this.eureka);
                return expanded.visit((ExpressionVisitorExpression)this);
            }
            return expanded;
        }
    }
}

