/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tahiti.reader;

import com.sun.msv.reader.Controller;
import com.sun.msv.reader.GrammarReader;
import com.sun.msv.reader.GrammarReaderController;
import com.sun.tahiti.grammar.AnnotatedGrammar;
import com.sun.tahiti.reader.relaxng.TRELAXNGReader;
import com.sun.tahiti.reader.xmlschema.TXMLSchemaReader;
import java.io.IOException;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class GrammarLoader {
    public static AnnotatedGrammar loadSchema(String url, GrammarReaderController controller, SAXParserFactory factory) throws SAXException, ParserConfigurationException, IOException {
        return GrammarLoader._loadSchema(url, controller, factory);
    }

    public static AnnotatedGrammar loadSchema(InputSource source, GrammarReaderController controller, SAXParserFactory factory) throws SAXException, ParserConfigurationException, IOException {
        return GrammarLoader._loadSchema(source, controller, factory);
    }

    public static AnnotatedGrammar loadSchema(String source, GrammarReaderController controller) throws SAXException, ParserConfigurationException, IOException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(true);
        return GrammarLoader._loadSchema(source, controller, factory);
    }

    private static AnnotatedGrammar _loadSchema(Object source, final GrammarReaderController controller, SAXParserFactory factory) throws SAXException, ParserConfigurationException, IOException {
        final TRELAXNGReader relaxNg = new TRELAXNGReader(controller, factory);
        final TXMLSchemaReader xmlSchema = new TXMLSchemaReader(controller, factory);
        final XMLReader parser = factory.newSAXParser().getXMLReader();
        final GrammarReader[] winner = new GrammarReader[1];
        parser.setContentHandler(new DefaultHandler(){
            private Locator locator;
            private Vector prefixes = new Vector();

            @Override
            public void setDocumentLocator(Locator loc) {
                this.locator = loc;
            }

            @Override
            public void startPrefixMapping(String prefix, String uri) {
                this.prefixes.add(new String[]{prefix, uri});
            }

            @Override
            public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
                winner[0] = localName.equals("schema") ? xmlSchema : relaxNg;
                winner[0].setDocumentLocator(this.locator);
                winner[0].startDocument();
                for (int i = 0; i < this.prefixes.size(); ++i) {
                    String[] d = (String[])this.prefixes.get(i);
                    winner[0].startPrefixMapping(d[0], d[1]);
                }
                winner[0].startElement(namespaceURI, localName, qName, atts);
                parser.setContentHandler((ContentHandler)winner[0]);
                parser.setErrorHandler((ErrorHandler)new Controller(controller));
            }
        });
        if (source instanceof String) {
            parser.parse((String)source);
        } else {
            parser.parse((InputSource)source);
        }
        if (winner[0] == relaxNg) {
            return relaxNg.getAnnotatedResult();
        }
        return xmlSchema.getAnnotatedResult();
    }
}

