/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tahiti.compiler.ll;

import com.sun.msv.grammar.AttributeExp;
import com.sun.msv.grammar.ChoiceExp;
import com.sun.msv.grammar.ConcurExp;
import com.sun.msv.grammar.DataExp;
import com.sun.msv.grammar.DataOrValueExp;
import com.sun.msv.grammar.ElementExp;
import com.sun.msv.grammar.Expression;
import com.sun.msv.grammar.ExpressionPool;
import com.sun.msv.grammar.ExpressionVisitorVoid;
import com.sun.msv.grammar.Grammar;
import com.sun.msv.grammar.InterleaveExp;
import com.sun.msv.grammar.ListExp;
import com.sun.msv.grammar.MixedExp;
import com.sun.msv.grammar.NameClassAndExpression;
import com.sun.msv.grammar.OneOrMoreExp;
import com.sun.msv.grammar.OtherExp;
import com.sun.msv.grammar.ReferenceExp;
import com.sun.msv.grammar.SequenceExp;
import com.sun.msv.grammar.ValueExp;
import com.sun.tahiti.compiler.ll.Rule;
import com.sun.tahiti.compiler.ll.Rules;
import com.sun.tahiti.grammar.ClassItem;
import com.sun.tahiti.grammar.FieldItem;
import com.sun.tahiti.grammar.IgnoreItem;
import com.sun.tahiti.grammar.PrimitiveItem;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

public class RuleGenerator {
    private static PrintStream debug = null;
    private Rules rules = new Rules();
    private ExpressionPool pool;
    private Grammar g;

    public static Rules create(Grammar g) {
        return new RuleGenerator()._create(g);
    }

    private RuleGenerator() {
    }

    private Rules _create(Grammar g) {
        Expression left;
        this.pool = g.getPool();
        this.g = g;
        g.getTopLevel().visit(new ExpressionVisitorVoid(){

            public void onElement(ElementExp exp) {
                if (this.visit((Expression)exp)) {
                    RuleGenerator.this.rules.add((Expression)exp, exp.contentModel);
                    exp.contentModel.visit((ExpressionVisitorVoid)this);
                }
            }

            public void onAttribute(AttributeExp exp) {
                if (this.visit((Expression)exp)) {
                    RuleGenerator.this.rules.add((Expression)exp, exp.exp);
                    exp.exp.visit((ExpressionVisitorVoid)this);
                }
            }

            public void onMixed(MixedExp exp) {
                throw new Error();
            }

            public void onChoice(ChoiceExp exp) {
                if (this.visit((Expression)exp)) {
                    RuleGenerator.this.rules.add((Expression)exp, exp.exp1);
                    RuleGenerator.this.rules.add((Expression)exp, exp.exp2);
                    exp.exp1.visit((ExpressionVisitorVoid)this);
                    exp.exp2.visit((ExpressionVisitorVoid)this);
                }
            }

            public void onConcur(ConcurExp exp) {
                throw new Error();
            }

            public void onSequence(SequenceExp exp) {
                if (this.visit((Expression)exp)) {
                    RuleGenerator.this.rules.add((Expression)exp, new Expression[]{exp.exp1, exp.exp2}, false);
                    exp.exp1.visit((ExpressionVisitorVoid)this);
                    exp.exp2.visit((ExpressionVisitorVoid)this);
                }
            }

            public void onInterleave(InterleaveExp exp) {
                if (this.visit((Expression)exp)) {
                    RuleGenerator.this.rules.add((Expression)exp, new Expression[]{exp.exp1, exp.exp2}, true);
                    exp.exp1.visit((ExpressionVisitorVoid)this);
                    exp.exp2.visit((ExpressionVisitorVoid)this);
                }
            }

            public void onNullSet() {
                throw new Error();
            }

            public void onEpsilon() {
            }

            public void onList(ListExp exp) {
                if (this.visit((Expression)exp)) {
                    RuleGenerator.this.rules.add((Expression)exp, exp.exp);
                    exp.exp.visit((ExpressionVisitorVoid)this);
                }
            }

            public void onData(DataExp exp) {
            }

            public void onValue(ValueExp exp) {
            }

            public void onAnyString() {
            }

            public void onOneOrMore(OneOrMoreExp exp) {
                if (this.visit((Expression)exp)) {
                    Expression item = exp.exp;
                    Expression intermediate = RuleGenerator.this.pool.createZeroOrMore(item);
                    if (intermediate == exp) {
                        RuleGenerator.this.rules.add((Expression)exp, Expression.epsilon);
                        RuleGenerator.this.rules.add((Expression)exp, new Expression[]{item, intermediate}, false);
                    } else {
                        RuleGenerator.this.rules.add((Expression)exp, new Expression[]{item, intermediate}, false);
                    }
                    item.visit((ExpressionVisitorVoid)this);
                    intermediate.visit((ExpressionVisitorVoid)this);
                }
            }

            public void onRef(ReferenceExp exp) {
                if (this.visit((Expression)exp)) {
                    RuleGenerator.this.rules.add((Expression)exp, exp.exp);
                    exp.exp.visit((ExpressionVisitorVoid)this);
                }
            }

            public void onOther(OtherExp exp) {
                if (this.visit((Expression)exp)) {
                    RuleGenerator.this.rules.add((Expression)exp, exp.exp);
                    exp.exp.visit((ExpressionVisitorVoid)this);
                }
            }

            private boolean visit(Expression exp) {
                return !RuleGenerator.this.rules.contains(exp);
            }
        });
        HashMap<Expression, Rule> redundantSymbols = new HashMap<Expression, Rule>();
        Iterator itr = this.rules.iterateKeys();
        while (itr.hasNext()) {
            left = (Expression)itr.next();
            Rule[] rs = this.rules.getAll(left);
            if (rs.length != 1 || !RuleGenerator.isActionlessNonTerminal(left) || left instanceof NameClassAndExpression) continue;
            redundantSymbols.put(left, rs[0]);
        }
        this.rewriteRules(redundantSymbols);
        this.rules = this.rules.removeUnreachableRules(g.getTopLevel(), true);
        HashSet<Expression> occuredSymbols = new HashSet<Expression>();
        HashSet<Expression> candidates = new HashSet<Expression>();
        Iterator itr2 = this.rules.iterateKeys();
        while (itr2.hasNext()) {
            Expression left2 = (Expression)itr2.next();
            Rule[] rs = this.rules.getAll(left2);
            for (int i = 0; i < rs.length; ++i) {
                Expression[] right = rs[i].right;
                for (int j = 0; j < right.length; ++j) {
                    if (j == 0 && !occuredSymbols.contains(right[0]) && RuleGenerator.isActionlessNonTerminal(right[0]) && !(right[0] instanceof NameClassAndExpression) && !(right[0] instanceof DataOrValueExp)) {
                        candidates.add(right[j]);
                    } else {
                        candidates.remove(right[j]);
                    }
                    occuredSymbols.add(right[j]);
                }
            }
        }
        Rules result = new Rules();
        Iterator itr3 = this.rules.iterateKeys();
        while (itr3.hasNext()) {
            Expression left3 = (Expression)itr3.next();
            Rule[] rs = this.rules.getAll(left3);
            for (int i = 0; i < rs.length; ++i) {
                int j;
                if (!candidates.contains(rs[i].right[0])) {
                    result.add(left3, rs[i]);
                    continue;
                }
                Rule[] definitions = this.rules.getAll(rs[i].right[0]);
                if (debug != null) assert (definitions != null && definitions.length != 0);
                Rule[] rewritten = new Rule[definitions.length];
                for (j = 0; j < definitions.length; ++j) {
                    rewritten[j] = rs[i].copy();
                    if (!rewritten[j].replaceRight(0, definitions[j])) break;
                }
                if (j != definitions.length) {
                    result.add(left3, rs[i]);
                    continue;
                }
                result.addAll(left3, rewritten);
            }
        }
        this.rules = result.removeUnreachableRules(g.getTopLevel(), true);
        Iterator nonTerms = this.rules.iterateKeys();
        while (nonTerms.hasNext()) {
            left = (Expression)nonTerms.next();
            Iterator jtr = this.rules.get(left).iterator();
            while (jtr.hasNext()) {
                Rule r = (Rule)jtr.next();
                if (r.right.length != 1 || r.right[0] != left) continue;
                if (debug != null) {
                    debug.println("removing self-recursive rule");
                }
                jtr.remove();
            }
        }
        this.rules.intern();
        return this.rules;
    }

    private void rewriteRules(Map redundantSymbols) {
        Iterator itr = this.rules.iterateKeys();
        while (itr.hasNext()) {
            Expression symbol = (Expression)itr.next();
            Rule[] rs = this.rules.getAll(symbol);
            for (int i = 0; i < rs.length; ++i) {
                RuleGenerator.rewriteRule(rs[i], redundantSymbols);
            }
        }
    }

    private static void rewriteRule(Rule rule, Map redundantSymbols) {
        for (int i = 0; i < rule.right.length; ++i) {
            Rule replace;
            while (redundantSymbols.containsKey(rule.right[i]) && rule.replaceRight(i, replace = (Rule)redundantSymbols.get(rule.right[i]))) {
            }
        }
    }

    private static boolean isActionlessNonTerminal(Expression exp) {
        return !(exp instanceof ClassItem) && !(exp instanceof FieldItem) && !(exp instanceof PrimitiveItem) && !(exp instanceof IgnoreItem);
    }
}

