/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tahiti.compiler.ll;

import com.sun.msv.grammar.AnyNameClass;
import com.sun.msv.grammar.AttributeExp;
import com.sun.msv.grammar.BinaryExp;
import com.sun.msv.grammar.ChoiceExp;
import com.sun.msv.grammar.ChoiceNameClass;
import com.sun.msv.grammar.ConcurExp;
import com.sun.msv.grammar.DataExp;
import com.sun.msv.grammar.DifferenceNameClass;
import com.sun.msv.grammar.ElementExp;
import com.sun.msv.grammar.Expression;
import com.sun.msv.grammar.ExpressionVisitorVoid;
import com.sun.msv.grammar.InterleaveExp;
import com.sun.msv.grammar.ListExp;
import com.sun.msv.grammar.MixedExp;
import com.sun.msv.grammar.NameClass;
import com.sun.msv.grammar.NameClassVisitor;
import com.sun.msv.grammar.NamespaceNameClass;
import com.sun.msv.grammar.NotNameClass;
import com.sun.msv.grammar.OneOrMoreExp;
import com.sun.msv.grammar.OtherExp;
import com.sun.msv.grammar.ReferenceExp;
import com.sun.msv.grammar.SequenceExp;
import com.sun.msv.grammar.SimpleNameClass;
import com.sun.msv.grammar.ValueExp;
import com.sun.tahiti.compiler.Symbolizer;
import com.sun.tahiti.compiler.XMLWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

class ExpressionSerializer {
    public final Map expr2id = new HashMap();
    public final Set sharedExps = new HashSet();
    public final XMLWriter out;
    public final Symbolizer symbolizer;
    public final ExpressionVisitorVoid sequencer = new ExpressionVisitorVoid(){

        public void onElement(ElementExp exp) {
        }

        public void onAttribute(AttributeExp exp) {
            this.onExpr((Expression)exp);
        }

        public void onConcur(ConcurExp exp) {
            throw new Error();
        }

        public void onNullSet() {
            throw new Error();
        }

        public void onData(DataExp exp) {
            if (this.onExpr((Expression)exp)) {
                ExpressionSerializer.this.assignId((Expression)exp);
            }
        }

        public void onValue(ValueExp exp) {
            if (this.onExpr((Expression)exp)) {
                ExpressionSerializer.this.assignId((Expression)exp);
            }
        }

        public void onMixed(MixedExp exp) {
            if (this.onExpr((Expression)exp)) {
                exp.exp.visit((ExpressionVisitorVoid)this);
                ExpressionSerializer.this.assignId((Expression)exp);
            }
        }

        public void onList(ListExp exp) {
            if (this.onExpr((Expression)exp)) {
                exp.exp.visit((ExpressionVisitorVoid)this);
                ExpressionSerializer.this.assignId((Expression)exp);
            }
        }

        public void onOneOrMore(OneOrMoreExp exp) {
            if (this.onExpr((Expression)exp)) {
                exp.exp.visit((ExpressionVisitorVoid)this);
                ExpressionSerializer.this.assignId((Expression)exp);
            }
        }

        public void onRef(ReferenceExp exp) {
            if (this.onExpr((Expression)exp)) {
                exp.exp.visit((ExpressionVisitorVoid)this);
                ExpressionSerializer.this.assignId((Expression)exp);
            }
        }

        public void onOther(OtherExp exp) {
            if (this.onExpr((Expression)exp)) {
                exp.exp.visit((ExpressionVisitorVoid)this);
                ExpressionSerializer.this.assignId((Expression)exp);
            }
        }

        public void onEpsilon() {
        }

        public void onAnyString() {
        }

        public void onSequence(SequenceExp exp) {
            this.onBinExp((BinaryExp)exp);
        }

        public void onChoice(ChoiceExp exp) {
            this.onBinExp((BinaryExp)exp);
        }

        public void onInterleave(InterleaveExp exp) {
            this.onBinExp((BinaryExp)exp);
        }

        private void onBinExp(BinaryExp exp) {
            if (this.onExpr((Expression)exp)) {
                exp.exp1.visit((ExpressionVisitorVoid)this);
                exp.exp2.visit((ExpressionVisitorVoid)this);
                ExpressionSerializer.this.assignId((Expression)exp);
            }
        }

        private boolean onExpr(Expression exp) {
            if (ExpressionSerializer.this.expr2id.containsKey(exp)) {
                ExpressionSerializer.this.sharedExps.add(exp);
                return false;
            }
            return true;
        }
    };
    public final ExpressionVisitorVoid serializer = new ExpressionVisitorVoid(){

        public void onElement(ElementExp exp) {
            ExpressionSerializer.this.serialize(exp.contentModel);
        }

        public void onAttribute(AttributeExp exp) {
            ExpressionSerializer.this.serialize(exp.exp);
        }

        public void onConcur(ConcurExp exp) {
            throw new Error();
        }

        public void onNullSet() {
            throw new Error();
        }

        public void onData(DataExp exp) {
            ExpressionSerializer.this.out.element("typedString", new String[]{"dataSymbolRef", ExpressionSerializer.this.symbolizer.getId(exp)});
        }

        public void onValue(ValueExp exp) {
            ExpressionSerializer.this.out.element("typedString", new String[]{"dataSymbolRef", ExpressionSerializer.this.symbolizer.getId(exp)});
        }

        public void onMixed(MixedExp exp) {
            ExpressionSerializer.this.out.start("mixed");
            ExpressionSerializer.this.serialize(exp.exp);
            ExpressionSerializer.this.out.end("mixed");
        }

        public void onList(ListExp exp) {
            ExpressionSerializer.this.out.start("list");
            ExpressionSerializer.this.serialize(exp.exp);
            ExpressionSerializer.this.out.end("list");
        }

        public void onOneOrMore(OneOrMoreExp exp) {
            ExpressionSerializer.this.out.start("oneOrMore");
            ExpressionSerializer.this.serialize(exp.exp);
            ExpressionSerializer.this.out.end("oneOrMore");
        }

        public void onRef(ReferenceExp exp) {
            ExpressionSerializer.this.serialize(exp.exp);
        }

        public void onOther(OtherExp exp) {
            ExpressionSerializer.this.serialize(exp.exp);
        }

        public void onEpsilon() {
            ExpressionSerializer.this.out.element("epsilon");
        }

        public void onAnyString() {
            ExpressionSerializer.this.out.element("text");
        }

        public void onSequence(SequenceExp exp) {
            this.onBinExp("group", (BinaryExp)exp);
        }

        public void onChoice(ChoiceExp exp) {
            this.onBinExp("choice", (BinaryExp)exp);
        }

        public void onInterleave(InterleaveExp exp) {
            this.onBinExp("interleave", (BinaryExp)exp);
        }

        private void onBinExp(String name, BinaryExp exp) {
            ExpressionSerializer.this.out.start(name);
            ExpressionSerializer.this.serialize(exp.exp1);
            ExpressionSerializer.this.serialize(exp.exp2);
            ExpressionSerializer.this.out.end(name);
        }
    };

    ExpressionSerializer(Symbolizer symbolizer, XMLWriter out) {
        this.symbolizer = symbolizer;
        this.out = out;
    }

    public void assignId(Expression exp) {
        if (this.expr2id.containsKey(exp)) {
            throw new Error("assertion failed");
        }
        this.expr2id.put(exp, new Integer(this.expr2id.size()));
    }

    public void serialize(Expression exp) {
        if (exp instanceof ElementExp) {
            this.out.element("element", new String[]{"symbolRef", this.symbolizer.getId(exp)});
        } else if (exp instanceof AttributeExp) {
            this.out.element("attribute", new String[]{"symbolRef", this.symbolizer.getId(exp)});
        } else if (this.sharedExps.contains(exp)) {
            this.out.element("ref", new String[]{"particle", "o" + ((Integer)this.expr2id.get(exp)).toString()});
        } else {
            exp.visit(this.serializer);
        }
    }

    public static void serializeNameClass(NameClass nc, final XMLWriter out) {
        out.start("name");
        nc.visit(new NameClassVisitor(){

            public Object onChoice(ChoiceNameClass nc) {
                out.start("choice");
                nc.nc1.visit((NameClassVisitor)this);
                nc.nc2.visit((NameClassVisitor)this);
                out.end("choice");
                return null;
            }

            public Object onAnyName(AnyNameClass nc) {
                out.element("anyName");
                return null;
            }

            public Object onNsName(NamespaceNameClass nc) {
                out.element("nsName", new String[]{"ns", nc.namespaceURI});
                return null;
            }

            public Object onNot(NotNameClass nc) {
                out.start("not");
                nc.child.visit((NameClassVisitor)this);
                out.end("not");
                return null;
            }

            public Object onDifference(DifferenceNameClass nc) {
                out.start("difference");
                nc.nc1.visit((NameClassVisitor)this);
                nc.nc2.visit((NameClassVisitor)this);
                out.end("difference");
                return null;
            }

            public Object onSimple(SimpleNameClass nc) {
                out.element("name", new String[]{"ns", nc.namespaceURI, "local", nc.localName});
                return null;
            }
        });
        out.end("name");
    }
}

