/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tahiti.compiler.java;

import com.sun.tahiti.compiler.Controller;
import com.sun.tahiti.compiler.Symbolizer;
import com.sun.tahiti.compiler.XMLWriter;
import com.sun.tahiti.compiler.java.FieldSerializer;
import com.sun.tahiti.compiler.java.MarshallerSerializer;
import com.sun.tahiti.compiler.sm.MarshallerGenerator;
import com.sun.tahiti.grammar.AnnotatedGrammar;
import com.sun.tahiti.grammar.ClassItem;
import com.sun.tahiti.grammar.FieldItem;
import com.sun.tahiti.grammar.FieldUse;
import com.sun.tahiti.grammar.InterfaceItem;
import com.sun.tahiti.grammar.Type;
import com.sun.tahiti.grammar.TypeItem;
import com.sun.tahiti.util.xml.DOMBuilder;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class ClassSerializer {
    private final AnnotatedGrammar grammar;
    private final Symbolizer symbolizer;
    private final Controller controller;
    protected final String grammarClassName;
    protected final String grammarShortClassName;
    private String packageName;
    private PrintWriter out;

    public ClassSerializer(AnnotatedGrammar grammar, Symbolizer symbolizer, Controller controller) {
        this.grammar = grammar;
        this.symbolizer = symbolizer;
        this.controller = controller;
        this.grammarClassName = grammar.grammarName;
        int idx = this.grammarClassName.lastIndexOf(46);
        this.grammarShortClassName = idx < 0 ? this.grammarClassName : this.grammarClassName.substring(idx + 1);
    }

    public void generate() throws IOException {
        ClassItem[] types = this.grammar.getClasses();
        for (int i = 0; i < types.length; ++i) {
            this.out = new PrintWriter(this.controller.getOutput(types[i]));
            this.writeClass(types[i]);
        }
        InterfaceItem[] itfs = this.grammar.getInterfaces();
        for (int i = 0; i < itfs.length; ++i) {
            this.out = new PrintWriter(this.controller.getOutput(itfs[i]));
            this.writeClass(itfs[i]);
        }
    }

    private static String format(String fmt, Object[] args) {
        return MessageFormat.format(fmt, args);
    }

    private static String format(String fmt, Object arg1) {
        return MessageFormat.format(fmt, arg1);
    }

    private static String format(String fmt, Object arg1, Object arg2) {
        return MessageFormat.format(fmt, arg1, arg2);
    }

    private static String format(String fmt, Object arg1, Object arg2, Object arg3) {
        return MessageFormat.format(fmt, arg1, arg2, arg3);
    }

    private static String format(String fmt, Object arg1, Object arg2, Object arg3, Object arg4) {
        return MessageFormat.format(fmt, arg1, arg2, arg3, arg4);
    }

    protected String toPrintName(Type type) {
        if (this.packageName == type.getPackageName() || this.packageName != null && this.packageName.equals(type.getPackageName()) || "java.lang".equals(type.getPackageName())) {
            return type.getBareName();
        }
        return type.getTypeName();
    }

    private void writeClass(TypeItem type) {
        int i;
        Type[] itfs;
        ClassItem citm = null;
        InterfaceItem iitm = null;
        if (type instanceof ClassItem) {
            citm = (ClassItem)type;
        } else {
            iitm = (InterfaceItem)type;
        }
        this.packageName = type.getPackageName();
        if (this.packageName != null) {
            this.out.println(ClassSerializer.format("package {0};\n", this.packageName));
        }
        this.out.println("import com.sun.tahiti.runtime.ll.NamedSymbol;");
        this.out.println("import com.sun.tahiti.runtime.sm.Marshaller;");
        if (!this.grammarClassName.equals(this.grammarShortClassName)) {
            this.out.println(ClassSerializer.format("import {0};", this.grammarClassName));
        }
        this.out.println();
        this.produceHeaderComment(type);
        this.out.print(ClassSerializer.format("public {0} {1}", citm != null ? "class" : "interface", type.getBareName()));
        if (citm != null && citm.getSuperType() != null) {
            this.out.print(ClassSerializer.format(" extends {0}", this.toPrintName(type.getSuperType())));
        }
        if ((itfs = type.getInterfaces()).length != 0) {
            this.out.print(ClassSerializer.format(" {0} {1}", citm != null ? "implements" : "extends", this.toPrintName(itfs[0])));
            for (int i2 = 1; i2 < itfs.length; ++i2) {
                this.out.print(ClassSerializer.format(", {0}", this.toPrintName(itfs[i2])));
            }
        }
        this.out.println(" {");
        this.out.println();
        Vector f = new Vector();
        TypeItem t = type;
        while (true) {
            f.addAll(t.fields.values());
            if (!(t instanceof ClassItem)) break;
            ClassItem c = (ClassItem)t;
            if (c.superClass == null) break;
            t = c.superClass.definition;
        }
        FieldUse[] fields = f.toArray(new FieldUse[0]);
        FieldSerializer[] fieldSerializers = new FieldSerializer[fields.length];
        HashMap<String, FieldSerializer> fsMap = new HashMap<String, FieldSerializer>();
        for (i = 0; i < fields.length; ++i) {
            fieldSerializers[i] = FieldSerializer.get(this, fields[i]);
            fsMap.put(fields[i].name, fieldSerializers[i]);
        }
        for (i = 0; i < fields.length; ++i) {
            this.out.println("\n//\n// " + fields[i].name + "\n//\n");
            fieldSerializers[i].writeFieldDef(this.out);
        }
        if (citm != null) {
            this.out.println("\n\n");
            this.out.println("\t/**\n\t * unmarshalling handler.\n\t * This method is called to unmarshall objects from XML.\n\t */");
            this.out.println("\tpublic void setField( NamedSymbol name, Object item ) throws Exception {");
            for (i = 0; i < fields.length; ++i) {
                FieldUse fu = fields[i];
                FieldSerializer fs = fieldSerializers[i];
                this.out.print("\t\tif( ");
                FieldItem[] fi = fu.getItems();
                for (int j = 0; j < fi.length; ++j) {
                    if (j != 0) {
                        this.out.print(" || ");
                    }
                    this.out.print(ClassSerializer.format("name=={0}.{1}", this.grammarShortClassName, this.symbolizer.getId((Object)fi[j])));
                }
                this.out.println(" ) {");
                this.out.println("\t\t\t" + fs.setField("item"));
                this.out.println("\t\t\treturn;");
                this.out.println("\t\t}");
            }
            if (type.getSuperType() != null) {
                this.out.println("\t\tsuper.setField(name,item);");
            } else {
                this.out.println("\t\tthrow new Error();//assertion failed.this is not possible");
            }
            this.out.println("\t}");
        }
        if (citm != null) {
            try {
                DOMBuilder builder = new DOMBuilder();
                XMLWriter writer = XMLWriter.fromContentHandler(builder);
                writer.handler.startDocument();
                MarshallerGenerator.write(this.symbolizer, citm, writer, this.controller);
                writer.handler.endDocument();
                MarshallerSerializer.write(fsMap, this.out, builder.getDocument());
            }
            catch (MarshallerGenerator.Abort a) {
                this.out.println("\t// Tahiti fails to produce a marshaller for this class.\n\t// You have to implement one by yourself if you need it.\n\tpublic void marshall( Marshaller out ) {\n\t\tthrow new UnsupportedOperationException();\n\t}\n");
            }
            catch (ParserConfigurationException e) {
                this.controller.error(null, e.getMessage(), e);
            }
            catch (SAXException e) {
                this.controller.error(null, e.getMessage(), e);
            }
        } else {
            this.out.println("\tvoid marshall( Marshaller out );\n");
        }
        this.out.println("}");
        this.out.flush();
        this.out.close();
    }

    protected void produceHeaderComment(TypeItem type) {
        this.out.println("/**");
        this.out.println(" * " + type.getBareName() + ".");
        boolean hasDerivedType = false;
        this.out.println(" * <h2>list of derived types</h2>");
        hasDerivedType |= this.listDerivedTypes(type, this.grammar.iterateClasses());
        if (!(hasDerivedType |= this.listDerivedTypes(type, this.grammar.iterateInterfaces()))) {
            this.out.println(" *  no derived type");
        }
        this.out.println(" */");
    }

    protected boolean listDerivedTypes(TypeItem current, Iterator itr) {
        boolean hasDerivedType = false;
        while (itr.hasNext()) {
            TypeItem type = (TypeItem)itr.next();
            boolean isDerived = false;
            if (type.getSuperType() == current) {
                isDerived = true;
            }
            Type[] itfs = type.getInterfaces();
            for (int i = 0; i < itfs.length; ++i) {
                if (itfs[i] != current) continue;
                isDerived = true;
            }
            if (isDerived) {
                this.out.println(" *   {@link " + type.getTypeName() + "}");
            }
            hasDerivedType |= isDerived;
        }
        return hasDerivedType;
    }
}

