/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tahiti.compiler.generator;

import com.sun.tahiti.compiler.Controller;
import com.sun.tahiti.compiler.Symbolizer;
import com.sun.tahiti.compiler.XMLWriter;
import com.sun.tahiti.grammar.AnnotatedGrammar;
import com.sun.tahiti.grammar.ClassItem;
import com.sun.tahiti.grammar.FieldItem;
import com.sun.tahiti.grammar.FieldUse;
import com.sun.tahiti.grammar.InterfaceItem;
import com.sun.tahiti.grammar.Type;
import com.sun.tahiti.grammar.TypeItem;
import java.io.IOException;
import java.util.Iterator;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.xml.sax.DocumentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.LocatorImpl;

class XMLGenerator {
    private final AnnotatedGrammar grammar;
    private final Symbolizer symbolizer;
    private final Controller controller;

    XMLGenerator(AnnotatedGrammar grammar, Symbolizer symbolizer, Controller controller) {
        this.grammar = grammar;
        this.symbolizer = symbolizer;
        this.controller = controller;
    }

    void generate() throws SAXException, IOException {
        try {
            ClassItem[] types = this.grammar.getClasses();
            for (int i = 0; i < types.length; ++i) {
                this.write(types[i]);
            }
            InterfaceItem[] itfs = this.grammar.getInterfaces();
            for (int i = 0; i < itfs.length; ++i) {
                this.write(itfs[i]);
            }
        }
        catch (XMLWriter.SAXWrapper w) {
            throw w.e;
        }
    }

    private void write(TypeItem type) throws SAXException, IOException {
        XMLSerializer outHandler = new XMLSerializer(this.controller.getOutput(type), new OutputFormat("xml", null, true));
        XMLWriter out = new XMLWriter((DocumentHandler)outHandler);
        outHandler.setDocumentLocator(new LocatorImpl());
        outHandler.startDocument();
        outHandler.processingInstruction("xml-stylesheet", "type='text/xsl' href='classFileDebug.xsl'");
        this.writeClass(type, out);
        outHandler.endDocument();
    }

    private void writeClass(TypeItem type, XMLWriter out) {
        out.start(type instanceof ClassItem ? "class" : "interface", new String[]{"name", type.name});
        if (type.getSuperType() != null) {
            out.element("extends", new String[]{"name", type.getSuperType().getTypeName()});
        }
        this.writeType(type, out);
        out.start("info");
        out.start("derivedTypes");
        this.writeDerivedTypes("class", type, this.grammar.iterateClasses(), out);
        this.writeDerivedTypes("interface", type, this.grammar.iterateInterfaces(), out);
        out.end("derivedTypes");
        out.end("info");
        out.end("class");
    }

    private void writeDerivedTypes(String tagName, TypeItem current, Iterator itr, XMLWriter out) {
        while (itr.hasNext()) {
            TypeItem type = (TypeItem)itr.next();
            boolean isDerived = false;
            if (type.getSuperType() == current) {
                isDerived = true;
            }
            Type[] itfs = type.getInterfaces();
            for (int i = 0; i < itfs.length; ++i) {
                if (itfs[i] != current) continue;
                isDerived = true;
            }
            if (!isDerived) continue;
            out.element(tagName, new String[]{"name", type.getTypeName()});
        }
    }

    private void writeType(TypeItem t, XMLWriter out) {
        Type[] is = t.interfaces.toArray(new Type[0]);
        for (int i = 0; i < is.length; ++i) {
            out.element("implements", new String[]{"name", is[i].getTypeName()});
        }
        String[] fnames = t.fields.keySet().toArray(new String[0]);
        for (int i = 0; i < fnames.length; ++i) {
            FieldUse fu = (FieldUse)t.fields.get(fnames[i]);
            out.start("field", new String[]{"name", fu.name, "itemType", fu.type.getTypeName(), "minOccurs", Integer.toString(fu.multiplicity.min), "maxOccurs", fu.multiplicity.max == null ? "unbounded" : fu.multiplicity.max.toString()});
            for (FieldItem fi : fu.items) {
                out.element("symbol", new String[]{"name", this.symbolizer.getId((Object)fi)});
            }
            out.end("field");
        }
    }
}

