/*
 * Decompiled with CFR 0.152.
 */
package com.sun.msv.schmit;

import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class DOMScanner {
    private Node currentNode = null;
    private final AttributesImpl atts = new AttributesImpl();
    private ContentHandler receiver = null;
    private static Locator dummyLocator = new Locator(){

        @Override
        public int getLineNumber() {
            return -1;
        }

        @Override
        public int getColumnNumber() {
            return -1;
        }

        @Override
        public String getSystemId() {
            return null;
        }

        @Override
        public String getPublicId() {
            return null;
        }
    };

    public void parse(Element e, ContentHandler handler) throws SAXException {
        this.receiver = handler;
        this.setCurrentLocation(e);
        handler.startDocument();
        handler.setDocumentLocator(dummyLocator);
        this.visit(e);
        this.setCurrentLocation(e);
        handler.endDocument();
    }

    public void visit(Element e) throws SAXException {
        this.setCurrentLocation(e);
        NamedNodeMap attributes = e.getAttributes();
        this.atts.clear();
        int len = attributes.getLength();
        for (int i = len - 1; i >= 0; --i) {
            Attr a = (Attr)attributes.item(i);
            String name = a.getName();
            if (name.equals("xmlns")) {
                this.receiver.startPrefixMapping("", a.getValue());
                continue;
            }
            if (name.startsWith("xmlns:")) {
                this.receiver.startPrefixMapping(a.getLocalName(), a.getValue());
                continue;
            }
            String uri = a.getNamespaceURI();
            if (uri == null) {
                uri = "";
            }
            this.atts.addAttribute(uri, a.getLocalName(), a.getName(), "CDATA", a.getValue());
        }
        String uri = e.getNamespaceURI();
        if (uri == null) {
            uri = "";
        }
        String local = e.getLocalName();
        String qname = e.getTagName();
        this.receiver.startElement(uri, local, qname, this.atts);
        for (Node child = e.getFirstChild(); child != null; child = child.getNextSibling()) {
            this.visit(child);
        }
        this.setCurrentLocation(e);
        this.receiver.endElement(uri, local, qname);
        for (int i = len - 1; i >= 0; --i) {
            Attr a = (Attr)attributes.item(i);
            String name = a.getName();
            if (!name.startsWith("xmlns:")) continue;
            this.receiver.endPrefixMapping(a.getLocalName());
        }
    }

    private void visit(Node n) throws SAXException {
        this.setCurrentLocation(n);
        switch (n.getNodeType()) {
            case 3: 
            case 4: {
                String value = n.getNodeValue();
                this.receiver.characters(value.toCharArray(), 0, value.length());
                break;
            }
            case 1: {
                this.visit((Element)n);
                break;
            }
            case 5: {
                this.receiver.skippedEntity(n.getNodeName());
                break;
            }
            case 7: {
                ProcessingInstruction pi = (ProcessingInstruction)n;
                this.receiver.processingInstruction(pi.getTarget(), pi.getData());
            }
        }
    }

    private void setCurrentLocation(Node currNode) {
        this.currentNode = currNode;
    }

    public Node getCurrentLocation() {
        return this.currentNode;
    }
}

