/*
 * Decompiled with CFR 0.152.
 */
package com.sun.msv.generator;

import com.sun.msv.datatype.SerializationContext;
import com.sun.msv.datatype.xsd.AnyURIType;
import com.sun.msv.datatype.xsd.Base64BinaryType;
import com.sun.msv.datatype.xsd.BooleanType;
import com.sun.msv.datatype.xsd.ByteType;
import com.sun.msv.datatype.xsd.ConcreteType;
import com.sun.msv.datatype.xsd.DoubleType;
import com.sun.msv.datatype.xsd.EnumerationFacet;
import com.sun.msv.datatype.xsd.FinalComponent;
import com.sun.msv.datatype.xsd.FloatType;
import com.sun.msv.datatype.xsd.IntType;
import com.sun.msv.datatype.xsd.IntegerType;
import com.sun.msv.datatype.xsd.LengthFacet;
import com.sun.msv.datatype.xsd.ListType;
import com.sun.msv.datatype.xsd.LongType;
import com.sun.msv.datatype.xsd.MaxLengthFacet;
import com.sun.msv.datatype.xsd.MinLengthFacet;
import com.sun.msv.datatype.xsd.NcnameType;
import com.sun.msv.datatype.xsd.NmtokenType;
import com.sun.msv.datatype.xsd.NonNegativeIntegerType;
import com.sun.msv.datatype.xsd.NormalizedStringType;
import com.sun.msv.datatype.xsd.NumberType;
import com.sun.msv.datatype.xsd.PositiveIntegerType;
import com.sun.msv.datatype.xsd.QnameType;
import com.sun.msv.datatype.xsd.ShortType;
import com.sun.msv.datatype.xsd.StringType;
import com.sun.msv.datatype.xsd.TokenType;
import com.sun.msv.datatype.xsd.UnionType;
import com.sun.msv.datatype.xsd.UnsignedIntType;
import com.sun.msv.datatype.xsd.XSDatatype;
import com.sun.msv.datatype.xsd.XSDatatypeImpl;
import com.sun.msv.datatype.xsd.XmlNames;
import com.sun.msv.generator.ContextProviderImpl;
import com.sun.msv.generator.DataTypeGenerator;
import com.sun.msv.grammar.relax.EmptyStringType;
import com.sun.xml.util.XmlChars;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.relaxng.datatype.Datatype;
import org.relaxng.datatype.ValidationContext;

public class DataTypeGeneratorImpl
implements DataTypeGenerator {
    private final Random random;
    public boolean asciiOnly = false;
    protected Map generatedValues = new HashMap();
    protected Set tokens;

    public DataTypeGeneratorImpl() {
        this(new Random());
    }

    public DataTypeGeneratorImpl(Random random) {
        this.random = random;
    }

    @Override
    public String generate(Datatype dt, ContextProviderImpl context) {
        String s = null;
        HashSet<String> vs = (HashSet<String>)this.generatedValues.get(dt);
        if (vs == null) {
            vs = new HashSet<String>();
            this.generatedValues.put(dt, vs);
            for (String token : this.tokens) {
                try {
                    if (!dt.isValid(token, null)) continue;
                    vs.add(token);
                }
                catch (Exception exception) {}
            }
        }
        if (vs.size() < 32 || this.random.nextBoolean()) {
            int i;
            for (i = 0; i < 100; ++i) {
                s = this._generate(dt, context);
                if (s == null || !dt.isValid(s, (ValidationContext)context)) continue;
                vs.add(s);
                break;
            }
            if (i == 100) {
                if (vs.size() == 0) {
                    this.fail(dt);
                } else {
                    s = (String)vs.toArray()[this.random.nextInt(vs.size())];
                }
            }
        } else {
            s = (String)vs.toArray()[this.random.nextInt(vs.size())];
        }
        return s;
    }

    protected String _generate(Datatype dt, ContextProviderImpl context) {
        Set vs;
        if (dt instanceof AnyURIType) {
            String r;
            while (!dt.isValid(r = this.generateString(), (ValidationContext)context)) {
            }
            return r;
        }
        if (dt instanceof NonNegativeIntegerType) {
            long r;
            while ((r = this.random.nextLong()) < 0L) {
            }
            return Long.toString(r);
        }
        if (dt instanceof PositiveIntegerType) {
            long r;
            while ((r = this.random.nextLong()) <= 0L) {
            }
            return Long.toString(r);
        }
        if (dt.getClass() == UnsignedIntType.class) {
            return Long.toString(this.random.nextLong() & Integer.MAX_VALUE);
        }
        if (dt.getClass() == ByteType.class) {
            return Long.toString(this.random.nextInt(256));
        }
        if (dt.getClass() == ShortType.class) {
            return Long.toString((short)this.random.nextInt());
        }
        if (dt.getClass() == IntType.class) {
            return Long.toString(this.random.nextInt());
        }
        if (dt.getClass() == LongType.class) {
            return Long.toString(this.random.nextLong());
        }
        if (dt instanceof IntegerType) {
            return Long.toString(this.random.nextLong());
        }
        if (dt.getClass() == StringType.class) {
            return this.generateString();
        }
        if (dt.getClass() == TokenType.class) {
            return this.generateString();
        }
        if (dt.getClass() == NormalizedStringType.class) {
            return this.generateString();
        }
        if (dt.getClass() == NmtokenType.class) {
            return this.generateNMTOKEN();
        }
        if (dt.getClass() == NcnameType.class) {
            return this.generateNCName();
        }
        if (dt.getClass() == NumberType.class) {
            return this.generateDecimal();
        }
        if (dt.getClass() == BooleanType.class) {
            return this.generateBoolean();
        }
        if (dt.getClass() == Base64BinaryType.class) {
            return this.generateBase64Binary();
        }
        if (dt instanceof FloatType || dt instanceof DoubleType) {
            return this.generateFloating();
        }
        if (dt.getClass() == QnameType.class) {
            return this.generateNCName();
        }
        if (dt instanceof FinalComponent) {
            return this.generate((Datatype)((FinalComponent)dt).baseType, context);
        }
        if (dt instanceof EmptyStringType) {
            return "";
        }
        if (dt instanceof XSDatatypeImpl) {
            ConcreteType baseType;
            XSDatatypeImpl dti = (XSDatatypeImpl)dt;
            EnumerationFacet e = (EnumerationFacet)dti.getFacetObject("enumeration");
            if (e != null) {
                Object[] items = e.values.toArray();
                for (int i = 0; i < 10; ++i) {
                    try {
                        return dti.convertToLexicalValue(items[this.random.nextInt(items.length)], (SerializationContext)context);
                    }
                    catch (Exception exception) {
                        continue;
                    }
                }
            }
            if ((baseType = dti.getConcreteType()) instanceof ListType) {
                return this.generateList(dti, context);
            }
            if (baseType instanceof UnionType) {
                return this.generateUnion((UnionType)baseType, context);
            }
            if (baseType != dti) {
                return this.generate((Datatype)baseType, context);
            }
        }
        if ((vs = (Set)this.generatedValues.get(dt)) != null && vs.size() != 0) {
            return (String)vs.toArray()[this.random.nextInt(vs.size())];
        }
        return null;
    }

    private String generateBase64Binary() {
        int len = this.random.nextInt(16) * 4;
        StringBuffer b = new StringBuffer(len);
        for (int i = 0; i < len; ++i) {
            b.append(this.random.nextInt(26) + 65);
        }
        return b.toString();
    }

    protected void fail(Datatype dt) {
        throw new DataTypeGenerator.GenerationException("unable to generate value for this datatype: " + (dt instanceof XSDatatype ? ((XSDatatype)dt).displayName() : dt.toString()));
    }

    protected String generateNMTOKEN() {
        int len = this.random.nextInt(15) + 1;
        String r = "";
        for (int i = 0; i < len; ++i) {
            char ch;
            while (!XmlChars.isNameChar((char)(ch = this.asciiOnly ? (char)this.random.nextInt(128) : (char)this.random.nextInt(65535)))) {
            }
            r = r + ch;
        }
        return r;
    }

    protected String generateUnion(UnionType ut, ContextProviderImpl context) {
        try {
            return this.generate((Datatype)ut.memberTypes[this.random.nextInt(ut.memberTypes.length)], context);
        }
        catch (DataTypeGenerator.GenerationException ge) {
            return null;
        }
    }

    protected String generateList(XSDatatypeImpl dti, ContextProviderImpl context) {
        try {
            int n;
            ListType base = (ListType)dti.getConcreteType();
            LengthFacet lf = (LengthFacet)dti.getFacetObject("length");
            if (lf != null) {
                n = lf.length;
            } else {
                MaxLengthFacet xlf = (MaxLengthFacet)dti.getFacetObject("maxLength");
                int max = xlf != null ? xlf.maxLength : 16;
                MinLengthFacet nlf = (MinLengthFacet)dti.getFacetObject("minLength");
                int min = nlf != null ? nlf.minLength : 0;
                n = this.random.nextInt(max - min) + min;
            }
            String s = "";
            for (int i = 0; i < n; ++i) {
                s = s + " " + this.generate((Datatype)base.itemType, context) + " ";
            }
            return s;
        }
        catch (DataTypeGenerator.GenerationException ge) {
            return null;
        }
    }

    protected String generateNCName() {
        String r;
        while (!XmlNames.isNCName((String)(r = this.generateNMTOKEN()))) {
        }
        return r;
    }

    protected String generateDecimal() {
        return this.random.nextLong() + "." + this.random.nextInt(1000);
    }

    protected String generateBoolean() {
        switch (this.random.nextInt(4)) {
            case 0: {
                return "true";
            }
            case 1: {
                return "false";
            }
            case 2: {
                return "0";
            }
            case 3: {
                return "1";
            }
        }
        throw new Error();
    }

    protected String generateString() {
        int len = this.random.nextInt(16);
        String r = "";
        for (int i = 0; i < len; ++i) {
            char ch;
            while (!XmlChars.isChar((int)(ch = this.asciiOnly ? (char)this.random.nextInt(128) : (char)this.random.nextInt(65535))) || Character.isISOControl(ch)) {
            }
            r = r + ch;
        }
        return r;
    }

    protected String generateFloating() {
        return Float.toString(this.random.nextFloat());
    }
}

