/*
 * Decompiled with CFR 0.152.
 */
package com.sun.msv.generator;

import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class DOM2toSAX2 {
    private static final String XMLNS_URI = "http://www.w3.org/2000/xmlns/";
    protected ContentHandler handler;

    public void setContentHandler(ContentHandler handler) {
        this.handler = handler;
    }

    public ContentHandler getContentHandler() {
        return this.handler;
    }

    public void traverse(Document dom) throws SAXException {
        if (this.handler == null) {
            throw new IllegalArgumentException("content handler is not set");
        }
        this.handler.startDocument();
        this.onElement(dom.getDocumentElement());
        this.handler.endDocument();
    }

    protected Attributes convertAttributes(Element e) {
        NamedNodeMap atts = e.getAttributes();
        AttributesImpl sa = new AttributesImpl();
        for (int i = 0; i < atts.getLength(); ++i) {
            Attr a = (Attr)atts.item(i);
            String value = a.getValue();
            if (value == null) {
                value = "";
            }
            String uri = DOM2toSAX2.nullAdjust(a.getNamespaceURI());
            String localName = a.getLocalName();
            if (localName == null) {
                localName = a.getName();
            }
            if (XMLNS_URI.equals(uri)) continue;
            sa.addAttribute(uri, localName, a.getName(), "CDATA", value);
        }
        return sa;
    }

    protected void onElement(Element e) throws SAXException {
        int i;
        NamedNodeMap atts = e.getAttributes();
        for (int i2 = 0; i2 < atts.getLength(); ++i2) {
            Attr a = (Attr)atts.item(i2);
            if (!a.getName().startsWith("xmlns")) continue;
            String prefix = a.getName();
            int idx = prefix.indexOf(58);
            if (idx < 0) {
                this.handler.startPrefixMapping("", a.getValue());
                continue;
            }
            this.handler.startPrefixMapping(prefix.substring(idx + 1), a.getValue());
        }
        this.handler.startElement(DOM2toSAX2.nullAdjust(e.getNamespaceURI()), e.getLocalName(), e.getTagName(), this.convertAttributes(e));
        NodeList children = e.getChildNodes();
        for (i = 0; i < children.getLength(); ++i) {
            Node n = children.item(i);
            if (n instanceof Element) {
                this.onElement((Element)n);
            }
            if (!(n instanceof Text)) continue;
            this.onText((Text)n);
        }
        this.handler.endElement(DOM2toSAX2.nullAdjust(e.getNamespaceURI()), e.getLocalName(), e.getTagName());
        for (i = 0; i < atts.getLength(); ++i) {
            Attr a = (Attr)atts.item(i);
            if (!a.getName().startsWith("xmlns")) continue;
            String prefix = a.getName();
            int idx = prefix.indexOf(58);
            if (idx < 0) {
                this.handler.endPrefixMapping("");
                continue;
            }
            this.handler.endPrefixMapping(prefix.substring(idx + 1));
        }
    }

    protected void onText(Text t) throws SAXException {
        String s = t.getData();
        if (s != null) {
            this.handler.characters(s.toCharArray(), 0, s.length());
        }
    }

    private static String nullAdjust(String s) {
        return s == null ? "" : s;
    }
}

