/*
 * Decompiled with CFR 0.152.
 */
package com.sun.msv.generator;

import com.sun.msv.datatype.SerializationContext;
import com.sun.msv.datatype.xsd.IDType;
import com.sun.msv.datatype.xsd.NmtokenType;
import com.sun.msv.datatype.xsd.StringType;
import com.sun.msv.datatype.xsd.XSDatatype;
import com.sun.msv.generator.ContextProviderImpl;
import com.sun.msv.generator.ElementDeclCollector;
import com.sun.msv.generator.GeneratorOption;
import com.sun.msv.grammar.AttributeExp;
import com.sun.msv.grammar.BinaryExp;
import com.sun.msv.grammar.ChoiceExp;
import com.sun.msv.grammar.ConcurExp;
import com.sun.msv.grammar.DataExp;
import com.sun.msv.grammar.ElementExp;
import com.sun.msv.grammar.Expression;
import com.sun.msv.grammar.ExpressionPool;
import com.sun.msv.grammar.ExpressionVisitorVoid;
import com.sun.msv.grammar.InterleaveExp;
import com.sun.msv.grammar.ListExp;
import com.sun.msv.grammar.MixedExp;
import com.sun.msv.grammar.NameClass;
import com.sun.msv.grammar.OneOrMoreExp;
import com.sun.msv.grammar.OtherExp;
import com.sun.msv.grammar.ReferenceExp;
import com.sun.msv.grammar.SequenceExp;
import com.sun.msv.grammar.ValueExp;
import com.sun.msv.grammar.util.ExpressionPrinter;
import com.sun.msv.util.StringPair;
import com.sun.xml.util.XmlChars;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import org.relaxng.datatype.Datatype;
import org.relaxng.datatype.ValidationContext;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class Generator
implements ExpressionVisitorVoid {
    private final GeneratorOption opts;
    private final ExpressionPool pool;
    private final Document domDoc;
    private Node node;
    private int depth = 0;
    private boolean errorGenerated = false;
    private final Set ids = new HashSet();
    private final Set idrefs = new HashSet();
    private final ElementExp[] elementDecls;
    private final AttributeExp[] attributeDecls;

    protected boolean cutBack() {
        return this.depth > 5;
    }

    public static void generate(Expression exp, Document emptyDoc) {
        Generator.generate(exp, emptyDoc, new GeneratorOption());
    }

    public static void generate(Expression exp, Document emptyDoc, GeneratorOption opts) {
        for (int i = 0; i < 10; ++i) {
            Generator g;
            while (emptyDoc.hasChildNodes()) {
                emptyDoc.removeChild(emptyDoc.getFirstChild());
            }
            while (true) {
                if (emptyDoc.getFirstChild() != null) {
                    emptyDoc.removeChild(emptyDoc.getFirstChild());
                    continue;
                }
                g = new Generator(exp, emptyDoc, opts);
                exp.visit((ExpressionVisitorVoid)g);
                if (g.errorGenerated || !opts.errorSpecified()) break;
            }
            Object[] ids = g.ids.toArray();
            if (ids.length == 0 && g.idrefs.size() != 0) continue;
            for (Text node : g.idrefs) {
                node.setData((String)ids[opts.random.nextInt(ids.length)]);
            }
            return;
        }
        throw new Error("no ID");
    }

    protected Generator(Expression exp, Document emptyDoc, GeneratorOption opts) {
        opts.fillInByDefault();
        this.opts = opts;
        this.pool = opts.pool;
        this.domDoc = emptyDoc;
        this.node = this.domDoc;
        Set[] s = ElementDeclCollector.collect(exp);
        this.elementDecls = new ElementExp[s[0].size()];
        s[0].toArray(this.elementDecls);
        this.attributeDecls = new AttributeExp[s[1].size()];
        s[1].toArray(this.attributeDecls);
    }

    private void noteError(String error) {
        this.errorGenerated = true;
        if (!this.opts.insertComment) {
            return;
        }
        Comment com = this.domDoc.createComment("  " + error + "  ");
        Node n = this.node;
        if (n.getNodeType() == 2) {
            n = ((Attr)n).getOwnerElement();
            n.insertBefore(com, n.getFirstChild());
        } else {
            n.appendChild(com);
        }
    }

    public void onEpsilon() {
    }

    public void onNullSet() {
        throw new Error();
    }

    public void onSequence(SequenceExp exp) {
        if (!(exp.exp1 instanceof AttributeExp) && !(exp.exp2 instanceof AttributeExp) && this.opts.random.nextDouble() < this.opts.probSeqError) {
            this.noteError("swap sequence to " + ExpressionPrinter.printSmallest((Expression)exp.exp2) + "," + ExpressionPrinter.printSmallest((Expression)exp.exp1));
            exp.exp2.visit((ExpressionVisitorVoid)this);
            exp.exp1.visit((ExpressionVisitorVoid)this);
            return;
        }
        exp.exp1.visit((ExpressionVisitorVoid)this);
        exp.exp2.visit((ExpressionVisitorVoid)this);
    }

    public void onInterleave(InterleaveExp ip) {
        Vector vec = this.getChildren((BinaryExp)ip);
        Node old = this.node;
        for (int i = 0; i < vec.size(); ++i) {
            this.node = this.domDoc.createElement("dummy");
            ((Expression)vec.get(i)).visit((ExpressionVisitorVoid)this);
            vec.set(i, this.node);
        }
        this.node = old;
        while (vec.size() != 0) {
            int idx = this.opts.random.nextInt(vec.size());
            Element e = (Element)vec.get(idx);
            if (!e.hasChildNodes()) {
                vec.remove(idx);
                NamedNodeMap m = e.getAttributes();
                for (int i = 0; i < m.getLength(); ++i) {
                    Attr a = (Attr)m.item(0);
                    e.removeAttributeNS(a.getNamespaceURI(), a.getLocalName());
                    if (((Element)this.node).hasAttribute(a.getName())) continue;
                    ((Element)this.node).setAttributeNodeNS(a);
                }
                continue;
            }
            this.node.appendChild(e.getFirstChild());
        }
    }

    public void onChoice(ChoiceExp cp) {
        if (cp.exp1 == Expression.epsilon && cp.exp2 instanceof OneOrMoreExp) {
            this.onZeroOrMore((OneOrMoreExp)cp.exp2);
            return;
        }
        if (cp.exp2 == Expression.epsilon && cp.exp1 instanceof OneOrMoreExp) {
            this.onZeroOrMore((OneOrMoreExp)cp.exp1);
            return;
        }
        if (this.cutBack() && cp.isEpsilonReducible()) {
            return;
        }
        Vector vec = this.getChildren((BinaryExp)cp);
        if (this.opts.random.nextDouble() < this.opts.probGreedyChoiceError) {
            int i;
            Expression[] es = new Expression[2];
            for (i = 0; i < 2; ++i) {
                do {
                    es[i] = (Expression)vec.get(this.opts.random.nextInt(vec.size()));
                } while (es[i] == Expression.epsilon);
            }
            this.noteError("greedy choice " + ExpressionPrinter.printSmallest((Expression)es[0]) + " & " + ExpressionPrinter.printSmallest((Expression)es[1]));
            for (i = 0; i < 2; ++i) {
                es[i].visit((ExpressionVisitorVoid)this);
            }
            return;
        }
        ((Expression)vec.get(this.opts.random.nextInt(vec.size()))).visit((ExpressionVisitorVoid)this);
    }

    public void onMixed(MixedExp exp) {
        this.pool.createInterleave(this.pool.createZeroOrMore(Expression.anyString), exp.exp).visit((ExpressionVisitorVoid)this);
    }

    public void onList(ListExp exp) {
        Node text;
        Node oldNode = this.node;
        Element child = this.domDoc.createElement("dummy");
        this.node = child;
        exp.exp.visit((ExpressionVisitorVoid)this);
        while ((text = this.node.getFirstChild()) != null) {
            oldNode.appendChild(this.domDoc.createTextNode(" "));
            this.node.removeChild(text);
            oldNode.appendChild(text);
        }
    }

    public void onRef(ReferenceExp exp) {
        exp.exp.visit((ExpressionVisitorVoid)this);
    }

    public void onOther(OtherExp exp) {
        exp.exp.visit((ExpressionVisitorVoid)this);
    }

    public void onAttribute(AttributeExp exp) {
        StringPair name;
        if (this.opts.random.nextDouble() < this.opts.probMutatedAttrError) {
            this.noteError("mutated attribute " + exp.nameClass);
            this.onAttribute(this.attributeDecls[this.opts.random.nextInt(this.attributeDecls.length)]);
            return;
        }
        if (this.opts.random.nextDouble() < this.opts.probMissingAttrError) {
            this.noteError("missing attribute " + exp.nameClass);
            return;
        }
        if (this.opts.random.nextDouble() < this.opts.probSlipInAttrError) {
            AttributeExp a = this.attributeDecls[this.opts.random.nextInt(this.attributeDecls.length)];
            this.noteError("slip-in attribute " + a.nameClass);
            this.onAttribute(a);
        }
        int retry = 0;
        do {
            name = this.getName(exp.nameClass);
        } while (((Element)this.node).getAttributeNodeNS(name.namespaceURI, name.localName) != null && retry++ < 100);
        if (this.opts.random.nextDouble() < this.opts.probAttrNameTypo) {
            this.noteError("attribute name typo: " + name.localName);
            name = this.generateTypo(name);
        }
        Attr a = this.domDoc.createAttributeNS(name.namespaceURI, name.localName);
        ((Element)this.node).setAttributeNodeNS(a);
        Node old = this.node;
        this.node = a;
        exp.exp.visit((ExpressionVisitorVoid)this);
        this.node = old;
    }

    public void onElement(ElementExp exp) {
        if (this.node instanceof Document && ((Document)this.node).getDocumentElement() != null) {
            return;
        }
        if (this.opts.random.nextDouble() < this.opts.probMutatedElemError) {
            this.noteError("mutated element");
            this.onElement(this.elementDecls[this.opts.random.nextInt(this.elementDecls.length)]);
            return;
        }
        if (this.node.getNodeType() != 9) {
            if (this.opts.random.nextDouble() < this.opts.probMissingElemError) {
                this.noteError("missing element: " + ExpressionPrinter.printSmallest((Expression)exp));
                return;
            }
            if (this.opts.random.nextDouble() < this.opts.probSlipInElemError) {
                ElementExp e = this.elementDecls[this.opts.random.nextInt(this.elementDecls.length)];
                this.noteError("slip-in element: " + ExpressionPrinter.printSmallest((Expression)e));
                this.onElement(e);
            }
        }
        StringPair name = this.getName(exp.getNameClass());
        if (this.opts.random.nextDouble() < this.opts.probElemNameTypo) {
            this.noteError("element name typo: " + name.localName);
            name = this.generateTypo(name);
        }
        Element child = this.domDoc.createElementNS(name.namespaceURI, name.localName);
        this.node.appendChild(child);
        this.node = child;
        ++this.depth;
        exp.contentModel.visit((ExpressionVisitorVoid)this);
        --this.depth;
        this.node = child.getParentNode();
    }

    public void onAnyString() {
        this.node.appendChild(this.domDoc.createTextNode(this.opts.dtGenerator.generate((Datatype)StringType.theInstance, this.getContext())));
    }

    public void onOneOrMore(OneOrMoreExp exp) {
        if (this.opts.random.nextDouble() < this.opts.probMissingPlus) {
            this.noteError("missing " + ExpressionPrinter.printSmallest((Expression)exp));
            return;
        }
        int m = this.opts.width.next() + 1;
        if (this.cutBack()) {
            m = 1;
        }
        for (int i = 0; i < m; ++i) {
            exp.exp.visit((ExpressionVisitorVoid)this);
        }
    }

    public void onZeroOrMore(OneOrMoreExp exp) {
        int m = this.opts.width.next();
        if (this.cutBack()) {
            m = 0;
        }
        for (int i = 0; i < m; ++i) {
            exp.exp.visit((ExpressionVisitorVoid)this);
        }
    }

    public void onValue(ValueExp exp) {
        String text;
        if (exp.dt instanceof XSDatatype) {
            XSDatatype xsd = (XSDatatype)exp.dt;
            text = xsd.convertToLexicalValue(exp.value, (SerializationContext)this.getContext());
        } else {
            text = exp.value.toString();
            if (!exp.dt.sameValue(exp.value, exp.dt.createValue(text, (ValidationContext)this.getContext()))) {
                throw new Error("unable to produce a value for the datatype:" + exp.name);
            }
        }
        this.node.appendChild(this.domDoc.createTextNode(text));
    }

    public void onData(DataExp exp) {
        String value;
        if (exp.dt == IDType.theInstance) {
            while (this.ids.contains(value = this.opts.dtGenerator.generate((Datatype)NmtokenType.theInstance, this.getContext()))) {
            }
            this.ids.add(value);
        } else {
            if (exp.dt.getIdType() == 2 || exp.dt.getIdType() == 3) {
                Text n = this.domDoc.createTextNode("{TmpIDRef}");
                this.node.appendChild(n);
                this.idrefs.add(n);
                return;
            }
            value = this.opts.dtGenerator.generate(exp.dt, this.getContext());
        }
        this.node.appendChild(this.domDoc.createTextNode(value));
    }

    public void onConcur(ConcurExp exp) {
        throw new Error("concur is not supported");
    }

    protected ContextProviderImpl getContext() {
        Node n = this.node;
        while (!(n instanceof Element) && n != null) {
            if (n instanceof Attr) {
                n = ((Attr)n).getOwnerElement();
                continue;
            }
            n = n.getParentNode();
        }
        if (n == null) {
            throw new Error();
        }
        return new ContextProviderImpl((Element)n);
    }

    private StringPair getName(NameClass nc) {
        StringPair name = this.opts.nameGenerator.generate(nc);
        if (!nc.accepts(name.namespaceURI, name.localName)) {
            throw new Error();
        }
        return name;
    }

    private Vector getChildren(BinaryExp exp) {
        Vector vec = new Vector();
        Iterator itr = exp.children();
        while (itr.hasNext()) {
            vec.add(itr.next());
        }
        return vec;
    }

    protected StringPair generateTypo(StringPair pair) {
        StringBuffer buf = new StringBuffer(pair.localName);
        int idx = this.opts.random.nextInt(buf.length());
        char ch = buf.charAt(idx);
        if (XmlChars.isNCNameChar((char)((char)(ch - '\u0001')))) {
            ch = (char)(ch - '\u0001');
        } else if (XmlChars.isNCNameChar((char)((char)(ch + '\u0001')))) {
            ch = (char)(ch + '\u0001');
        } else {
            while (!XmlChars.isNCNameChar((char)(ch = (char)this.opts.random.nextInt()))) {
            }
        }
        buf.setCharAt(idx, ch);
        return new StringPair(pair.namespaceURI, buf.toString());
    }
}

