package flexunit.framework {

/**
 * Base class containing static assert methods.
 */
public class Assert {
  protected static var _assertionsMade:Number;

  public static native function resetAssertionsMade():void;

  public static native function oneAssertionHasBeenMade():void;

  public static native function resetEveryAsserionsFields():void;

  public static native function get maxAssertionsMade():Number;

  public static native function get assetionsMade():Number;

  public static native function get totalAssertionsMade():Number;

  public function Assert() {
    super();
  }

  /**
   * Asserts that 2 values are equal.
   * The first argument can be the message when the assertion fails
   *
   * @param arguments [ message = "", expected, actual ]
   */
  public static native function assertEquals(...arguments):void;

  /**
   * Asserts that 2 objects are equal.
   * This method will recursively compare properties on the nested objects.
   * The first argument can be the message when the assertion fails
   *
   * @param arguments [ message = "", expected, actual ]
   */
  public static native function assertObjectEquals(...arguments):void;

  /**
   * Asserts that a string matches a regexp.
   * The first argument can be the message when the assertion fails
   *
   * @param arguments [ message = "", regexp, stringToTest ]
   */
  public static native function assertMatch(...arguments):void;

  /**
   * Asserts that a string doesn't match a regexp.
   * The first argument can be the message when the assertion fails
   *
   * @param arguments [ message = "", regexp, stringToTest ]
   */
  public static native function assertNoMatch(...arguments):void;

  /**
   * Asserts that the first string is contained in the second one
   * The first argument can be the message when the assertion fails
   *
   * @param arguments [ message = "", shortString, longString ]
   */
  public static native function assertContained(...arguments):void;

  /**
   * Asserts that the first string is not contained in the second one
   * The first argument can be the message when the assertion fails
   *
   * @param arguments [ message = "", shortString, longString ]
   */
  public static native function assertNotContained(...arguments):void;

  /**
   * Asserts that two objects are strickly identical
   * The first argument can be the message when the assertion fails
   *
   * @param arguments [ message = "", expectedObject, actualObject ]
   */
  public static native function assertStrictlyEquals(...arguments):void;

  /**
   * Asserts that a condition is true
   * The first argument can be the message when the assertion fails
   *
   * @param arguments [ message = "", condition ]
   */
  public static native function assertTrue(...arguments):void;

  /**
   * Asserts that a condition is false
   * The first argument can be the message when the assertion fails
   *
   * @param arguments [ message = "", condition ]
   */
  public static native function assertFalse(...arguments):void;

  /**
   * Asserts that an object is null
   * The first argument can be the message when the assertion fails
   *
   * @param arguments [ message = "", objectToTest ]
   */
  public static native function assertNull(...arguments):void;

  /**
   * Asserts that an object is not null
   * The first argument can be the message when the assertion fails
   *
   * @param arguments [ message = "", objectToTest ]
   */
  public static native function assertNotNull(...arguments):void;

  /**
   * Asserts that an object is undefined
   * The first argument can be the message when the assertion fails
   *
   * @param arguments [ message = "", objectToTest ]
   */
  public static native function assertUndefined(...arguments):void;

  /**
   * Asserts that an object is not undefined
   * The first argument can be the message when the assertion fails
   *
   * @param arguments [ message = "", objectToTest ]
   */
  public static native function assertNotUndefined(...arguments):void;

  /**
   * Fails with the given message
   *
   * @param failMessage
   */
  public static native function fail(failMessage:String = ""):void;
}
}