package js {

[Native("CanvasRenderingContext2D")]
public interface CanvasRenderingContext2D {
  function get canvas():js.HTMLCanvasElement;

  function save():void;

  function restore():void;

  function scale(x:Number, y:Number):void;

  function rotate(angle:Number):void;

  function translate(x:Number, y:Number):void;

  function transform(m11:Number, m12:Number, m21:Number, m22:Number, dx:Number, dy:Number):void;

  function setTransform(m11:Number, m12:Number, m21:Number, m22:Number, dx:Number, dy:Number):void;

  function get globalAlpha():Number;

  function set globalAlpha(alpha:Number):void;

  function get globalCompositeOperation():String;

  function set globalCompositeOperation(op:String):void;

  function get strokeStyle():*;

  function set strokeStyle(style:*):void;

  function get fillStyle():*;

  function set fillStyle(style:*):void;

  function createLinearGradient(x0:Number, y0:Number, x1:Number, y1:Number):js.CanvasGradient;

  function createRadialGradient(x0:Number, y0:Number, r0:Number, x1:Number, y1:Number, r1:Number):js.CanvasGradient;

  /**
   * @param image HTMLImageElement, HTMLCanvasElement, or HTMLVideoElement.
   * @param repetition
   * @return
   */
  function createPattern(image:js.HTMLElement, repetition:String):js.CanvasPattern;

  function get lineWidth():Number;

  function set lineWidth(width:Number):void;

  function get lineCap():String;

  function set lineCap(cap:String):void;

  function get lineJoin():String;

  function set lineJoin(join:String):void;

  function get miterLimit():Number;

  function set miterLimit(limit:Number):void;

  function get shadowOffsetX():Number;

  function set shadowOffsetX(x:Number):void;

  function get shadowOffsetY():Number;

  function set shadowOffsetY(y:Number):void;

  function get shadowBlur():Number;

  function set shadowBlur(blur:Number):void;

  function get shadowColor():String;

  function set shadowColor(color:String):void;

  function clearRect(x:Number, y:Number, w:Number, h:Number):void;

  function fillRect(x:Number, y:Number, w:Number, h:Number):void;

  function strokeRect(x:Number, y:Number, w:Number, h:Number):void;

  function beginPath():void;

  function closePath():void;

  function moveTo(x:Number, y:Number):void;

  function lineTo(x:Number, y:Number):void;

  function quadraticCurveTo(cpx:Number, cpy:Number, x:Number, y:Number):void;

  function bezierCurveTo(cp1x:Number, cp1y:Number, cp2x:Number, cp2y:Number, x:Number, y:Number):void;

  function arcTo(x1:Number, y1:Number, x2:Number, y2:Number, radius:Number):void;

  function rect(x:Number, y:Number, w:Number, h:Number):void;

  function arc(x:Number, y:Number, radius:Number, startAngle:Number, endAngle:Number, anticlockwise:Boolean):void;

  function fill():void;

  function stroke():void;

  function clip():void;

  function isPointInPath(x:Number, y:Number):Boolean;

  function get font():String;

  function set font(font:String):void;

  function get textAlign():String;

  function set textAlign(align:String):void;

  function get textBaseline():String;

  function set textBaseline(baseline:String):void;

  function fillText(text:String, x:Number, y:Number, maxWidth:Number = undefined):void;

  function strokeText(text:String, x:Number, y:Number, maxWidth:Number = undefined):void;

  function measureText(text:String):js.TextMetrics;

  /**
   * To draw images onto the canvas, the drawImage method can be used.
   * This method can be invoked with three different sets of arguments:
   * drawImage(image, dx, dy)
   * drawImage(image, dx, dy, dw, dh)
   * drawImage(image, sx, sy, sw, sh, dx, dy, dw, dh)
   * @param image HTMLImageElement, HTMLCanvasElement, or HTMLVideoElement.
   */
  function drawImage(image:js.HTMLElement, dxOrSx:Number, dyOrSy:Number, dwOrSw:Number = undefined, dhOrSh:Number = undefined, dx:Number = undefined, dy:Number = undefined, dw:Number = undefined, dh:Number = undefined):void;

  /**
   * pixel manipulation
   * @param imagedataOrSw - ImageData or Number
   * @param sh
   * @return
   */
  function createImageData(imagedataOrSw:*, sh:Number):js.ImageData;

  function getImageData(sx:Number, sy:Number, sw:Number, sh:Number):js.ImageData;

  function putImageData(imagedata:js.ImageData, dx:Number, dy:Number, dirtyX:Number = undefined, dirtyY:Number = undefined, dirtyWidth:Number = undefined, dirtyHeight:Number = undefined):void;
}
}