/*
 * Decompiled with CFR 0.152.
 */
package net.jadler.stubbing.server.jetty;

import net.jadler.RequestManager;
import net.jadler.stubbing.server.StubHttpServer;
import net.jadler.stubbing.server.jetty.JadlerHandler;
import org.apache.commons.lang.Validate;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.nio.SelectChannelConnector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JettyStubHttpServer
implements StubHttpServer {
    private static final Logger logger = LoggerFactory.getLogger(JettyStubHttpServer.class);
    private final Server server = new Server();
    private final Connector httpConnector;

    public JettyStubHttpServer() {
        this(0);
    }

    public JettyStubHttpServer(int port) {
        this.server.setSendServerVersion(false);
        this.server.setSendDateHeader(true);
        this.httpConnector = new SelectChannelConnector();
        this.httpConnector.setPort(port);
        this.server.addConnector(this.httpConnector);
    }

    public void registerRequestManager(RequestManager ruleProvider) {
        Validate.notNull((Object)ruleProvider, (String)"ruleProvider cannot be null");
        this.server.setHandler((Handler)new JadlerHandler(ruleProvider));
    }

    public void start() throws Exception {
        logger.debug("starting jetty");
        this.server.start();
        logger.debug("jetty started");
    }

    public void stop() throws Exception {
        logger.debug("stopping jetty");
        this.server.stop();
        logger.debug("jetty stopped");
    }

    public int getPort() {
        return this.httpConnector.getLocalPort();
    }
}

