/*
 * Decompiled with CFR 0.152.
 */
package net.jadler.matchers;

import net.jadler.Request;
import net.jadler.exception.JadlerException;
import org.apache.commons.lang.Validate;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.SelfDescribing;

public abstract class RequestMatcher<T>
extends BaseMatcher<Request> {
    protected final Matcher<? super T> pred;

    protected RequestMatcher(Matcher<? super T> pred) {
        Validate.notNull(pred, (String)"pred cannot be null");
        this.pred = pred;
    }

    public void describeMismatch(Object item, Description description) {
        T value;
        try {
            value = this.retrieveValue((Request)item);
        }
        catch (Exception ex) {
            throw new JadlerException("An error occurred while retrieving a value from the http request for mismatch description", ex);
        }
        description.appendText("REQUIRED: ");
        description.appendDescriptionOf((SelfDescribing)this);
        description.appendText(" BUT ");
        this.pred.describeMismatch(value, description);
    }

    public void describeTo(Description description) {
        description.appendText(this.provideDescription());
        description.appendText(" ");
        description.appendDescriptionOf(this.pred);
    }

    public boolean matches(Object o) {
        T value;
        if (!(o instanceof Request)) {
            return false;
        }
        try {
            value = this.retrieveValue((Request)o);
        }
        catch (Exception e) {
            throw new JadlerException("An error occurred while retrieving a value from the http request", e);
        }
        return this.pred.matches(value);
    }

    protected abstract T retrieveValue(Request var1) throws Exception;

    protected abstract String provideDescription();
}

