/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.roi;

import net.imagej.roi.MaskConversionUtil;
import net.imagej.roi.ROIService;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.RealRandomAccessible;
import net.imglib2.RealRandomAccessibleRealInterval;
import net.imglib2.roi.Mask;
import net.imglib2.roi.MaskInterval;
import net.imglib2.roi.MaskPredicate;
import net.imglib2.roi.RealMask;
import net.imglib2.roi.RealMaskRealInterval;
import net.imglib2.type.logic.BoolType;
import org.scijava.convert.ConvertService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.service.AbstractService;
import org.scijava.service.Service;

@Plugin(type=Service.class)
public class DefaultROIService
extends AbstractService
implements ROIService {
    @Parameter
    private ConvertService convertService;

    @Override
    public Mask toMask(Object o) {
        String returnType = "Mask";
        this.checkNull(o, "Mask");
        Mask m = (Mask)this.convertService.convert(o, Mask.class);
        if (m != null) {
            return m;
        }
        RandomAccessible ra = (RandomAccessible)this.convertService.convert(o, MaskConversionUtil.randomAccessibleType());
        if (ra != null && MaskConversionUtil.isBoolType(ra)) {
            return this.toMask(ra);
        }
        throw this.cannotConvert(o, "Mask");
    }

    @Override
    public MaskInterval toMaskInterval(Object o) {
        String returnType = "MaskInterval";
        this.checkNull(o, "MaskInterval");
        MaskInterval mi = (MaskInterval)this.convertService.convert(o, MaskInterval.class);
        if (mi != null) {
            return mi;
        }
        RandomAccessibleInterval rai = (RandomAccessibleInterval)this.convertService.convert(o, MaskConversionUtil.randomAccessibleIntervalType());
        if (rai != null && MaskConversionUtil.isBoolType(rai)) {
            return this.toMaskInterval(rai);
        }
        throw this.cannotConvert(o, "MaskInterval");
    }

    @Override
    public RealMask toRealMask(Object o) {
        String returnType = "RealMask";
        this.checkNull(o, "RealMask");
        RealMask m = (RealMask)this.convertService.convert(o, RealMask.class);
        if (m != null) {
            return m;
        }
        RealRandomAccessible rra = (RealRandomAccessible)this.convertService.convert(o, MaskConversionUtil.realRandomAccessibleType());
        if (rra != null && MaskConversionUtil.isBoolType(rra)) {
            return this.toRealMask(rra);
        }
        throw this.cannotConvert(o, "RealMask");
    }

    @Override
    public RealMaskRealInterval toRealMaskRealInterval(Object o) {
        String returnType = "RealMaskRealInterval";
        this.checkNull(o, "RealMaskRealInterval");
        RealMaskRealInterval mri = (RealMaskRealInterval)this.convertService.convert(o, RealMaskRealInterval.class);
        if (mri != null) {
            return mri;
        }
        RealRandomAccessibleRealInterval rrari = (RealRandomAccessibleRealInterval)this.convertService.convert(o, MaskConversionUtil.realRandomAccessibleRealIntervalType());
        if (rrari != null && MaskConversionUtil.isBoolType(rrari)) {
            return this.toRealMaskRealInterval(rrari);
        }
        throw this.cannotConvert(o, "RealMaskRealInterval");
    }

    @Override
    public MaskPredicate<?> toMaskPredicate(Object o) {
        String returnType = "MaskPredicate";
        this.checkNull(o, "MaskPredicate");
        Mask m = (Mask)this.convertService.convert(o, Mask.class);
        if (m != null) {
            return m;
        }
        RealMask rm = (RealMask)this.convertService.convert(o, RealMask.class);
        if (rm != null) {
            return rm;
        }
        RandomAccessible ra = (RandomAccessible)this.convertService.convert(o, MaskConversionUtil.randomAccessibleType());
        if (ra != null && MaskConversionUtil.isBoolType(ra)) {
            return this.toMask(ra);
        }
        RealRandomAccessible rra = (RealRandomAccessible)this.convertService.convert(o, MaskConversionUtil.realRandomAccessibleType());
        if (rra != null && MaskConversionUtil.isBoolType(rra)) {
            return this.toRealMask(rra);
        }
        throw this.cannotConvert(o, "MaskPredicate");
    }

    @Override
    public RandomAccessible<BoolType> toRandomAcessible(Object o) {
        String returnType = "RandomAccessible<BoolType>";
        this.checkNull(o, "RandomAccessible<BoolType>");
        RandomAccessible ra = (RandomAccessible)this.convertService.convert(o, MaskConversionUtil.randomAccessibleType());
        if (ra != null && MaskConversionUtil.isBoolType(ra)) {
            return ra;
        }
        Mask m = (Mask)this.convertService.convert(o, Mask.class);
        if (m != null) {
            return this.toRandomAcessible(m);
        }
        throw this.cannotConvert(o, "RandomAccessible<BoolType>");
    }

    @Override
    public RandomAccessibleInterval<BoolType> toRandomAccessibleInterval(Object o) {
        String returnType = "RandomAccessibleInterval<BoolType>";
        this.checkNull(o, "RandomAccessibleInterval<BoolType>");
        RandomAccessibleInterval rai = (RandomAccessibleInterval)this.convertService.convert(o, MaskConversionUtil.randomAccessibleIntervalType());
        if (rai != null && MaskConversionUtil.isBoolType(rai)) {
            return rai;
        }
        MaskInterval mi = (MaskInterval)this.convertService.convert(o, MaskInterval.class);
        if (mi != null) {
            return this.toRandomAccessibleInterval(mi);
        }
        throw this.cannotConvert(o, "RandomAccessibleInterval<BoolType>");
    }

    @Override
    public RealRandomAccessible<BoolType> toRealRandomAccessible(Object o) {
        String returnType = "RealRandomAccessible<BoolType>";
        this.checkNull(o, "RealRandomAccessible<BoolType>");
        RealRandomAccessible rra = (RealRandomAccessible)this.convertService.convert(o, MaskConversionUtil.realRandomAccessibleType());
        if (rra != null && MaskConversionUtil.isBoolType(rra)) {
            return rra;
        }
        RealMask m = (RealMask)this.convertService.convert(o, RealMask.class);
        if (m != null) {
            return this.toRealRandomAccessible(m);
        }
        throw this.cannotConvert(o, "RealRandomAccessible<BoolType>");
    }

    @Override
    public RealRandomAccessibleRealInterval<BoolType> toRealRandomAccessibleRealInterval(Object o) {
        String returnType = "RealRandomAccessibleRealInterval<BoolType>";
        this.checkNull(o, "RealRandomAccessibleRealInterval<BoolType>");
        RealRandomAccessibleRealInterval rrari = (RealRandomAccessibleRealInterval)this.convertService.convert(o, MaskConversionUtil.realRandomAccessibleRealIntervalType());
        if (rrari != null && MaskConversionUtil.isBoolType(rrari)) {
            return rrari;
        }
        RealMaskRealInterval mri = (RealMaskRealInterval)this.convertService.convert(o, RealMaskRealInterval.class);
        if (mri != null) {
            return this.toRealRandomAccessibleRealInterval(mri);
        }
        throw this.cannotConvert(o, "RealRandomAccessibleRealInterval<BoolType>");
    }

    private void checkNull(Object o, String s) {
        if (o == null) {
            throw new IllegalArgumentException("Cannot convert null to " + s);
        }
    }

    private IllegalArgumentException cannotConvert(Object o, String s) {
        return new IllegalArgumentException("Cannot convert " + o.getClass() + " to " + s);
    }
}

