/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.convert;

import java.lang.reflect.Type;
import java.util.List;
import net.imglib2.FinalInterval;
import org.scijava.convert.AbstractConverter;
import org.scijava.convert.ConvertService;
import org.scijava.convert.Converter;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Converter.class, priority=-100.0)
public class ConvertListToFinalInterval
extends AbstractConverter<List, FinalInterval> {
    @Parameter
    private ConvertService convertService;

    public boolean canConvert(Object src, Type dest) {
        return super.canConvert(src, dest) && this.convertService.supports(src, long[].class);
    }

    public boolean canConvert(Object src, Class<?> dest) {
        return super.canConvert(src, dest) && this.convertService.supports(src, long[].class);
    }

    public boolean canConvert(Class<?> src, Class<?> dest) {
        return super.canConvert(src, dest) && this.convertService.supports(src, long[].class);
    }

    public Class<FinalInterval> getOutputType() {
        return FinalInterval.class;
    }

    public Class<List> getInputType() {
        return List.class;
    }

    public <T> T convert(Object src, Class<T> dest) {
        long[] longs = (long[])this.convertService.convert(src, long[].class);
        return (T)new FinalInterval(longs);
    }

    @Deprecated
    public boolean canConvert(Class<?> src, Type dest) {
        return super.canConvert(src, dest) && this.convertService.supports(src, long[].class);
    }
}

