/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.frame;

import ij.CompositeImage;
import ij.IJ;
import ij.ImageJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.GUI;
import ij.gui.GenericDialog;
import ij.gui.HTMLDialog;
import ij.gui.TrimmedButton;
import ij.plugin.PlugIn;
import ij.plugin.frame.PlugInDialog;
import ij.plugin.frame.Recorder;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

public class Channels
extends PlugInDialog
implements PlugIn,
ItemListener,
ActionListener {
    private static final String[] modes = new String[]{"Composite", "Color", "Grayscale", "---------", "Composite Max", "Composite Min", "Composite Invert"};
    private static final int COMP = 0;
    private static final int COLOR = 1;
    private static final int GRAY = 2;
    private static final int DIVIDER = 3;
    private static final int MAX = 4;
    private static final int MIN = 5;
    private static final int INVERT = 6;
    private static String[] menuItems = new String[]{"Make Composite", "Create RGB Image", "Split Channels", "Merge Channels...", "Show LUT", "Invert LUTs", "-", "Red", "Green", "Blue", "Cyan", "Magenta", "Yellow", "Grays"};
    private static String moreLabel = "More \u00bb";
    public static final String help = "<html><h1>Composite Display Modes</h1><font size=+1><ul><li> <u>Composite</u> -  Effectively creates an RGB image for each channel, based on its LUT, and then adds the red, green and blue values to create the displayed image. The values are clipped at 255, which can cause saturation. For an example, open the \"Neuron (5 channel)\" sample image and compare the <i>Composite</i> and <i>Composite Max</i> display modes. This is the original ImageJ composite mode.<br><li> <u>Composite Max</u> - Similar to <i>Composite</i>, except uses the maximum of the red, green and blue values across all channels.<br><li> <u>Composite Min</u> - Similar to <i>Composite</i>, except uses the minimum of the red, green and blue values across all channels. This mode, and <i>Composite Invert</i>, require that the channels have inverting (white background) LUTs. Linear non-inverting LUTs that use a single color are automatically inverted.<br><li> <u>Composite Invert</u> - Similar to <i>Composite</i>, except the red, green and blue values are effectively subracted from 255. The values are clipped at 0, which can cause saturation.<br></ul><h1>More\u00bbCommands</h1><font size=+1><ul><li> <u>Make Composite</u> - Converts an RGB image into a three channel composite image.<br><li> <u>Create RGB image</u> - Creates an RGB version of a multichannel image.<br><li> <u>Split Channels</u> - Splits a multichannel image into separate images.<br><li> <u>Merge Channels</u> - Combines multiple images into a single multichannel image.<br><li> <u>Show LUT</u> - Displays a plot of the current channel's LUT. Click \"List\" to create a table of the RGB values for each of the LUT's 256 entries.<br><li> <u>Invert LUTs</u> - Inverts the LUTs of all the channels of a composite image. Black background LUTs with ascending RGB values are converted to inverting LUTs (descending RGB values) with white backgrounds, or vis versa. Does nothing if the LUT is not linear or it uses more than one color. This command runs the macro at http://wsr.imagej.net/macros/Invert_All_LUTs.txt.<br><li> <u>Red, Green, Blue, Cyan, Magenta, Yellow, Grays</u> - Updates the current channel's LUT so that it uses the selected color.<br></ul><br>The <i>\"Channels & Colors\"</i> chapter of Pete Bankhead's \"<i>Introduction to Bioimage Analysis</i>\" (https://bioimagebook.github.io) is a good introduction to multichannel images and LUTs.<br><br>The macro at http://wsr.imagej.net/macros/CompositeProjection.ijm uses the \"Invert LUTs\", \"RGB Stack\", \"Z Project\" and \"Invert\" commands to reproduce the four composite display modes.<br></font>";
    private Choice choice;
    private Checkbox[] checkbox;
    private Button helpButton;
    private Button moreButton;
    private static Channels instance;
    private int id;
    private static Point location;
    private PopupMenu pm;

    public Channels() {
        super("Channels");
        int nCheckBoxes;
        if (instance != null) {
            instance.toFront();
            return;
        }
        ImageJ ij = IJ.getInstance();
        WindowManager.addWindow(this);
        instance = this;
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        this.setLayout(gridbag);
        int y = 0;
        c.gridx = 0;
        c.gridy = y++;
        c.gridwidth = 1;
        c.fill = 1;
        c.anchor = 10;
        int margin = 32;
        if (IJ.isMacOSX()) {
            margin = 20;
        }
        c.insets = new Insets(10, margin, 10, margin);
        this.choice = new Choice();
        for (int i = 0; i < modes.length; ++i) {
            this.choice.addItem(modes[i]);
        }
        this.choice.select(0);
        this.choice.addItemListener(this);
        if (ij != null) {
            this.choice.addKeyListener(ij);
        }
        this.add((Component)this.choice, c);
        CompositeImage ci = this.getImage();
        int n = nCheckBoxes = ci != null ? ci.getNChannels() : 3;
        if (nCheckBoxes > 8) {
            nCheckBoxes = 8;
        }
        this.checkbox = new Checkbox[nCheckBoxes];
        for (int i = 0; i < nCheckBoxes; ++i) {
            this.checkbox[i] = new Checkbox("Channel " + (i + 1), true);
            c.insets = new Insets(0, 25, i < nCheckBoxes - 1 ? 0 : 10, 5);
            c.gridy = y++;
            this.add((Component)this.checkbox[i], c);
            this.checkbox[i].addItemListener(this);
            this.checkbox[i].addKeyListener(ij);
        }
        c.insets = new Insets(0, 15, 10, 15);
        c.fill = 0;
        c.gridwidth = 2;
        c.gridy = y++;
        Panel panel = new Panel();
        int hgap = IJ.isMacOSX() ? 1 : 5;
        panel.setLayout(new FlowLayout(2, hgap, 0));
        this.helpButton = new TrimmedButton("Help", IJ.isMacOSX() ? 10 : 0);
        this.helpButton.addActionListener(this);
        this.helpButton.addKeyListener(ij);
        panel.add((Component)this.helpButton, c);
        this.add((Component)panel, c);
        this.moreButton = new TrimmedButton(moreLabel, IJ.isMacOSX() ? 10 : 0);
        this.moreButton.addActionListener(this);
        this.moreButton.addKeyListener(ij);
        panel.add((Component)this.moreButton, c);
        this.update();
        this.pm = new PopupMenu();
        GUI.scalePopupMenu(this.pm);
        for (int i = 0; i < menuItems.length; ++i) {
            this.addPopupItem(menuItems[i]);
        }
        this.add(this.pm);
        this.addKeyListener(ij);
        this.setResizable(false);
        GUI.scale(this);
        this.pack();
        if (location == null) {
            GUI.centerOnImageJScreen(this);
            location = this.getLocation();
        } else {
            this.setLocation(location);
        }
        this.show();
    }

    public void update() {
        CompositeImage ci = this.getImage();
        if (ci == null || this.checkbox == null) {
            return;
        }
        int n = this.checkbox.length;
        int nChannels = ci.getNChannels();
        if (nChannels != n && nChannels <= 8) {
            instance = null;
            location = this.getLocation();
            this.close();
            new Channels();
            return;
        }
        boolean[] active = ci.getActiveChannels();
        for (int i = 0; i < this.checkbox.length; ++i) {
            this.checkbox[i].setState(active[i]);
        }
        int index = 0;
        String cmode = ci.getProp("CompositeProjection");
        int cindex = 0;
        if (cmode != null) {
            if (cmode.contains("Max") || cmode.contains("max")) {
                cindex = 4;
            }
            if (cmode.contains("Min") || cmode.contains("min")) {
                cindex = 5;
            }
            if (cmode.contains("Invert") || cmode.contains("invert")) {
                cindex = 6;
            }
        }
        switch (ci.getMode()) {
            case 1: {
                index = cindex;
                break;
            }
            case 2: {
                index = 1;
                break;
            }
            case 3: {
                index = 2;
            }
        }
        this.choice.select(index);
    }

    public static void updateChannels() {
        if (instance != null) {
            instance.update();
        }
    }

    void addPopupItem(String s) {
        MenuItem mi = new MenuItem(s);
        mi.addActionListener(this);
        this.pm.add(mi);
    }

    CompositeImage getImage() {
        ImagePlus imp = WindowManager.getCurrentImage();
        if (imp == null || !imp.isComposite()) {
            return null;
        }
        return (CompositeImage)imp;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        ImagePlus imp = WindowManager.getCurrentImage();
        if (imp == null) {
            return;
        }
        if (!imp.isComposite()) {
            int channels = imp.getNChannels();
            if (channels == 1 && imp.getStackSize() <= 4) {
                channels = imp.getStackSize();
            }
            if (imp.getBitDepth() == 24 || channels > 1 && channels < 8) {
                GenericDialog gd = new GenericDialog(imp.getTitle());
                gd.addMessage("Convert to multichannel composite image?");
                gd.showDialog();
                if (gd.wasCanceled()) {
                    return;
                }
                IJ.doCommand("Make Composite");
            } else {
                IJ.error("Channels", "A composite image is required (e.g., " + moreLabel + " Open HeLa Cells),\nor create one using " + moreLabel + " Make Composite.");
                return;
            }
        }
        if (!imp.isComposite()) {
            return;
        }
        CompositeImage ci = (CompositeImage)imp;
        Object source = e.getSource();
        if (source == this.choice) {
            int index = ((Choice)source).getSelectedIndex();
            String cstr = null;
            int cmode = 1;
            switch (index) {
                case 0: {
                    cmode = 1;
                    cstr = "Sum";
                    break;
                }
                case 1: {
                    cmode = 2;
                    break;
                }
                case 2: {
                    cmode = 3;
                    break;
                }
                case 3: {
                    cmode = 1;
                    cstr = "Sum";
                    break;
                }
                case 4: {
                    cmode = 1;
                    cstr = "Max";
                    break;
                }
                case 5: {
                    cmode = 1;
                    cstr = "Min";
                    break;
                }
                case 6: {
                    cmode = 1;
                    cstr = "Invert";
                }
            }
            if (!(cstr == null || cstr.equals("Sum") && ci.getProp("CompositeProjection") == null)) {
                ci.setProp("CompositeProjection", cstr);
            }
            if (cmode == 1 && ("Min".equals(cstr) || "Invert".equals(cstr)) && !imp.isInvertedLut() || ("Max".equals(cstr) || "Sum".equals(cstr)) && imp.isInvertedLut()) {
                IJ.runMacroFile("ij.jar:InvertAllLuts", null);
            }
            ci.setMode(cmode);
            ci.updateAndDraw();
            if (Recorder.record) {
                String mode = null;
                if (index != 3 && Recorder.scriptMode()) {
                    switch (index) {
                        case 0: 
                        case 4: 
                        case 5: 
                        case 6: {
                            mode = "IJ.COMPOSITE";
                            break;
                        }
                        case 1: {
                            mode = "IJ.COLOR";
                            break;
                        }
                        case 2: {
                            mode = "IJ.GRAYSCALE";
                        }
                    }
                    cstr = "\"" + cstr + "\"";
                    Recorder.recordCall("imp.setProp(\"CompositeProjection\", " + cstr + ");");
                    Recorder.recordCall("imp.setDisplayMode(" + mode + ");");
                } else {
                    switch (index) {
                        case 0: 
                        case 4: 
                        case 5: 
                        case 6: {
                            mode = "composite";
                            break;
                        }
                        case 1: {
                            mode = "color";
                            break;
                        }
                        case 2: {
                            mode = "grayscale";
                        }
                    }
                    Recorder.recordString("Property.set(\"CompositeProjection\", \"" + cstr + "\");\n");
                    Recorder.record("Stack.setDisplayMode", mode);
                }
            }
        } else if (source instanceof Checkbox) {
            for (int i = 0; i < this.checkbox.length; ++i) {
                Checkbox cb = (Checkbox)source;
                if (cb != this.checkbox[i]) continue;
                if (ci.getMode() == 1) {
                    boolean[] active = ci.getActiveChannels();
                    active[i] = cb.getState();
                    if (Recorder.record) {
                        String str = "";
                        for (int c = 0; c < ci.getNChannels(); ++c) {
                            str = str + (active[c] ? "1" : "0");
                        }
                        if (Recorder.scriptMode()) {
                            Recorder.recordCall("imp.setActiveChannels(\"" + str + "\");");
                        } else {
                            Recorder.record("Stack.setActiveChannels", str);
                        }
                    }
                } else {
                    imp.setPosition(i + 1, imp.getSlice(), imp.getFrame());
                    if (Recorder.record) {
                        if (Recorder.scriptMode()) {
                            Recorder.recordCall("imp.setC(" + (i + 1) + ");");
                        } else {
                            Recorder.record("Stack.setChannel", i + 1);
                        }
                    }
                }
                ci.updateAndDraw();
                return;
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.helpButton) {
            new HTMLDialog("Channels", help, false);
            return;
        }
        String command = e.getActionCommand();
        if (command == null) {
            return;
        }
        if (command.equals(moreLabel)) {
            Point bloc = this.moreButton.getLocation();
            this.pm.show(this, bloc.x, bloc.y);
        } else if (command.equals("Create RGB Image")) {
            IJ.doCommand("Stack to RGB");
        } else {
            IJ.doCommand(command);
        }
    }

    public static Frame getInstance() {
        return null;
    }

    @Override
    public void close() {
        super.close();
        instance = null;
        location = this.getLocation();
    }
}

