/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.LookUpTable;
import ij.Prefs;
import ij.gui.ImageCanvas;
import ij.plugin.filter.LutWindow;
import ij.plugin.filter.PlugInFilter;
import ij.process.ImageProcessor;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.IndexColorModel;

public class LutViewer
implements PlugInFilter {
    private double guiScale = Prefs.getGuiScale();
    private ImagePlus imp;

    @Override
    public int setup(String arg, ImagePlus imp) {
        this.imp = imp;
        return 415;
    }

    @Override
    public void run(ImageProcessor ip) {
        int y2;
        int x2;
        int i;
        if (ip.getNChannels() == 3) {
            IJ.error("RGB images do not have LUTs.");
            return;
        }
        int xMargin = (int)(35.0 * this.guiScale);
        int yMargin = (int)(20.0 * this.guiScale);
        int width = (int)(256.0 * this.guiScale);
        int height = (int)(128.0 * this.guiScale);
        int barHeight = (int)(12.0 * this.guiScale);
        ip = this.imp.getChannelProcessor();
        IndexColorModel cm = (IndexColorModel)ip.getColorModel();
        LookUpTable lut = new LookUpTable(cm);
        int mapSize = lut.getMapSize();
        byte[] reds = lut.getReds();
        byte[] greens = lut.getGreens();
        byte[] blues = lut.getBlues();
        boolean isGray = lut.isGrayscale();
        int imageWidth = width + 2 * xMargin;
        int imageHeight = height + 3 * yMargin;
        Image img = IJ.getInstance().createImage(imageWidth, imageHeight);
        Graphics2D g = (Graphics2D)img.getGraphics();
        g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g.setFont(new Font("SansSerif", 0, (int)(12.0 * this.guiScale)));
        g.setColor(Color.white);
        g.fillRect(0, 0, imageWidth, imageHeight);
        g.setColor(Color.black);
        g.drawRect(xMargin, yMargin, width, height);
        double scale = 256.0 * this.guiScale / (double)mapSize;
        if (isGray) {
            g.setColor(Color.black);
        } else {
            g.setColor(Color.red);
        }
        int x1 = xMargin;
        int y1 = yMargin + height - (reds[0] & 0xFF) / 2;
        for (i = 0; i < 256; ++i) {
            x2 = xMargin + (int)((double)i * this.guiScale);
            y2 = yMargin + height - (int)((double)(reds[i] & 0xFF) * this.guiScale / 2.0);
            g.drawLine(x1, y1, x2, y2);
            x1 = x2;
            y1 = y2;
        }
        if (!isGray) {
            g.setColor(Color.green);
            x1 = xMargin;
            y1 = yMargin + height - (int)((double)(greens[0] & 0xFF) * this.guiScale / 2.0);
            for (i = 0; i < 256; ++i) {
                x2 = xMargin + (int)((double)i * this.guiScale);
                y2 = yMargin + height - (int)((double)(greens[i] & 0xFF) * this.guiScale / 2.0);
                g.drawLine(x1, y1, x2, y2);
                x1 = x2;
                y1 = y2;
            }
        }
        if (!isGray) {
            g.setColor(Color.blue);
            x1 = xMargin;
            y1 = yMargin + height - (int)((double)(blues[0] & 0xFF) * this.guiScale / 2.0);
            for (i = 0; i < 255; ++i) {
                x2 = xMargin + (int)((double)i * this.guiScale);
                y2 = yMargin + height - (int)((double)(blues[i] & 0xFF) * this.guiScale / 2.0);
                g.drawLine(x1, y1, x2, y2);
                x1 = x2;
                y1 = y2;
            }
        }
        int x = xMargin;
        int y = yMargin + height + (int)(2.0 * this.guiScale);
        lut.drawColorBar(g, x, y, (int)(256.0 * this.guiScale), barHeight);
        g.setColor(Color.black);
        g.drawString("0", x - (int)(4.0 * this.guiScale), y += barHeight + (int)(15.0 * this.guiScale));
        g.drawString("" + (mapSize - 1), x + width - (int)(10.0 * this.guiScale), y);
        g.drawString("255", (int)(7.0 * this.guiScale), yMargin + (int)(4.0 * this.guiScale));
        g.dispose();
        ImagePlus imp = new ImagePlus("Look-Up Table", img);
        new LutWindow(imp, new ImageCanvas(imp), ip);
    }
}

