/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImageJ;
import ij.ImagePlus;
import ij.gui.ImageWindow;
import ij.gui.Overlay;
import ij.gui.TextRoi;
import ij.plugin.PlugIn;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import java.awt.Color;
import java.awt.Font;
import java.awt.Image;
import java.awt.image.ImageProducer;
import java.net.URL;

public class AboutBox
implements PlugIn {
    private static final int SMALL_FONT = 20;
    private static final int LARGE_FONT = 45;
    private static final Color TEXT_COLOR = new Color(255, 255, 80);

    @Override
    public void run(String arg) {
        System.gc();
        int lines = 7;
        String[] text = new String[lines];
        text[0] = "ImageJ 1.54d";
        text[1] = "Wayne Rasband and contributors";
        text[2] = "National Institutes of Health, USA";
        text[3] = "http://imagej.org";
        text[4] = "Java " + System.getProperty("java.version") + (IJ.is64Bit() ? " (64-bit)" : " (32-bit)");
        text[5] = IJ.freeMemory();
        text[6] = "ImageJ is in the public domain";
        ImageProcessor ip = null;
        ImageJ ij = IJ.getInstance();
        URL url = ij.getClass().getResource("/about.jpg");
        if (url != null) {
            Image img = null;
            try {
                img = ij.createImage((ImageProducer)url.getContent());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (img != null) {
                ImagePlus sImp = new ImagePlus("", img);
                ip = sImp.getProcessor();
            }
        }
        if (ip == null) {
            ip = new ColorProcessor(55, 45);
        }
        ip = ip.resize(ip.getWidth() * 6, ip.getHeight() * 6);
        ImagePlus imp = new ImagePlus("About ImageJ", ip);
        int width = imp.getWidth();
        Overlay overlay = new Overlay();
        Font font = new Font("SansSerif", 0, 45);
        int y = 60;
        this.add(text[0], width - 20, y, font, 2, overlay);
        int xcenter = 410;
        font = new Font("SansSerif", 0, 20);
        this.add(text[1], xcenter, y += 45, font, 1, overlay);
        this.add(text[2], xcenter, y += 27, font, 1, overlay);
        this.add(text[3], xcenter, y += 27, font, 1, overlay);
        this.add(text[4], xcenter, y += 27, font, 1, overlay);
        if (IJ.maxMemory() > 0L) {
            this.add(text[5], xcenter, y += 27, font, 1, overlay);
        }
        this.add(text[6], width - 10, ip.getHeight() - 10, font, 2, overlay);
        imp.setOverlay(overlay);
        ImageWindow.centerNextImage();
        imp.show();
    }

    private void add(String text, int x, int y, Font font, int justification, Overlay overlay) {
        TextRoi roi = new TextRoi(text, (double)x, (double)y, font);
        roi.setStrokeColor(TEXT_COLOR);
        roi.setJustification(justification);
        overlay.add(roi);
    }
}

