/*
 * Decompiled with CFR 0.152.
 */
package ij;

import ij.IJ;
import ij.ImagePlus;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.IntProcessor;
import ij.process.ShortProcessor;
import java.awt.Rectangle;
import java.awt.image.ColorModel;

public class ImageStack {
    static final int INITIAL_SIZE = 25;
    static final String outOfRange = "Stack argument out of range: ";
    private int bitDepth = 0;
    private int nSlices = 0;
    private Object[] stack;
    private String[] label;
    private int width;
    private int height;
    private Rectangle roi;
    private ColorModel cm;
    private double min = Double.MAX_VALUE;
    private double max;
    protected float[] cTable;
    private int viewers;
    private boolean signedInt;

    public ImageStack() {
    }

    public ImageStack(int width, int height) {
        this(width, height, null);
    }

    public ImageStack(int width, int height, int size) {
        this.width = width;
        this.height = height;
        this.stack = new Object[size];
        this.label = new String[size];
        this.nSlices = size;
    }

    public ImageStack(int width, int height, ColorModel cm) {
        this.width = width;
        this.height = height;
        this.cm = cm;
        this.stack = new Object[25];
        this.label = new String[25];
        this.nSlices = 0;
    }

    public void addSlice(String sliceLabel, Object pixels) {
        if (pixels == null) {
            throw new IllegalArgumentException("'pixels' is null!");
        }
        if (!pixels.getClass().isArray()) {
            throw new IllegalArgumentException("'pixels' is not an array");
        }
        int size = this.stack.length;
        ++this.nSlices;
        if (this.nSlices >= size) {
            Object[] tmp1 = new Object[size * 2];
            System.arraycopy(this.stack, 0, tmp1, 0, size);
            this.stack = tmp1;
            String[] tmp2 = new String[size * 2];
            System.arraycopy(this.label, 0, tmp2, 0, size);
            this.label = tmp2;
        }
        this.stack[this.nSlices - 1] = pixels;
        this.label[this.nSlices - 1] = sliceLabel;
        if (this.bitDepth == 0) {
            this.setBitDepth(pixels);
        }
    }

    private void setBitDepth(Object pixels) {
        if (pixels == null) {
            return;
        }
        if (pixels instanceof byte[]) {
            this.bitDepth = 8;
        } else if (pixels instanceof short[]) {
            this.bitDepth = 16;
        } else if (pixels instanceof float[]) {
            this.bitDepth = 32;
        } else if (pixels instanceof int[]) {
            this.bitDepth = 24;
        }
    }

    public void addUnsignedShortSlice(String sliceLabel, Object pixels) {
        this.addSlice(sliceLabel, pixels);
    }

    public void addSlice(ImageProcessor ip) {
        this.addSlice(null, ip);
    }

    public void addSlice(String sliceLabel, ImageProcessor ip) {
        if ((ip = this.convertType(ip)).getWidth() != this.width || ip.getHeight() != this.height) {
            if (this.width == 0 && this.height == 0) {
                this.init(ip.getWidth(), ip.getHeight());
            } else {
                ImageProcessor ip2 = ip.createProcessor(this.width, this.height);
                ip2.insert(ip, 0, 0);
                ip = ip2;
            }
        }
        if (this.nSlices == 0) {
            this.cm = ip.getColorModel();
            this.min = ip.getMin();
            this.max = ip.getMax();
        }
        this.addSlice(sliceLabel, ip.getPixels());
    }

    private void init(int width, int height) {
        this.width = width;
        this.height = height;
        this.stack = new Object[25];
        this.label = new String[25];
    }

    private ImageProcessor convertType(ImageProcessor ip) {
        int newBitDepth = ip.getBitDepth();
        if (this.bitDepth == 0) {
            this.bitDepth = newBitDepth;
        }
        if (this.bitDepth != newBitDepth) {
            switch (this.bitDepth) {
                case 8: {
                    ip = ip.convertToByte(true);
                    break;
                }
                case 16: {
                    ip = ip.convertToShort(true);
                    break;
                }
                case 24: {
                    ip = ip.convertToRGB();
                    break;
                }
                case 32: {
                    ip = ip.convertToFloat();
                }
            }
        }
        return ip;
    }

    public void addSlice(String sliceLabel, ImageProcessor ip, int n) {
        if (n < 0 || n > this.nSlices) {
            throw new IllegalArgumentException(outOfRange + n);
        }
        this.addSlice(sliceLabel, ip);
        Object tempSlice = this.stack[this.nSlices - 1];
        String tempLabel = this.label[this.nSlices - 1];
        int first = n > 0 ? n : 1;
        for (int i = this.nSlices - 1; i >= first; --i) {
            this.stack[i] = this.stack[i - 1];
            this.label[i] = this.label[i - 1];
        }
        this.stack[n] = tempSlice;
        this.label[n] = tempLabel;
    }

    public void deleteSlice(int n) {
        if (n < 1 || n > this.nSlices) {
            throw new IllegalArgumentException(outOfRange + n);
        }
        if (this.nSlices < 1) {
            return;
        }
        for (int i = n; i < this.nSlices; ++i) {
            this.stack[i - 1] = this.stack[i];
            this.label[i - 1] = this.label[i];
        }
        this.stack[this.nSlices - 1] = null;
        this.label[this.nSlices - 1] = null;
        --this.nSlices;
    }

    public void deleteLastSlice() {
        if (this.nSlices > 0) {
            this.deleteSlice(this.nSlices);
        }
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setRoi(Rectangle roi) {
        this.roi = roi;
    }

    public Rectangle getRoi() {
        if (this.roi == null) {
            return new Rectangle(0, 0, this.width, this.height);
        }
        return this.roi;
    }

    public void update(ImageProcessor ip) {
        if (ip != null) {
            this.min = ip.getMin();
            this.max = ip.getMax();
            this.cTable = ip.getCalibrationTable();
            this.cm = ip.getColorModel();
        }
    }

    public Object getPixels(int n) {
        if (n < 1 || n > this.nSlices) {
            throw new IllegalArgumentException(outOfRange + n);
        }
        return this.stack[n - 1];
    }

    public void setPixels(Object pixels, int n) {
        if (n < 1 || n > this.nSlices) {
            throw new IllegalArgumentException(outOfRange + n);
        }
        this.stack[n - 1] = pixels;
        if (this.bitDepth == 0) {
            this.setBitDepth(pixels);
        }
    }

    public Object[] getImageArray() {
        return this.stack;
    }

    public int size() {
        return this.getSize();
    }

    public int getSize() {
        return this.nSlices;
    }

    public String[] getSliceLabels() {
        if (this.nSlices == 0) {
            return null;
        }
        return this.label;
    }

    public String getSliceLabel(int n) {
        if (n < 1 || n > this.nSlices) {
            return null;
        }
        return this.label[n - 1];
    }

    public String getShortSliceLabel(int n) {
        return this.getShortSliceLabel(n, 60);
    }

    public String getShortSliceLabel(int n, int max) {
        int len;
        String shortLabel = this.getSliceLabel(n);
        if (shortLabel == null) {
            return null;
        }
        int newline = shortLabel.indexOf(10);
        if (newline == 0) {
            return null;
        }
        if (newline > 0) {
            shortLabel = shortLabel.substring(0, newline);
        }
        if ((len = shortLabel.length()) > 4 && shortLabel.charAt(len - 4) == '.' && !Character.isDigit(shortLabel.charAt(len - 1))) {
            shortLabel = shortLabel.substring(0, len - 4);
        }
        if (shortLabel.length() > max) {
            shortLabel = shortLabel.substring(0, max);
        }
        return shortLabel;
    }

    public void setSliceLabel(String label, int n) {
        if (n < 1 || n > this.nSlices) {
            throw new IllegalArgumentException(outOfRange + n);
        }
        this.label[n - 1] = label;
    }

    public ImageProcessor getProcessor(int n) {
        ImageProcessor ip;
        if (n < 1 || n > this.nSlices) {
            throw new IllegalArgumentException(outOfRange + n);
        }
        if (this.nSlices == 0) {
            return null;
        }
        if (this.stack[n - 1] == null) {
            throw new IllegalArgumentException("Pixel array is null");
        }
        if (this.stack[n - 1] instanceof byte[]) {
            ip = new ByteProcessor(this.width, this.height, null, this.cm);
        } else if (this.stack[n - 1] instanceof short[]) {
            ip = new ShortProcessor(this.width, this.height, null, this.cm);
        } else if (this.stack[n - 1] instanceof int[]) {
            ip = this.signedInt ? new IntProcessor(this.width, this.height) : new ColorProcessor(this.width, this.height, null);
        } else if (this.stack[n - 1] instanceof float[]) {
            ip = new FloatProcessor(this.width, this.height, null, this.cm);
        } else {
            throw new IllegalArgumentException("Unknown stack type");
        }
        ip.setPixels(this.stack[n - 1]);
        if (this.min != Double.MAX_VALUE && ip != null && !(ip instanceof ColorProcessor)) {
            ip.setMinAndMax(this.min, this.max);
        }
        if (this.cTable != null) {
            ip.setCalibrationTable(this.cTable);
        }
        return ip;
    }

    public void setProcessor(ImageProcessor ip, int n) {
        if (n < 1 || n > this.nSlices) {
            throw new IllegalArgumentException(outOfRange + n);
        }
        if ((ip = this.convertType(ip)).getWidth() != this.width || ip.getHeight() != this.height) {
            throw new IllegalArgumentException("Wrong dimensions for this stack");
        }
        this.stack[n - 1] = ip.getPixels();
    }

    public void setColorModel(ColorModel cm) {
        this.cm = cm;
    }

    public ColorModel getColorModel() {
        return this.cm;
    }

    public boolean isRGB() {
        return this.nSlices == 3 && this.stack[0] instanceof byte[] && this.getSliceLabel(1) != null && this.getSliceLabel(1).equals("Red");
    }

    public boolean isHSB() {
        return this.nSlices == 3 && this.bitDepth == 8 && this.getSliceLabel(1) != null && this.getSliceLabel(1).equals("Hue");
    }

    public boolean isHSB32() {
        return this.nSlices == 3 && this.bitDepth == 32 && this.getSliceLabel(1) != null && this.getSliceLabel(1).equals("Hue");
    }

    public boolean isLab() {
        return this.nSlices == 3 && this.getSliceLabel(1) != null && this.getSliceLabel(1).equals("L*");
    }

    public boolean isVirtual() {
        return false;
    }

    public void trim() {
        int n = (int)Math.round(Math.log(this.nSlices) + 1.0);
        for (int i = 0; i < n; ++i) {
            this.deleteLastSlice();
            System.gc();
        }
    }

    public String toString() {
        String v = this.isVirtual() ? "(V)" : "";
        return "stack[" + this.getWidth() + "x" + this.getHeight() + "x" + this.size() + v + "]";
    }

    public final double getVoxel(int x, int y, int z) {
        if (x >= 0 && x < this.width && y >= 0 && y < this.height && z >= 0 && z < this.nSlices) {
            switch (this.bitDepth) {
                case 8: {
                    byte[] bytes = (byte[])this.stack[z];
                    return bytes[y * this.width + x] & 0xFF;
                }
                case 16: {
                    short[] shorts = (short[])this.stack[z];
                    return shorts[y * this.width + x] & 0xFFFF;
                }
                case 32: {
                    float[] floats = (float[])this.stack[z];
                    return floats[y * this.width + x];
                }
                case 24: {
                    int[] ints = (int[])this.stack[z];
                    return ints[y * this.width + x] & 0xFFFFFFFF;
                }
            }
            return Double.NaN;
        }
        throw new IndexOutOfBoundsException();
    }

    public final void setVoxel(int x, int y, int z, double value) {
        if (x >= 0 && x < this.width && y >= 0 && y < this.height && z >= 0 && z < this.nSlices) {
            switch (this.bitDepth) {
                case 8: {
                    byte[] bytes = (byte[])this.stack[z];
                    if (value > 255.0) {
                        value = 255.0;
                    } else if (value < 0.0) {
                        value = 0.0;
                    }
                    bytes[y * this.width + x] = (byte)(value + 0.5);
                    break;
                }
                case 16: {
                    short[] shorts = (short[])this.stack[z];
                    if (value > 65535.0) {
                        value = 65535.0;
                    } else if (value < 0.0) {
                        value = 0.0;
                    }
                    shorts[y * this.width + x] = (short)(value + 0.5);
                    break;
                }
                case 32: {
                    float[] floats = (float[])this.stack[z];
                    floats[y * this.width + x] = (float)value;
                    break;
                }
                case 24: {
                    int[] ints = (int[])this.stack[z];
                    ints[y * this.width + x] = (int)value;
                }
            }
        }
    }

    public float[] getVoxels(int x0, int y0, int z0, int w, int h, int d, float[] voxels) {
        boolean inBounds;
        boolean bl = inBounds = x0 >= 0 && x0 + w <= this.width && y0 >= 0 && y0 + h <= this.height && z0 >= 0 && z0 + d <= this.nSlices;
        if (voxels == null || voxels.length != w * h * d) {
            voxels = new float[w * h * d];
        }
        int i = 0;
        for (int z = z0; z < z0 + d; ++z) {
            block7: for (int y = y0; y < y0 + h; ++y) {
                if (inBounds) {
                    switch (this.bitDepth) {
                        case 8: {
                            byte[] bytes = (byte[])this.stack[z];
                            for (int x = x0; x < x0 + w; ++x) {
                                voxels[i++] = bytes[y * this.width + x] & 0xFF;
                            }
                            continue block7;
                        }
                        case 16: {
                            short[] shorts = (short[])this.stack[z];
                            for (int x = x0; x < x0 + w; ++x) {
                                voxels[i++] = shorts[y * this.width + x] & 0xFFFF;
                            }
                            continue block7;
                        }
                        case 32: {
                            float[] floats = (float[])this.stack[z];
                            for (int x = x0; x < x0 + w; ++x) {
                                voxels[i++] = floats[y * this.width + x];
                            }
                            continue block7;
                        }
                        case 24: {
                            int x;
                            int[] ints = (int[])this.stack[z];
                            for (x = x0; x < x0 + w; ++x) {
                                voxels[i++] = ints[y * this.width + x] & 0xFFFFFFFF;
                            }
                            continue block7;
                        }
                        default: {
                            int x;
                            for (x = x0; x < x0 + w; ++x) {
                                voxels[i++] = 0.0f;
                            }
                            continue block7;
                        }
                    }
                }
                for (int x = x0; x < x0 + w; ++x) {
                    voxels[i++] = (float)this.getVoxel(x, y, z);
                }
            }
        }
        return voxels;
    }

    public float[] getVoxels(int x0, int y0, int z0, int w, int h, int d, float[] voxels, int channel) {
        boolean inBounds;
        if (this.bitDepth != 24) {
            return this.getVoxels(x0, y0, z0, w, h, d, voxels);
        }
        boolean bl = inBounds = x0 >= 0 && x0 + w <= this.width && y0 >= 0 && y0 + h <= this.height && z0 >= 0 && z0 + d <= this.nSlices;
        if (voxels == null || voxels.length != w * h * d) {
            voxels = new float[w * h * d];
        }
        int i = 0;
        for (int z = z0; z < z0 + d; ++z) {
            int[] ints = (int[])this.stack[z];
            for (int y = y0; y < y0 + h; ++y) {
                for (int x = x0; x < x0 + w; ++x) {
                    int value = inBounds ? ints[y * this.width + x] & 0xFFFFFFFF : (int)this.getVoxel(x, y, z);
                    switch (channel) {
                        case 0: {
                            value = (value & 0xFF0000) >> 16;
                            break;
                        }
                        case 1: {
                            value = (value & 0xFF00) >> 8;
                            break;
                        }
                        case 2: {
                            value &= 0xFF;
                        }
                    }
                    voxels[i++] = value;
                }
            }
        }
        return voxels;
    }

    public void setVoxels(int x0, int y0, int z0, int w, int h, int d, float[] voxels) {
        boolean inBounds;
        boolean bl = inBounds = x0 >= 0 && x0 + w <= this.width && y0 >= 0 && y0 + h <= this.height && z0 >= 0 && z0 + d <= this.nSlices;
        if (voxels == null || voxels.length != w * h * d) {
            // empty if block
        }
        int i = 0;
        for (int z = z0; z < z0 + d; ++z) {
            block7: for (int y = y0; y < y0 + h; ++y) {
                if (inBounds) {
                    switch (this.bitDepth) {
                        case 8: {
                            float value;
                            byte[] bytes = (byte[])this.stack[z];
                            for (int x = x0; x < x0 + w; ++x) {
                                int n = i++;
                                value = voxels[n];
                                if (value > 255.0f) {
                                    value = 255.0f;
                                } else if (value < 0.0f) {
                                    value = 0.0f;
                                }
                                bytes[y * this.width + x] = (byte)(value + 0.5f);
                            }
                            continue block7;
                        }
                        case 16: {
                            float value;
                            short[] shorts = (short[])this.stack[z];
                            for (int x = x0; x < x0 + w; ++x) {
                                int n = i++;
                                value = voxels[n];
                                if (value > 65535.0f) {
                                    value = 65535.0f;
                                } else if (value < 0.0f) {
                                    value = 0.0f;
                                }
                                shorts[y * this.width + x] = (short)(value + 0.5f);
                            }
                            continue block7;
                        }
                        case 32: {
                            float value;
                            float[] floats = (float[])this.stack[z];
                            for (int x = x0; x < x0 + w; ++x) {
                                floats[y * this.width + x] = value = voxels[i++];
                            }
                            continue block7;
                        }
                        case 24: {
                            float value;
                            int[] ints = (int[])this.stack[z];
                            for (int x = x0; x < x0 + w; ++x) {
                                value = voxels[i++];
                                ints[y * this.width + x] = (int)value;
                            }
                            break;
                        }
                    }
                    continue;
                }
                for (int x = x0; x < x0 + w; ++x) {
                    this.setVoxel(x, y, z, voxels[i++]);
                }
            }
        }
    }

    public void setVoxels(int x0, int y0, int z0, int w, int h, int d, float[] voxels, int channel) {
        boolean inBounds;
        if (this.bitDepth != 24) {
            this.setVoxels(x0, y0, z0, w, h, d, voxels);
            return;
        }
        boolean bl = inBounds = x0 >= 0 && x0 + w <= this.width && y0 >= 0 && y0 + h <= this.height && z0 >= 0 && z0 + d <= this.nSlices;
        if (voxels == null || voxels.length != w * h * d) {
            // empty if block
        }
        int i = 0;
        for (int z = z0; z < z0 + d; ++z) {
            int[] ints = (int[])this.stack[z];
            for (int y = y0; y < y0 + h; ++y) {
                for (int x = x0; x < x0 + w; ++x) {
                    int value = inBounds ? ints[y * this.width + x] & 0xFFFFFFFF : (int)this.getVoxel(x, y, z);
                    int color = (int)voxels[i++];
                    switch (channel) {
                        case 0: {
                            value = value & 0xFF00FFFF | (color & 0xFF) << 16;
                            break;
                        }
                        case 1: {
                            value = value & 0xFFFF00FF | (color & 0xFF) << 8;
                            break;
                        }
                        case 2: {
                            value = value & 0xFFFFFF00 | color & 0xFF;
                        }
                    }
                    if (inBounds) {
                        ints[y * this.width + x] = value;
                        continue;
                    }
                    this.setVoxel(x, y, z, value);
                }
            }
        }
    }

    public void drawSphere(double radius, int xc, int yc, int zc) {
        int diameter = (int)Math.round(radius * 2.0);
        double r = radius;
        int xmin = (int)((double)xc - r + 0.5);
        int ymin = (int)((double)yc - r + 0.5);
        int zmin = (int)((double)zc - r + 0.5);
        int xmax = xmin + diameter;
        int ymax = ymin + diameter;
        int zmax = zmin + diameter;
        double r2 = r * r;
        double xoffset = (double)xmin + (r -= 0.5);
        double yoffset = (double)ymin + r;
        double zoffset = (double)zmin + r;
        for (int x = xmin; x <= xmax; ++x) {
            for (int y = ymin; y <= ymax; ++y) {
                for (int z = zmin; z <= zmax; ++z) {
                    double xx = (double)x - xoffset;
                    double yy = (double)y - yoffset;
                    double zz = (double)z - zoffset;
                    if (!(xx * xx + yy * yy + zz * zz <= r2)) continue;
                    this.setVoxel(x, y, z, 255.0);
                }
            }
        }
    }

    public int getBitDepth() {
        if (this.bitDepth == 0 && this.stack != null && this.stack.length > 0) {
            this.setBitDepth(this.stack[0]);
        }
        return this.bitDepth;
    }

    public void setBitDepth(int depth) {
        if (this.size() == 0 && (depth == 8 || depth == 16 || depth == 24 || depth == 32)) {
            this.bitDepth = depth;
        }
    }

    public static ImageStack create(int width, int height, int depth, int bitdepth) {
        ImageStack stack = IJ.createImage("", width, height, depth, bitdepth).getStack();
        if (bitdepth == 16 || bitdepth == 32) {
            stack.min = Double.MAX_VALUE;
            stack.max = 0.0;
        }
        return stack;
    }

    public static ImageStack create(ImagePlus[] images) {
        int w = 0;
        int h = 0;
        for (int i = 0; i < images.length; ++i) {
            if (images[i].getWidth() > w) {
                w = images[i].getWidth();
            }
            if (images[i].getHeight() <= h) continue;
            h = images[i].getHeight();
        }
        ImageStack stack = new ImageStack(w, h);
        stack.init(w, h);
        for (int i = 0; i < images.length; ++i) {
            stack.addSlice(images[i].getProcessor());
        }
        int depth = images[0].getBitDepth();
        if (depth == 16 || depth == 32) {
            stack.min = Double.MAX_VALUE;
            stack.max = 0.0;
        }
        return stack;
    }

    public ImageStack duplicate() {
        return this.crop(0, 0, 0, this.width, this.height, this.size());
    }

    public ImageStack crop(int x, int y, int z, int width, int height, int depth) {
        if (x < 0 || y < 0 || z < 0 || x + width > this.width || y + height > this.height || z + depth > this.size()) {
            throw new IllegalArgumentException("Argument out of range");
        }
        ImageStack stack2 = new ImageStack(width, height, this.getColorModel());
        for (int i = z; i < z + depth; ++i) {
            ImageProcessor ip2 = this.getProcessor(i + 1);
            ip2.setRoi(x, y, width, height);
            ip2 = ip2.crop();
            stack2.addSlice(this.getSliceLabel(i + 1), ip2);
        }
        return stack2;
    }

    public ImageStack convertToFloat() {
        ImageStack stack2 = new ImageStack(this.width, this.height, this.getColorModel());
        for (int i = 1; i <= this.size(); ++i) {
            ImageProcessor ip2 = this.getProcessor(i);
            ip2 = ip2.convertToFloat();
            stack2.addSlice(this.getSliceLabel(i), ip2);
        }
        return stack2;
    }

    int viewers(int inc) {
        this.viewers += inc;
        return this.viewers;
    }

    public void setOptions(String options) {
        if (options == null) {
            return;
        }
        this.signedInt = options.contains("32-bit int");
    }
}

