/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.aggdes.algorithm.impl;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.aggdes.algorithm.Algorithm;
import org.pentaho.aggdes.algorithm.Progress;
import org.pentaho.aggdes.algorithm.impl.AggregateImpl;
import org.pentaho.aggdes.algorithm.impl.Cost;
import org.pentaho.aggdes.algorithm.impl.Lattice;
import org.pentaho.aggdes.algorithm.impl.ResultImpl;
import org.pentaho.aggdes.model.Aggregate;
import org.pentaho.aggdes.model.Attribute;
import org.pentaho.aggdes.model.Component;
import org.pentaho.aggdes.model.Parameter;
import org.pentaho.aggdes.model.Schema;
import org.pentaho.aggdes.util.AggDesUtil;
import org.pentaho.aggdes.util.BitSetPlus;

public abstract class AlgorithmImpl
implements Algorithm {
    private static final Log LOGGER = LogFactory.getLog(AlgorithmImpl.class);
    protected final List<Parameter> parameterList = new ArrayList<Parameter>();
    private boolean cancelRequested;
    private boolean canceled;
    protected Schema schema;
    private long timeoutMillis;
    private Progress progress;

    protected AlgorithmImpl() {
        this.parameterList.addAll(Arrays.asList(Algorithm.ParameterEnum.values()));
    }

    @Override
    public void cancel() {
        this.cancelRequested = true;
    }

    @Override
    public String getName() {
        return AlgorithmImpl.getBaseName(this.getClass());
    }

    public static String getBaseName(Class<? extends Component> aClass) {
        String className = aClass.getName();
        int dot = className.lastIndexOf(46);
        if (dot >= 0) {
            className = className.substring(dot + 1);
        }
        return className;
    }

    @Override
    public List<Parameter> getParameters() {
        return this.parameterList;
    }

    protected void onStart(Map<Parameter, Object> parameterValues, Progress progress) {
        this.progress = progress;
        this.canceled = false;
        Integer integer = (Integer)parameterValues.get(Algorithm.ParameterEnum.TIME_LIMIT_SECONDS);
        this.timeoutMillis = integer == null ? Long.MAX_VALUE : System.currentTimeMillis() + 1000L * (long)integer.intValue();
    }

    protected boolean checkCancelTimeout() {
        if (this.canceled) {
            return true;
        }
        if (this.cancelRequested) {
            this.canceled = true;
            this.cancelRequested = false;
            this.progress.report("Algorithm was canceled", 1.0);
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        if (currentTimeMillis > this.timeoutMillis) {
            this.canceled = true;
            this.progress.report("Algorithm exceeded time limit", 1.0);
            return true;
        }
        return false;
    }

    @Override
    public Aggregate createAggregate(Schema schema, List<Attribute> attributeList) {
        this.schema = schema;
        BitSetPlus bitSet = new BitSetPlus(schema.getAttributes().size());
        for (Attribute attribute : attributeList) {
            bitSet.set(schema.getAttributes().indexOf(attribute));
        }
        return new AggregateImpl(schema, bitSet);
    }

    protected ResultImpl runAlgorithm(Lattice lattice, double costLimit, double minCostBenefitRatio, int aggregateLimit) {
        AggregateImpl aggregate;
        double costPerAggregate = aggregateLimit < Integer.MAX_VALUE ? costLimit / (double)(aggregateLimit + 1) : 0.0;
        Cost aggCost = new Cost();
        Cost totalCost = new Cost();
        double minBenefit = 1.0;
        double remainingCost = costLimit;
        while (!this.checkCancelTimeout() && (aggregate = lattice.chooseAggregate(remainingCost, minCostBenefitRatio, aggCost)) != null && !(aggCost.benefit < 1.0)) {
            double cost = aggCost.cost + costPerAggregate;
            totalCost.cost += cost;
            totalCost.benefit += aggCost.benefit;
            totalCost.benefitCount += aggCost.benefitCount;
            if ((remainingCost -= cost) <= 0.0) break;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("materialize " + aggregate.getDescription() + ": rows=" + aggregate.estimateRowCount() + ", aggCost=" + aggCost.cost + ", benefit=" + aggCost.benefit + ", count=" + aggCost.benefitCount));
            }
            lattice.materialize(aggregate);
        }
        List<Aggregate> aggregateList = AggDesUtil.cast(lattice.getMaterializedAggregates());
        List<Algorithm.CostBenefit> costBenefitList = this.computeAggregateCosts(this.schema, null, aggregateList);
        if (LOGGER.isDebugEnabled()) {
            for (AggregateImpl aggregate2 : lattice.getMaterializedAggregates()) {
                LOGGER.debug((Object)("table: " + aggregate2.getDescription() + " (" + aggregate2.estimateRowCount() + " rows)"));
            }
        }
        return new ResultImpl(aggregateList, costBenefitList, costLimit, totalCost.cost, totalCost.benefit);
    }

    static class CostBenefitImpl
    implements Algorithm.CostBenefit {
        private final AggregateImpl aggregate;
        private final double costSavingPerQuery;
        private Schema schema;

        CostBenefitImpl(Schema schema, AggregateImpl aggregate, double costSavingPerQuery) {
            this.aggregate = aggregate;
            this.costSavingPerQuery = costSavingPerQuery;
            this.schema = schema;
        }

        @Override
        public double getRowCount() {
            return this.aggregate.estimateRowCount();
        }

        @Override
        public double getSpace() {
            return this.aggregate.estimateSpace();
        }

        @Override
        public double getLoadTime() {
            return this.schema.getStatisticsProvider().getLoadTime(this.aggregate.getAttributes());
        }

        @Override
        public double getSavedQueryRowCount() {
            return this.costSavingPerQuery;
        }

        @Override
        public void describe(PrintWriter pw) {
            pw.printf("%d rows, %d bytes, %d load cost, %d query rows saved, used by %d%% of queries", (int)this.getRowCount(), (int)this.getSpace(), (int)this.getLoadTime(), (int)this.getSavedQueryRowCount(), (int)(this.aggregate.queryLoad * 100.0));
        }
    }
}

