/*
 * Decompiled with CFR 0.152.
 */
package net.htmlparser.jericho;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.htmlparser.jericho.Attributes;
import net.htmlparser.jericho.CharacterReference;
import net.htmlparser.jericho.Element;
import net.htmlparser.jericho.FormControl;
import net.htmlparser.jericho.FormFields;
import net.htmlparser.jericho.NodeIterator;
import net.htmlparser.jericho.Renderer;
import net.htmlparser.jericho.Source;
import net.htmlparser.jericho.StartTag;
import net.htmlparser.jericho.StartTagType;
import net.htmlparser.jericho.Tag;
import net.htmlparser.jericho.TagType;
import net.htmlparser.jericho.TextExtractor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Segment
implements Comparable<Segment>,
CharSequence {
    final int begin;
    final int end;
    final Source source;
    private static final char[] WHITESPACE = new char[]{' ', '\n', '\r', '\t', '\f', '\u200b'};

    public Segment(Source source, int n, int n2) {
        if (n == -1 || n2 == -1 || n > n2) {
            throw new IllegalArgumentException();
        }
        this.begin = n;
        this.end = n2;
        if (source == null) {
            throw new IllegalArgumentException("source argument must not be null");
        }
        this.source = source;
    }

    Segment(int n) {
        this.begin = 0;
        this.end = n;
        this.source = (Source)this;
    }

    Segment() {
        this.begin = 0;
        this.end = 0;
        this.source = null;
    }

    public final Source getSource() {
        return this.source;
    }

    public final int getBegin() {
        return this.begin;
    }

    public final int getEnd() {
        return this.end;
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof Segment)) {
            return false;
        }
        Segment segment = (Segment)object;
        return segment.begin == this.begin && segment.end == this.end && segment.source == this.source;
    }

    public int hashCode() {
        return this.begin + this.end;
    }

    @Override
    public final int length() {
        return this.end - this.begin;
    }

    public final boolean encloses(Segment segment) {
        return this.begin <= segment.begin && this.end >= segment.end;
    }

    public final boolean encloses(int n) {
        return this.begin <= n && n < this.end;
    }

    @Override
    public String toString() {
        return this.source.string.substring(this.begin, this.end).toString();
    }

    public Renderer getRenderer() {
        return new Renderer(this);
    }

    public TextExtractor getTextExtractor() {
        return new TextExtractor(this);
    }

    public Iterator<Segment> getNodeIterator() {
        return new NodeIterator(this);
    }

    public List<Tag> getAllTags() {
        return this.getAllTags(null);
    }

    public List<Tag> getAllTags(TagType tagType) {
        Tag tag = this.checkEnclosure(Tag.getNextTag(this.source, this.begin, tagType));
        if (tag == null) {
            return Collections.emptyList();
        }
        ArrayList<Tag> arrayList = new ArrayList<Tag>();
        do {
            arrayList.add(tag);
        } while ((tag = this.checkEnclosure(tag.getNextTag(tagType))) != null);
        return arrayList;
    }

    public List<StartTag> getAllStartTags() {
        return this.getAllStartTags((StartTagType)null);
    }

    public List<StartTag> getAllStartTags(StartTagType startTagType) {
        if (startTagType == null) {
            return this.getAllStartTags();
        }
        StartTag startTag = (StartTag)this.checkEnclosure(Tag.getNextTag(this.source, this.begin, startTagType));
        if (startTag == null) {
            return Collections.emptyList();
        }
        ArrayList<StartTag> arrayList = new ArrayList<StartTag>();
        do {
            arrayList.add(startTag);
        } while ((startTag = (StartTag)this.checkEnclosure(startTag.getNextTag(startTagType))) != null);
        return arrayList;
    }

    public List<StartTag> getAllStartTags(String string) {
        boolean bl;
        StartTag startTag;
        if (string != null) {
            string = string.toLowerCase();
        }
        if ((startTag = (StartTag)this.checkEnclosure(StartTag.getNext(this.source, this.begin, string, StartTagType.NORMAL, bl = Tag.isXMLName(string)))) == null) {
            return Collections.emptyList();
        }
        ArrayList<StartTag> arrayList = new ArrayList<StartTag>();
        do {
            arrayList.add(startTag);
        } while ((startTag = (StartTag)this.checkEnclosure(StartTag.getNext(this.source, startTag.begin + 1, string, StartTagType.NORMAL, bl))) != null);
        return arrayList;
    }

    public List<StartTag> getAllStartTags(String string, String string2, boolean bl) {
        StartTag startTag = (StartTag)this.checkEnclosure(this.source.getNextStartTag(this.begin, string, string2, bl));
        if (startTag == null) {
            return Collections.emptyList();
        }
        ArrayList<StartTag> arrayList = new ArrayList<StartTag>();
        do {
            arrayList.add(startTag);
        } while ((startTag = (StartTag)this.checkEnclosure(this.source.getNextStartTag(startTag.begin + 1, string, string2, bl))) != null);
        return arrayList;
    }

    public List<Element> getChildElements() {
        StartTag startTag;
        if (this.length() == 0) {
            return Collections.emptyList();
        }
        ArrayList<Element> arrayList = new ArrayList<Element>();
        int n = this.begin;
        while ((startTag = this.source.getNextStartTag(n)) != null && startTag.begin < this.end) {
            if (startTag.getTagType().isServerTag()) {
                n = startTag.end;
                continue;
            }
            Element element = startTag.getElement();
            arrayList.add(element);
            element.getChildElements();
            n = element.end;
        }
        return arrayList;
    }

    public List<Element> getAllElements() {
        return this.getAllElements((String)null);
    }

    public List<Element> getAllElements(String string) {
        List<StartTag> list;
        if (string != null) {
            string = string.toLowerCase();
        }
        if ((list = this.getAllStartTags(string)).isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Element> arrayList = new ArrayList<Element>(list.size());
        for (StartTag startTag : list) {
            Element element = startTag.getElement();
            if (element.end > this.end) break;
            arrayList.add(element);
        }
        return arrayList;
    }

    public List<Element> getAllElements(StartTagType startTagType) {
        List<StartTag> list = this.getAllStartTags(startTagType);
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Element> arrayList = new ArrayList<Element>(list.size());
        for (StartTag startTag : list) {
            Element element = startTag.getElement();
            if (element.end > this.end) break;
            arrayList.add(element);
        }
        return arrayList;
    }

    public List<Element> getAllElements(String string, String string2, boolean bl) {
        List<StartTag> list = this.getAllStartTags(string, string2, bl);
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Element> arrayList = new ArrayList<Element>(list.size());
        for (StartTag startTag : list) {
            Element element = startTag.getElement();
            if (element.end > this.end) break;
            arrayList.add(element);
        }
        return arrayList;
    }

    public List<CharacterReference> getAllCharacterReferences() {
        CharacterReference characterReference = this.getNextCharacterReference(this.begin);
        if (characterReference == null) {
            return Collections.emptyList();
        }
        ArrayList<CharacterReference> arrayList = new ArrayList<CharacterReference>();
        do {
            arrayList.add(characterReference);
        } while ((characterReference = this.getNextCharacterReference(characterReference.end)) != null);
        return arrayList;
    }

    public StartTag getFirstStartTag() {
        return this.source.getNextStartTag(this.begin);
    }

    public StartTag getFirstStartTag(StartTagType startTagType) {
        return this.source.getNextStartTag(this.begin, startTagType);
    }

    public StartTag getFirstStartTag(String string) {
        return this.source.getNextStartTag(this.begin, string);
    }

    public StartTag getFirstStartTag(String string, String string2, boolean bl) {
        return this.source.getNextStartTag(this.begin, string, string2, bl);
    }

    public Element getFirstElement() {
        return this.source.getNextElement(this.begin);
    }

    public Element getFirstElement(String string) {
        return this.source.getNextElement(this.begin, string);
    }

    public Element getFirstElement(String string, String string2, boolean bl) {
        return this.source.getNextElement(this.begin, string, string2, bl);
    }

    public List<FormControl> getFormControls() {
        return FormControl.getAll(this);
    }

    public FormFields getFormFields() {
        return new FormFields(this.getFormControls());
    }

    public Attributes parseAttributes() {
        return this.source.parseAttributes(this.begin, this.end);
    }

    public void ignoreWhenParsing() {
        this.source.ignoreWhenParsing(this.begin, this.end);
    }

    @Override
    public int compareTo(Segment segment) {
        if (this == segment) {
            return 0;
        }
        if (this.begin < segment.begin) {
            return -1;
        }
        if (this.begin > segment.begin) {
            return 1;
        }
        if (this.end < segment.end) {
            return -1;
        }
        if (this.end > segment.end) {
            return 1;
        }
        return 0;
    }

    public final boolean isWhiteSpace() {
        for (int i = this.begin; i < this.end; ++i) {
            if (Segment.isWhiteSpace(this.source.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static final boolean isWhiteSpace(char c) {
        for (char c2 : WHITESPACE) {
            if (c != c2) continue;
            return true;
        }
        return false;
    }

    public String getDebugInfo() {
        StringBuilder stringBuilder = new StringBuilder(50);
        stringBuilder.append('(');
        this.source.getRowColumnVector(this.begin).appendTo(stringBuilder);
        stringBuilder.append('-');
        this.source.getRowColumnVector(this.end).appendTo(stringBuilder);
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    @Override
    public final char charAt(int n) {
        return this.source.string.charAt(this.begin + n);
    }

    @Override
    public final CharSequence subSequence(int n, int n2) {
        return this.source.string.subSequence(this.begin + n, this.begin + n2);
    }

    @Deprecated
    public List<Tag> findAllTags() {
        return this.getAllTags();
    }

    @Deprecated
    public List<Tag> findAllTags(TagType tagType) {
        return this.getAllTags(tagType);
    }

    @Deprecated
    public List<StartTag> findAllStartTags() {
        return this.getAllStartTags();
    }

    @Deprecated
    public List<StartTag> findAllStartTags(String string) {
        return this.getAllStartTags(string);
    }

    @Deprecated
    public List<StartTag> findAllStartTags(String string, String string2, boolean bl) {
        return this.getAllStartTags(string, string2, bl);
    }

    @Deprecated
    public List<Element> findAllElements(String string) {
        return this.getAllElements(string);
    }

    @Deprecated
    public List<Element> findAllElements(StartTagType startTagType) {
        return this.getAllElements(startTagType);
    }

    @Deprecated
    public List<Element> findAllElements(String string, String string2, boolean bl) {
        return this.getAllElements(string, string2, bl);
    }

    @Deprecated
    public List<CharacterReference> findAllCharacterReferences() {
        return this.getAllCharacterReferences();
    }

    @Deprecated
    public List<FormControl> findFormControls() {
        return this.getFormControls();
    }

    @Deprecated
    public FormFields findFormFields() {
        return this.getFormFields();
    }

    static final StringBuilder appendCollapseWhiteSpace(StringBuilder stringBuilder, CharSequence charSequence) {
        int n = charSequence.length();
        int n2 = 0;
        boolean bl = false;
        while (true) {
            if (n2 >= n) {
                return stringBuilder;
            }
            if (!Segment.isWhiteSpace(charSequence.charAt(n2))) break;
            ++n2;
        }
        do {
            char c;
            if (Segment.isWhiteSpace(c = charSequence.charAt(n2++))) {
                bl = true;
                continue;
            }
            if (bl) {
                stringBuilder.append(' ');
                bl = false;
            }
            stringBuilder.append(c);
        } while (n2 < n);
        return stringBuilder;
    }

    private Tag checkEnclosure(Tag tag) {
        if (tag == null || tag.end > this.end) {
            return null;
        }
        return tag;
    }

    private CharacterReference getNextCharacterReference(int n) {
        CharacterReference characterReference = this.source.getNextCharacterReference(n);
        if (characterReference == null || characterReference.end > this.end) {
            return null;
        }
        return characterReference;
    }
}

