/*
 * Decompiled with CFR 0.152.
 */
package net.htmlparser.jericho;

import java.util.Iterator;
import java.util.NoSuchElementException;
import net.htmlparser.jericho.Segment;
import net.htmlparser.jericho.Tag;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class NodeIterator
implements Iterator<Segment> {
    private final Segment segment;
    private int pos;
    private Tag nextTag;

    public NodeIterator(Segment segment) {
        this.segment = segment;
        if (segment == segment.source) {
            segment.source.fullSequentialParse();
        }
        this.pos = segment.getBegin();
        this.nextTag = segment.source.getNextTag(this.pos);
        if (this.nextTag != null && this.nextTag.getBegin() >= segment.getEnd()) {
            this.nextTag = null;
        }
    }

    @Override
    public boolean hasNext() {
        return this.pos < this.segment.getEnd() || this.nextTag != null;
    }

    @Override
    public Segment next() {
        int n = this.pos;
        if (this.nextTag != null) {
            if (n < this.nextTag.getBegin()) {
                this.pos = this.nextTag.getBegin();
                return new Segment(this.segment.getSource(), n, this.pos);
            }
            Tag tag = this.nextTag;
            this.nextTag = this.nextTag.getNextTag();
            if (this.nextTag != null && this.nextTag.getBegin() >= this.segment.getEnd()) {
                this.nextTag = null;
            }
            if (this.pos < tag.getEnd()) {
                this.pos = tag.getEnd();
            }
            return tag;
        }
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.pos = this.segment.getEnd();
        return new Segment(this.segment.getSource(), n, this.pos);
    }

    public void skipToPos(int n) {
        if (n < this.pos) {
            return;
        }
        this.pos = n;
        this.nextTag = this.segment.source.getNextTag(n);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

