/*
 * Decompiled with CFR 0.152.
 */
package net.htmlparser.jericho;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.htmlparser.jericho.Attributes;
import net.htmlparser.jericho.EndTag;
import net.htmlparser.jericho.FormControl;
import net.htmlparser.jericho.Segment;
import net.htmlparser.jericho.Source;
import net.htmlparser.jericho.StartTag;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Element
extends Segment {
    private final StartTag startTag;
    private final EndTag endTag;
    private Segment content = null;
    Element parentElement = NOT_CACHED;
    private int depth = -1;
    private List<Element> childElements = null;
    static final Element NOT_CACHED = new Element();
    private static final boolean INCLUDE_INCORRECTLY_NESTED_CHILDREN_IN_HIERARCHY = true;
    @Deprecated
    public static final String A = "a";
    @Deprecated
    public static final String ABBR = "abbr";
    @Deprecated
    public static final String ACRONYM = "acronym";
    @Deprecated
    public static final String ADDRESS = "address";
    @Deprecated
    public static final String APPLET = "applet";
    @Deprecated
    public static final String AREA = "area";
    @Deprecated
    public static final String B = "b";
    @Deprecated
    public static final String BASE = "base";
    @Deprecated
    public static final String BASEFONT = "basefont";
    @Deprecated
    public static final String BDO = "bdo";
    @Deprecated
    public static final String BIG = "big";
    @Deprecated
    public static final String BLOCKQUOTE = "blockquote";
    @Deprecated
    public static final String BODY = "body";
    @Deprecated
    public static final String BR = "br";
    @Deprecated
    public static final String BUTTON = "button";
    @Deprecated
    public static final String CAPTION = "caption";
    @Deprecated
    public static final String CENTER = "center";
    @Deprecated
    public static final String CITE = "cite";
    @Deprecated
    public static final String CODE = "code";
    @Deprecated
    public static final String COL = "col";
    @Deprecated
    public static final String COLGROUP = "colgroup";
    @Deprecated
    public static final String DD = "dd";
    @Deprecated
    public static final String DEL = "del";
    @Deprecated
    public static final String DFN = "dfn";
    @Deprecated
    public static final String DIR = "dir";
    @Deprecated
    public static final String DIV = "div";
    @Deprecated
    public static final String DL = "dl";
    @Deprecated
    public static final String DT = "dt";
    @Deprecated
    public static final String EM = "em";
    @Deprecated
    public static final String FIELDSET = "fieldset";
    @Deprecated
    public static final String FONT = "font";
    @Deprecated
    public static final String FORM = "form";
    @Deprecated
    public static final String FRAME = "frame";
    @Deprecated
    public static final String FRAMESET = "frameset";
    @Deprecated
    public static final String H1 = "h1";
    @Deprecated
    public static final String H2 = "h2";
    @Deprecated
    public static final String H3 = "h3";
    @Deprecated
    public static final String H4 = "h4";
    @Deprecated
    public static final String H5 = "h5";
    @Deprecated
    public static final String H6 = "h6";
    @Deprecated
    public static final String HEAD = "head";
    @Deprecated
    public static final String HR = "hr";
    @Deprecated
    public static final String HTML = "html";
    @Deprecated
    public static final String I = "i";
    @Deprecated
    public static final String IFRAME = "iframe";
    @Deprecated
    public static final String IMG = "img";
    @Deprecated
    public static final String INPUT = "input";
    @Deprecated
    public static final String INS = "ins";
    @Deprecated
    public static final String ISINDEX = "isindex";
    @Deprecated
    public static final String KBD = "kbd";
    @Deprecated
    public static final String LABEL = "label";
    @Deprecated
    public static final String LEGEND = "legend";
    @Deprecated
    public static final String LI = "li";
    @Deprecated
    public static final String LINK = "link";
    @Deprecated
    public static final String MAP = "map";
    @Deprecated
    public static final String MENU = "menu";
    @Deprecated
    public static final String META = "meta";
    @Deprecated
    public static final String NOFRAMES = "noframes";
    @Deprecated
    public static final String NOSCRIPT = "noscript";
    @Deprecated
    public static final String OBJECT = "object";
    @Deprecated
    public static final String OL = "ol";
    @Deprecated
    public static final String OPTGROUP = "optgroup";
    @Deprecated
    public static final String OPTION = "option";
    @Deprecated
    public static final String P = "p";
    @Deprecated
    public static final String PARAM = "param";
    @Deprecated
    public static final String PRE = "pre";
    @Deprecated
    public static final String Q = "q";
    @Deprecated
    public static final String S = "s";
    @Deprecated
    public static final String SAMP = "samp";
    @Deprecated
    public static final String SCRIPT = "script";
    @Deprecated
    public static final String SELECT = "select";
    @Deprecated
    public static final String SMALL = "small";
    @Deprecated
    public static final String SPAN = "span";
    @Deprecated
    public static final String STRIKE = "strike";
    @Deprecated
    public static final String STRONG = "strong";
    @Deprecated
    public static final String STYLE = "style";
    @Deprecated
    public static final String SUB = "sub";
    @Deprecated
    public static final String SUP = "sup";
    @Deprecated
    public static final String TABLE = "table";
    @Deprecated
    public static final String TBODY = "tbody";
    @Deprecated
    public static final String TD = "td";
    @Deprecated
    public static final String TEXTAREA = "textarea";
    @Deprecated
    public static final String TFOOT = "tfoot";
    @Deprecated
    public static final String TH = "th";
    @Deprecated
    public static final String THEAD = "thead";
    @Deprecated
    public static final String TITLE = "title";
    @Deprecated
    public static final String TR = "tr";
    @Deprecated
    public static final String TT = "tt";
    @Deprecated
    public static final String U = "u";
    @Deprecated
    public static final String UL = "ul";
    @Deprecated
    public static final String VAR = "var";

    Element(Source source, StartTag startTag, EndTag endTag) {
        super(source, startTag.begin, endTag == null ? startTag.end : endTag.end);
        this.startTag = startTag;
        this.endTag = endTag == null || endTag.length() == 0 ? null : endTag;
    }

    private Element() {
        this.startTag = null;
        this.endTag = null;
    }

    public Element getParentElement() {
        if (this.parentElement == NOT_CACHED) {
            if (!this.source.wasFullSequentialParseCalled()) {
                throw new IllegalStateException("This operation is only possible after a full sequential parse has been performed");
            }
            if (this.startTag.isOrphaned()) {
                throw new IllegalStateException("This operation is only possible if a full sequential parse was performed immediately after construction of the Source object");
            }
            this.source.getChildElements();
            if (this.parentElement == NOT_CACHED) {
                this.parentElement = null;
            }
        }
        return this.parentElement;
    }

    @Override
    public final List<Element> getChildElements() {
        return this.childElements != null ? this.childElements : this.getChildElements(-1);
    }

    final List<Element> getChildElements(int n) {
        if (n != -1) {
            this.depth = n;
        }
        if (this.childElements == null) {
            if (this.end == this.startTag.end) {
                this.childElements = Collections.emptyList();
            } else {
                StartTag startTag;
                int n2;
                int n3 = n == -1 ? -1 : n + 1;
                this.childElements = new ArrayList<Element>();
                int n4 = this.startTag.end;
                int n5 = n2 = this.endTag == null ? this.end : this.endTag.begin;
                while ((startTag = this.source.getNextStartTag(n4)) != null && startTag.begin < n2) {
                    if (startTag.getTagType().isServerTag()) {
                        n4 = startTag.end;
                        continue;
                    }
                    Element element = startTag.getElement();
                    if (element.end > this.end && this.source.logger.isInfoEnabled()) {
                        this.source.logger.info("Child " + element.getDebugInfo() + " extends beyond end of parent " + this.getDebugInfo());
                    }
                    element.getChildElements(n3);
                    if (element.parentElement == NOT_CACHED) {
                        element.parentElement = this;
                        this.childElements.add(element);
                    }
                    n4 = element.end;
                }
            }
        }
        return this.childElements;
    }

    public int getDepth() {
        if (this.depth == -1) {
            this.getParentElement();
            if (this.depth == -1) {
                this.depth = 0;
            }
        }
        return this.depth;
    }

    public Segment getContent() {
        if (this.content == null) {
            this.content = new Segment(this.source, this.startTag.end, this.getContentEnd());
        }
        return this.content;
    }

    public StartTag getStartTag() {
        return this.startTag;
    }

    public EndTag getEndTag() {
        return this.endTag;
    }

    public String getName() {
        return this.startTag.getName();
    }

    @Override
    public boolean isEmpty() {
        return this.startTag.end == this.getContentEnd();
    }

    public boolean isEmptyElementTag() {
        return this.startTag.isEmptyElementTag();
    }

    public Attributes getAttributes() {
        return this.getStartTag().getAttributes();
    }

    public String getAttributeValue(String string) {
        return this.getStartTag().getAttributeValue(string);
    }

    public FormControl getFormControl() {
        return FormControl.construct(this);
    }

    @Override
    public String getDebugInfo() {
        if (this == NOT_CACHED) {
            return "NOT_CACHED";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Element ");
        this.startTag.appendDebugTag(stringBuilder);
        if (!this.isEmpty()) {
            stringBuilder.append('-');
        }
        if (this.endTag != null) {
            stringBuilder.append(this.endTag);
        }
        stringBuilder.append(' ');
        this.startTag.appendDebugTagType(stringBuilder);
        stringBuilder.append(super.getDebugInfo());
        return stringBuilder.toString();
    }

    int getContentEnd() {
        return this.endTag != null ? this.endTag.begin : this.end;
    }
}

