/*
 * Decompiled with CFR 0.152.
 */
package au.id.jericho.lib.html;

import au.id.jericho.lib.html.Config;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;

public final class Util {
    private static final int BUFFER_SIZE = 2048;
    private static final String CSVNewLine = System.getProperty("line.separator");

    private Util() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getString(Reader reader) throws IOException {
        if (reader == null) {
            return "";
        }
        try {
            int charsRead;
            char[] copyBuffer = new char[2048];
            StringBuffer sb = new StringBuffer();
            while ((charsRead = reader.read(copyBuffer, 0, 2048)) != -1) {
                sb.append(copyBuffer, 0, charsRead);
            }
            String string = sb.toString();
            return string;
        }
        finally {
            reader.close();
        }
    }

    public static void outputCSVLine(Writer writer, String[] values) throws IOException {
        int i = 0;
        while (i < values.length) {
            String value = values[i];
            if (value != null) {
                if (value == Config.ColumnValueTrue || value == Config.ColumnValueFalse) {
                    writer.write(value);
                } else {
                    writer.write(34);
                    Util.outputValueEscapeQuotes(writer, value);
                    writer.write(34);
                }
            }
            if (++i == values.length) continue;
            writer.write(44);
        }
        writer.write(CSVNewLine);
    }

    private static void outputValueEscapeQuotes(Writer writer, String text) throws IOException {
        for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            writer.write(ch);
            if (ch != '\"') continue;
            writer.write(ch);
        }
    }

    static char[] getConcatenatedCharArray(String string1, String string2) {
        char[] charArray = new char[string1.length() + string2.length()];
        string1.getChars(0, string1.length(), charArray, 0);
        string2.getChars(0, string2.length(), charArray, string1.length());
        return charArray;
    }

    static StringBuffer appendTo(StringBuffer sb, CharSequence s) {
        if (s instanceof String) {
            return sb.append((String)s);
        }
        if (s instanceof StringBuffer) {
            return sb.append((StringBuffer)s);
        }
        int length = s.length();
        for (int i = 0; i < length; ++i) {
            sb.append(s.charAt(i));
        }
        return sb;
    }

    static StringBuffer appendTo(StringBuffer sb, CharSequence s, int start, int end) {
        while (start < end) {
            sb.append(s.charAt(start));
            ++start;
        }
        return sb;
    }

    static Writer appendTo(Writer writer, CharSequence s) throws IOException {
        writer.write(((Object)s).toString());
        return writer;
    }

    static Writer appendTo(Writer writer, CharSequence s, int start, int end) throws IOException {
        if (s instanceof String) {
            writer.write((String)s, start, end - start);
            return writer;
        }
        writer.write(((Object)s.subSequence(start, end)).toString());
        return writer;
    }
}

