/*
 * Decompiled with CFR 0.152.
 */
package au.id.jericho.lib.html;

import au.id.jericho.lib.html.CharStreamSource;
import au.id.jericho.lib.html.CharStreamSourceUtil;
import au.id.jericho.lib.html.Segment;
import au.id.jericho.lib.html.SourceFormatter;
import java.io.IOException;
import java.io.Writer;

public final class SourceCompactor
implements CharStreamSource {
    private final Segment segment;
    private String newLine = null;

    public SourceCompactor(Segment segment) {
        this.segment = segment;
    }

    public void writeTo(Writer writer) throws IOException {
        new SourceFormatter(this.segment).setTidyTags(true).setNewLine(this.newLine).setRemoveLineBreaks(true).writeTo(writer);
    }

    public long getEstimatedMaximumOutputLength() {
        return this.segment.length();
    }

    public String toString() {
        return CharStreamSourceUtil.toString(this);
    }

    public SourceCompactor setNewLine(String newLine) {
        this.newLine = newLine;
        return this;
    }

    public String getNewLine() {
        if (this.newLine == null) {
            this.newLine = this.segment.source.getBestGuessNewLine();
        }
        return this.newLine;
    }
}

