/*
 * Decompiled with CFR 0.152.
 */
package au.id.jericho.lib.html;

import au.id.jericho.lib.html.CharacterReference;
import au.id.jericho.lib.html.Config;
import au.id.jericho.lib.html.ParseText;
import au.id.jericho.lib.html.Source;

public class NumericCharacterReference
extends CharacterReference {
    private boolean hex;

    private NumericCharacterReference(Source source, int n, int n2, int n3, boolean bl) {
        super(source, n, n2, n3);
        this.hex = bl;
    }

    public boolean isDecimal() {
        return !this.hex;
    }

    public boolean isHexadecimal() {
        return this.hex;
    }

    public static String encode(CharSequence charSequence) {
        if (charSequence == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(charSequence.length() * 2);
        for (int i = 0; i < charSequence.length(); ++i) {
            char c = charSequence.charAt(i);
            if (CharacterReference.requiresEncoding(c)) {
                CharacterReference.appendDecimalCharacterReferenceString(stringBuffer, c);
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public static String encodeDecimal(CharSequence charSequence) {
        return NumericCharacterReference.encode(charSequence);
    }

    public static String encodeHexadecimal(CharSequence charSequence) {
        if (charSequence == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(charSequence.length() * 2);
        for (int i = 0; i < charSequence.length(); ++i) {
            char c = charSequence.charAt(i);
            if (CharacterReference.requiresEncoding(c)) {
                CharacterReference.appendHexadecimalCharacterReferenceString(stringBuffer, c);
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public String getCharacterReferenceString() {
        return this.hex ? CharacterReference.getHexadecimalCharacterReferenceString(this.codePoint) : CharacterReference.getDecimalCharacterReferenceString(this.codePoint);
    }

    public static String getCharacterReferenceString(int n) {
        return CharacterReference.getDecimalCharacterReferenceString(n);
    }

    static CharacterReference construct(Source source, int n, Config.UnterminatedCharacterReferenceSettings unterminatedCharacterReferenceSettings) {
        int n2;
        int n3;
        boolean bl;
        block13: {
            String string;
            int n4;
            ParseText parseText = source.getParseText();
            bl = parseText.charAt(n4 = n + 2) == 'x';
            if (bl) {
                ++n4;
            }
            int n5 = bl ? unterminatedCharacterReferenceSettings.hexadecimalCharacterReferenceMaxCodePoint : unterminatedCharacterReferenceSettings.decimalCharacterReferenceMaxCodePoint;
            int n6 = parseText.length() - 1;
            int n7 = n4;
            boolean bl2 = false;
            while (true) {
                if ((n3 = parseText.charAt(n7)) == 59) {
                    n2 = n7 + 1;
                    string = parseText.substring(n4, n7);
                    break;
                }
                if (!(n3 >= 48 && n3 <= 57 || bl && n3 >= 97 && n3 <= 102)) {
                    bl2 = true;
                } else if (n7 == n6) {
                    bl2 = true;
                    ++n7;
                }
                if (bl2) {
                    if (n5 == -1) {
                        return null;
                    }
                    n2 = n7;
                    string = parseText.substring(n4, n7);
                    break;
                }
                ++n7;
            }
            if (string.length() == 0) {
                return null;
            }
            n3 = -1;
            try {
                n3 = Integer.parseInt(string, bl ? 16 : 10);
                if (bl2 && n3 > n5) {
                    return null;
                }
                if (n3 > 0x10FFFF) {
                    n3 = -1;
                }
            }
            catch (NumberFormatException numberFormatException) {
                if (!bl2) break block13;
                return null;
            }
        }
        return new NumericCharacterReference(source, n, n2, n3, bl);
    }

    public String getDebugInfo() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('\"');
        if (this.hex) {
            CharacterReference.appendHexadecimalCharacterReferenceString(stringBuffer, this.codePoint);
        } else {
            CharacterReference.appendDecimalCharacterReferenceString(stringBuffer, this.codePoint);
        }
        stringBuffer.append("\" ");
        CharacterReference.appendUnicodeText(stringBuffer, this.codePoint);
        stringBuffer.append(' ').append(super.getDebugInfo());
        return stringBuffer.toString();
    }
}

