/*
 * Decompiled with CFR 0.152.
 */
package au.id.jericho.lib.html;

import au.id.jericho.lib.html.Element;
import au.id.jericho.lib.html.EndTagType;
import au.id.jericho.lib.html.EndTagTypeGenericImplementation;
import au.id.jericho.lib.html.ParseText;
import au.id.jericho.lib.html.Source;
import au.id.jericho.lib.html.StartTag;
import au.id.jericho.lib.html.Tag;
import au.id.jericho.lib.html.TagType;

public final class EndTag
extends Tag {
    private final EndTagType endTagType;

    EndTag(Source source, int begin, int end, EndTagType endTagType, String name) {
        super(source, begin, end, name);
        this.endTagType = endTagType;
    }

    public Element getElement() {
        StartTag startTag;
        if (this.element != Element.NOT_CACHED) {
            return this.element;
        }
        int pos = this.begin;
        while (pos != 0 && (startTag = this.source.findPreviousStartTag(pos - 1)) != null) {
            Element foundElement = startTag.getElement();
            if (foundElement.getEndTag() == this) {
                return foundElement;
            }
            pos = startTag.begin;
        }
        this.element = null;
        return null;
    }

    public EndTagType getEndTagType() {
        return this.endTagType;
    }

    public TagType getTagType() {
        return this.endTagType;
    }

    public boolean isUnregistered() {
        return this.endTagType == EndTagType.UNREGISTERED;
    }

    public String tidy() {
        return this.toString();
    }

    public static String generateHTML(String tagName) {
        return EndTagType.NORMAL.generateHTML(tagName);
    }

    public String getDebugInfo() {
        StringBuffer sb = new StringBuffer();
        sb.append((Object)this).append(' ');
        if (this.endTagType != EndTagType.NORMAL) {
            sb.append('(').append(this.endTagType.getDescription()).append(") ");
        }
        sb.append(super.getDebugInfo());
        return sb.toString();
    }

    static EndTag findPreviousOrNext(Source source, int pos, String name, EndTagType endTagType, boolean previous) {
        if (name == null) {
            return (EndTag)Tag.findPreviousOrNextTag(source, pos, endTagType, previous);
        }
        if (name.length() == 0) {
            throw new IllegalArgumentException("name argument must not be zero length");
        }
        String searchString = endTagType instanceof EndTagTypeGenericImplementation ? (((EndTagTypeGenericImplementation)endTagType).isStatic() ? endTagType.generateHTML(name) : "</" + name) : endTagType.getStartDelimiter();
        try {
            ParseText parseText = source.getParseText();
            int begin = pos;
            while (true) {
                int n = begin = previous ? parseText.lastIndexOf(searchString, begin) : parseText.indexOf(searchString, begin);
                if (begin == -1) {
                    return null;
                }
                EndTag endTag = (EndTag)source.getTagAt(begin);
                if (endTag != null && endTag.getEndTagType() == endTagType && name.equals(endTag.getName())) {
                    return endTag;
                }
                if (previous) {
                    if (--begin >= 0) {
                        continue;
                    }
                    break;
                }
                if (++begin >= source.end) break;
            }
        }
        catch (IndexOutOfBoundsException ex) {
            // empty catch block
        }
        return null;
    }

    static EndTag findPreviousOrNext(Source source, int pos, boolean previous) {
        Tag tag;
        while ((tag = Tag.findPreviousOrNextTag(source, pos, previous)) != null) {
            if (tag instanceof EndTag) {
                return (EndTag)tag;
            }
            pos += previous ? -1 : 1;
        }
        return null;
    }
}

