/*
 * Decompiled with CFR 0.152.
 */
package au.id.jericho.lib.html;

import au.id.jericho.lib.html.CharacterEntityReference;
import au.id.jericho.lib.html.Config;
import au.id.jericho.lib.html.NumericCharacterReference;
import au.id.jericho.lib.html.ParseText;
import au.id.jericho.lib.html.Segment;
import au.id.jericho.lib.html.Source;
import au.id.jericho.lib.html.Util;
import java.io.FilterWriter;
import java.io.IOException;
import java.io.Writer;

public abstract class CharacterReference
extends Segment {
    int codePoint;
    public static final int INVALID_CODE_POINT = -1;
    static final int MAX_CODE_POINT = 0x10FFFF;
    static int MAX_ENTITY_REFERENCE_LENGTH;
    private static final int TAB_LENGTH = 4;

    CharacterReference(Source source, int begin, int end, int codePoint) {
        super(source, begin, end);
        this.codePoint = codePoint;
    }

    public int getCodePoint() {
        return this.codePoint;
    }

    public char getChar() {
        return (char)this.codePoint;
    }

    public boolean isTerminated() {
        return this.source.charAt(this.end - 1) == ';';
    }

    public static String encode(CharSequence unencodedText) {
        if (unencodedText == null) {
            return null;
        }
        return CharacterReference.appendEncode(new StringBuffer(unencodedText.length() * 2), unencodedText, false).toString();
    }

    public static String encode(char ch) {
        return CharacterReference.appendEncode(new StringBuffer(MAX_ENTITY_REFERENCE_LENGTH), ch).toString();
    }

    public static String encodeWithWhiteSpaceFormatting(CharSequence unencodedText) {
        if (unencodedText == null) {
            return null;
        }
        return CharacterReference.appendEncode(new StringBuffer(unencodedText.length() * 2), unencodedText, true).toString();
    }

    public static String decode(CharSequence encodedText) {
        return CharacterReference.decode(encodedText, false, false);
    }

    public static String decode(CharSequence encodedText, boolean insideAttributeValue) {
        return CharacterReference.decode(encodedText, insideAttributeValue, false);
    }

    private static String decode(CharSequence encodedText, boolean insideAttributeValue, boolean convertNonBreakingSpaces) {
        if (encodedText == null) {
            return null;
        }
        for (int i = 0; i < encodedText.length(); ++i) {
            if (encodedText.charAt(i) != '&') continue;
            return CharacterReference.appendDecode(new StringBuffer(encodedText.length()), encodedText, i, insideAttributeValue, convertNonBreakingSpaces).toString();
        }
        return ((Object)encodedText).toString();
    }

    public static String decodeCollapseWhiteSpace(CharSequence text) {
        return CharacterReference.decodeCollapseWhiteSpace(text, false);
    }

    static String decodeCollapseWhiteSpace(CharSequence text, boolean convertNonBreakingSpaces) {
        return CharacterReference.decode(Segment.appendCollapseWhiteSpace(new StringBuffer(text.length()), text), false, convertNonBreakingSpaces);
    }

    public static String reencode(CharSequence encodedText) {
        return CharacterReference.encode(CharacterReference.decode(encodedText, true));
    }

    public abstract String getCharacterReferenceString();

    public static String getCharacterReferenceString(int codePoint) {
        String characterReferenceString = null;
        if (codePoint != 39) {
            characterReferenceString = CharacterEntityReference.getCharacterReferenceString(codePoint);
        }
        if (characterReferenceString == null) {
            characterReferenceString = NumericCharacterReference.getCharacterReferenceString(codePoint);
        }
        return characterReferenceString;
    }

    public String getDecimalCharacterReferenceString() {
        return CharacterReference.getDecimalCharacterReferenceString(this.codePoint);
    }

    public static String getDecimalCharacterReferenceString(int codePoint) {
        return CharacterReference.appendDecimalCharacterReferenceString(new StringBuffer(), codePoint).toString();
    }

    public String getHexadecimalCharacterReferenceString() {
        return CharacterReference.getHexadecimalCharacterReferenceString(this.codePoint);
    }

    public static String getHexadecimalCharacterReferenceString(int codePoint) {
        return CharacterReference.appendHexadecimalCharacterReferenceString(new StringBuffer(), codePoint).toString();
    }

    public String getUnicodeText() {
        return CharacterReference.getUnicodeText(this.codePoint);
    }

    public static String getUnicodeText(int codePoint) {
        return CharacterReference.appendUnicodeText(new StringBuffer(), codePoint).toString();
    }

    static final StringBuffer appendUnicodeText(StringBuffer sb, int codePoint) {
        sb.append("U+");
        String hex = Integer.toString(codePoint, 16).toUpperCase();
        for (int i = 4 - hex.length(); i > 0; --i) {
            sb.append('0');
        }
        sb.append(hex);
        return sb;
    }

    public static CharacterReference parse(CharSequence characterReferenceText) {
        return CharacterReference.construct(new Source(((Object)characterReferenceText).toString()), 0, Config.UnterminatedCharacterReferenceSettings.ACCEPT_ALL);
    }

    public static int getCodePointFromCharacterReferenceString(CharSequence characterReferenceText) {
        CharacterReference characterReference = CharacterReference.parse(characterReferenceText);
        return characterReference != null ? characterReference.getCodePoint() : -1;
    }

    public static final boolean requiresEncoding(char ch) {
        return ch > '\u007f' || CharacterEntityReference.getName(ch) != null && (ch != '\'' || Config.IsApostropheEncoded);
    }

    public static Writer getEncodingFilterWriter(Writer writer) {
        return new EncodingFilterWriter(writer);
    }

    private static StringBuffer appendEncode(StringBuffer sb, char ch) {
        if (CharacterReference.appendEncodeCheckForWhiteSpaceFormatting(sb, ch, false)) {
            return sb;
        }
        return sb.append(ch);
    }

    static StringBuffer appendEncode(StringBuffer sb, CharSequence unencodedText, boolean whiteSpaceFormatting) {
        if (unencodedText == null) {
            return sb;
        }
        int beginPos = 0;
        int endPos = unencodedText.length();
        if (unencodedText instanceof Segment) {
            int segmentOffset;
            Segment segment = (Segment)unencodedText;
            beginPos = segmentOffset = segment.getBegin();
            endPos += segmentOffset;
            unencodedText = segment.source.string;
        }
        boolean isApostropheEncoded = Config.IsApostropheEncoded;
        for (int i = beginPos; i < endPos; ++i) {
            int spaceCount;
            char ch = unencodedText.charAt(i);
            if (CharacterReference.appendEncodeCheckForWhiteSpaceFormatting(sb, ch, whiteSpaceFormatting)) continue;
            int nexti = i + 1;
            if (ch != ' ') {
                if (ch != '\t') {
                    if (ch == '\r' && nexti < endPos && unencodedText.charAt(nexti) == '\n') {
                        ++i;
                    }
                    sb.append("<br />");
                    continue;
                }
                spaceCount = 4;
            } else {
                spaceCount = 1;
            }
            while (nexti < endPos) {
                ch = unencodedText.charAt(nexti);
                if (ch == ' ') {
                    ++spaceCount;
                } else {
                    if (ch != '\t') break;
                    spaceCount += 4;
                }
                ++nexti;
            }
            if (spaceCount == 1) {
                sb.append(' ');
                continue;
            }
            if (spaceCount % 2 == 1) {
                sb.append(' ');
            }
            while (spaceCount >= 2) {
                sb.append("&nbsp; ");
                spaceCount -= 2;
            }
            i = nexti - 1;
        }
        return sb;
    }

    private static final boolean appendEncodeCheckForWhiteSpaceFormatting(StringBuffer sb, char ch, boolean whiteSpaceFormatting) {
        String characterEntityReferenceName = CharacterEntityReference.getName(ch);
        if (characterEntityReferenceName != null) {
            if (ch == '\'') {
                if (Config.IsApostropheEncoded) {
                    sb.append("&#39;");
                } else {
                    sb.append(ch);
                }
            } else {
                CharacterEntityReference.appendCharacterReferenceString(sb, characterEntityReferenceName);
            }
        } else if (ch > '\u007f') {
            CharacterReference.appendDecimalCharacterReferenceString(sb, ch);
        } else if (!whiteSpaceFormatting || !Segment.isWhiteSpace(ch)) {
            sb.append(ch);
        } else {
            return false;
        }
        return true;
    }

    static CharacterReference findPreviousOrNext(Source source, int pos, boolean previous) {
        return CharacterReference.findPreviousOrNext(source, pos, Config.UnterminatedCharacterReferenceSettings.ACCEPT_ALL, previous);
    }

    private static CharacterReference findPreviousOrNext(Source source, int pos, Config.UnterminatedCharacterReferenceSettings unterminatedCharacterReferenceSettings, boolean previous) {
        ParseText parseText = source.getParseText();
        int n = pos = previous ? parseText.lastIndexOf('&', pos) : parseText.indexOf('&', pos);
        while (pos != -1) {
            CharacterReference characterReference = CharacterReference.construct(source, pos, unterminatedCharacterReferenceSettings);
            if (characterReference != null) {
                return characterReference;
            }
            pos = previous ? parseText.lastIndexOf('&', pos - 1) : parseText.indexOf('&', pos + 1);
        }
        return null;
    }

    static final StringBuffer appendHexadecimalCharacterReferenceString(StringBuffer sb, int codePoint) {
        return sb.append("&#x").append(Integer.toString(codePoint, 16)).append(';');
    }

    static final StringBuffer appendDecimalCharacterReferenceString(StringBuffer sb, int codePoint) {
        return sb.append("&#").append(codePoint).append(';');
    }

    private static CharacterReference construct(Source source, int begin, Config.UnterminatedCharacterReferenceSettings unterminatedCharacterReferenceSettings) {
        try {
            if (source.getParseText().charAt(begin) != '&') {
                return null;
            }
            return source.getParseText().charAt(begin + 1) == '#' ? NumericCharacterReference.construct(source, begin, unterminatedCharacterReferenceSettings) : CharacterEntityReference.construct(source, begin, unterminatedCharacterReferenceSettings.characterEntityReferenceMaxCodePoint);
        }
        catch (IndexOutOfBoundsException ex) {
            return null;
        }
    }

    private static StringBuffer appendDecode(StringBuffer sb, CharSequence encodedText, int pos, boolean insideAttributeValue, boolean convertNonBreakingSpaces) {
        CharacterReference characterReference;
        Config.UnterminatedCharacterReferenceSettings unterminatedCharacterReferenceSettings = Config.CurrentCompatibilityMode.getUnterminatedCharacterReferenceSettings(insideAttributeValue);
        int lastEnd = 0;
        Source source = new Source(encodedText);
        while ((characterReference = CharacterReference.findPreviousOrNext(source, pos, unterminatedCharacterReferenceSettings, false)) != null) {
            int ch;
            if (lastEnd != characterReference.getBegin()) {
                Util.appendTo(sb, encodedText, lastEnd, characterReference.getBegin());
            }
            sb.append((char)((ch = characterReference.getChar()) == 160 && convertNonBreakingSpaces ? 32 : ch));
            pos = lastEnd = characterReference.getEnd();
        }
        if (lastEnd != encodedText.length()) {
            Util.appendTo(sb, encodedText, lastEnd, encodedText.length());
        }
        return sb;
    }

    private static final class EncodingFilterWriter
    extends FilterWriter {
        StringBuffer sb = new StringBuffer(MAX_ENTITY_REFERENCE_LENGTH);

        public EncodingFilterWriter(Writer writer) {
            super(writer);
        }

        public void write(char ch) throws IOException {
            this.sb.setLength(0);
            CharacterReference.appendEncode(this.sb, ch);
            if (this.sb.length() == 1) {
                this.out.write(this.sb.charAt(0));
            } else {
                Util.appendTo(this.out, (CharSequence)this.sb);
            }
        }

        public void write(int chInt) throws IOException {
            this.write((char)chInt);
        }

        public void write(char[] cbuf, int off, int len) throws IOException {
            int end = off + len;
            for (int i = off; i < end; ++i) {
                this.write(cbuf[i]);
            }
        }

        public void write(String str, int off, int len) throws IOException {
            int end = off + len;
            for (int i = off; i < end; ++i) {
                this.write(str.charAt(i));
            }
        }
    }
}

