/*
 * Decompiled with CFR 0.152.
 */
package au.id.jericho.lib.html;

import au.id.jericho.lib.html.Attributes;
import au.id.jericho.lib.html.AttributesOutputSegment;
import au.id.jericho.lib.html.BlankOutputSegment;
import au.id.jericho.lib.html.CharOutputSegment;
import au.id.jericho.lib.html.CharStreamSource;
import au.id.jericho.lib.html.CharStreamSourceUtil;
import au.id.jericho.lib.html.FormControl;
import au.id.jericho.lib.html.FormFields;
import au.id.jericho.lib.html.OutputSegment;
import au.id.jericho.lib.html.OverlappingOutputSegmentsException;
import au.id.jericho.lib.html.ParseText;
import au.id.jericho.lib.html.Segment;
import au.id.jericho.lib.html.Source;
import au.id.jericho.lib.html.StringOutputSegment;
import au.id.jericho.lib.html.Util;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;

public final class OutputDocument
implements CharStreamSource {
    private CharSequence sourceText;
    private ArrayList outputSegments = new ArrayList();

    public OutputDocument(Source source) {
        if (source == null) {
            throw new IllegalArgumentException("source argument must not be null");
        }
        this.sourceText = source;
    }

    OutputDocument(ParseText parseText) {
        this.sourceText = parseText;
    }

    public CharSequence getSourceText() {
        return this.sourceText;
    }

    public void remove(Segment segment) {
        this.replace(segment, (CharSequence)null);
    }

    public void remove(Collection segments) {
        Iterator i = segments.iterator();
        while (i.hasNext()) {
            this.remove((Segment)i.next());
        }
    }

    public void insert(int pos, CharSequence text) {
        this.register(new StringOutputSegment(pos, pos, text));
    }

    public void replace(Segment segment, CharSequence text) {
        this.replace(segment.getBegin(), segment.getEnd(), text);
    }

    public void replace(int begin, int end, CharSequence text) {
        this.register(new StringOutputSegment(begin, end, text));
    }

    public void replace(int begin, int end, char ch) {
        this.register(new CharOutputSegment(begin, end, ch));
    }

    public void replace(FormControl formControl) {
        formControl.replaceInOutputDocument(this);
    }

    public void replace(FormFields formFields) {
        formFields.replaceInOutputDocument(this);
    }

    public Map replace(Attributes attributes, boolean convertNamesToLowerCase) {
        AttributesOutputSegment attributesOutputSegment = new AttributesOutputSegment(attributes, convertNamesToLowerCase);
        this.register(attributesOutputSegment);
        return attributesOutputSegment.getMap();
    }

    public void replace(Attributes attributes, Map map) {
        this.register(new AttributesOutputSegment(attributes, map));
    }

    public void replaceWithSpaces(int begin, int end) {
        this.register(new BlankOutputSegment(begin, end));
    }

    public void register(OutputSegment outputSegment) {
        this.outputSegments.add(outputSegment);
    }

    public void writeTo(Writer writer) throws IOException {
        if (this.outputSegments.isEmpty()) {
            Util.appendTo(writer, this.sourceText);
            return;
        }
        int pos = 0;
        Collections.sort(this.outputSegments, OutputSegment.COMPARATOR);
        OutputSegment lastOutputSegment = null;
        Iterator i = ((AbstractList)this.outputSegments).iterator();
        while (i.hasNext()) {
            OutputSegment outputSegment = (OutputSegment)i.next();
            if (outputSegment == lastOutputSegment) continue;
            if (outputSegment.getBegin() < pos) {
                throw new OverlappingOutputSegmentsException(lastOutputSegment, outputSegment);
            }
            if (outputSegment.getBegin() > pos) {
                Util.appendTo(writer, this.sourceText, pos, outputSegment.getBegin());
            }
            outputSegment.writeTo(writer);
            lastOutputSegment = outputSegment;
            pos = outputSegment.getEnd();
        }
        if (pos < this.sourceText.length()) {
            Util.appendTo(writer, this.sourceText, pos, this.sourceText.length());
        }
        writer.close();
    }

    public long getEstimatedMaximumOutputLength() {
        long estimatedMaximumOutputLength = this.sourceText.length();
        Iterator i = ((AbstractList)this.outputSegments).iterator();
        while (i.hasNext()) {
            OutputSegment outputSegment = (OutputSegment)i.next();
            int outputSegmentOriginalLength = outputSegment.getEnd() - outputSegment.getBegin();
            estimatedMaximumOutputLength += outputSegment.getEstimatedMaximumOutputLength() - (long)outputSegmentOriginalLength;
        }
        return estimatedMaximumOutputLength;
    }

    public String toString() {
        return CharStreamSourceUtil.toString(this);
    }

    public OutputDocument(CharSequence sourceText) {
        if (sourceText == null) {
            throw new IllegalArgumentException("sourceText argument must not be null");
        }
        this.sourceText = sourceText;
    }

    public void add(OutputSegment outputSegment) {
        this.register(outputSegment);
    }

    public void add(FormControl formControl) {
        this.replace(formControl);
    }

    public void add(FormFields formFields) {
        formFields.replaceInOutputDocument(this);
    }

    public void output(Writer writer) throws IOException {
        this.writeTo(writer);
    }

    public Reader getReader() {
        return CharStreamSourceUtil.getReader(this);
    }
}

