/*
 * Decompiled with CFR 0.152.
 */
package au.id.jericho.lib.html;

import au.id.jericho.lib.html.FormControl;
import au.id.jericho.lib.html.FormControlType;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;

public final class FormField {
    private final String name;
    private int userValueCount = 0;
    private boolean allowsMultipleValues = false;
    private LinkedHashSet predefinedValues = null;
    private final LinkedHashSet formControls = new LinkedHashSet();
    private transient FormControl firstFormControl = null;
    int columnIndex;

    FormField(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Collection getFormControls() {
        return this.formControls;
    }

    public FormControl getFormControl(String predefinedValue) {
        if (predefinedValue == null) {
            Iterator i = this.formControls.iterator();
            while (i.hasNext()) {
                FormControl formControl = (FormControl)i.next();
                if (!formControl.getFormControlType().hasPredefinedValue()) {
                    return formControl;
                }
                if (formControl.getFormControlType().getElementName() == "select" || formControl.getPredefinedValue() != null) continue;
                return formControl;
            }
        } else {
            Iterator i = this.formControls.iterator();
            while (i.hasNext()) {
                FormControl formControl = (FormControl)i.next();
                if (!(formControl.getFormControlType().getElementName() == "select" ? formControl.getPredefinedValues().contains(predefinedValue) : predefinedValue.equals(formControl.getPredefinedValue()))) continue;
                return formControl;
            }
        }
        return null;
    }

    public FormControl getFormControl() {
        return (FormControl)this.formControls.iterator().next();
    }

    public boolean allowsMultipleValues() {
        return this.allowsMultipleValues;
    }

    public int getUserValueCount() {
        return this.userValueCount;
    }

    public Collection getPredefinedValues() {
        return this.predefinedValues != null ? this.predefinedValues : Collections.EMPTY_SET;
    }

    public Collection getValues() {
        HashSet values = new HashSet();
        Iterator i = this.formControls.iterator();
        while (i.hasNext()) {
            ((FormControl)i.next()).addValuesTo(values);
        }
        return values;
    }

    public void clearValues() {
        Iterator i = this.formControls.iterator();
        while (i.hasNext()) {
            ((FormControl)i.next()).clearValues();
        }
    }

    public void setValues(Collection values) {
        this.clearValues();
        this.addValues(values);
    }

    public boolean setValue(CharSequence value) {
        this.clearValues();
        return value != null ? this.addValue(value) : true;
    }

    public boolean addValue(CharSequence value) {
        FormControl formControl;
        if (value == null) {
            throw new IllegalArgumentException("value argument must not be null");
        }
        if (this.formControls.size() == 1) {
            return this.getFirstFormControl().addValue(value);
        }
        LinkedList<FormControl> userValueControls = null;
        Iterator i = this.formControls.iterator();
        while (i.hasNext()) {
            formControl = (FormControl)i.next();
            if (!formControl.getFormControlType().hasPredefinedValue()) {
                if (userValueControls == null) {
                    userValueControls = new LinkedList<FormControl>();
                }
                userValueControls.add(formControl);
                continue;
            }
            if (!formControl.addValue(value)) continue;
            return true;
        }
        if (userValueControls == null) {
            return false;
        }
        i = userValueControls.iterator();
        while (i.hasNext()) {
            formControl = (FormControl)i.next();
            if (!formControl.addValue(value)) continue;
            return true;
        }
        return false;
    }

    public String getDebugInfo() {
        Iterator i;
        StringBuffer sb = new StringBuffer();
        sb.append("Field: ").append(this.name).append(", UserValueCount=").append(this.userValueCount).append(", AllowsMultipleValues=").append(this.allowsMultipleValues);
        if (this.predefinedValues != null) {
            i = this.predefinedValues.iterator();
            while (i.hasNext()) {
                sb.append("\nPredefinedValue: ");
                sb.append(i.next());
            }
        }
        i = this.formControls.iterator();
        while (i.hasNext()) {
            sb.append("\nFormControl: ");
            sb.append(((FormControl)i.next()).getDebugInfo());
        }
        sb.append("\n\n");
        return sb.toString();
    }

    public String toString() {
        return this.getDebugInfo();
    }

    void addValues(Collection values) {
        if (values != null) {
            Iterator i = values.iterator();
            while (i.hasNext()) {
                this.addValue((CharSequence)i.next());
            }
        }
    }

    void addValues(CharSequence[] values) {
        if (values != null) {
            for (int i = 0; i < values.length; ++i) {
                this.addValue(values[i]);
            }
        }
    }

    void addFormControl(FormControl formControl, String predefinedValue) {
        if (predefinedValue == null) {
            ++this.userValueCount;
        } else {
            if (this.predefinedValues == null) {
                this.predefinedValues = new LinkedHashSet();
            }
            this.predefinedValues.add(predefinedValue);
        }
        this.formControls.add(formControl);
        this.allowsMultipleValues = this.calculateAllowsMultipleValues(formControl);
    }

    private boolean calculateAllowsMultipleValues(FormControl newFormControl) {
        if (this.allowsMultipleValues || this.userValueCount > 1) {
            return true;
        }
        if (this.userValueCount == 1) {
            return this.predefinedValues != null;
        }
        if (this.predefinedValues.size() == 1) {
            return false;
        }
        FormControlType newFormControlType = newFormControl.getFormControlType();
        if (this.formControls.size() == 1) {
            return newFormControlType == FormControlType.SELECT_MULTIPLE;
        }
        FormControlType firstFormControlType = this.getFirstFormControl().getFormControlType();
        if (newFormControlType == FormControlType.RADIO && firstFormControlType == FormControlType.RADIO) {
            return false;
        }
        return !newFormControlType.isSubmit() || !firstFormControlType.isSubmit();
    }

    FormControl getFirstFormControl() {
        if (this.firstFormControl == null) {
            this.firstFormControl = (FormControl)this.formControls.iterator().next();
        }
        return this.firstFormControl;
    }

    void merge(FormField formField) {
        Iterator i;
        if (formField.userValueCount > this.userValueCount) {
            this.userValueCount = formField.userValueCount;
        }
        boolean bl = this.allowsMultipleValues = this.allowsMultipleValues || formField.allowsMultipleValues;
        if (this.predefinedValues == null) {
            this.predefinedValues = formField.predefinedValues;
        } else if (formField.predefinedValues != null) {
            i = formField.predefinedValues.iterator();
            while (i.hasNext()) {
                this.predefinedValues.add(i.next());
            }
        }
        i = formField.getFormControls().iterator();
        while (i.hasNext()) {
            this.formControls.add(i.next());
        }
    }
}

