/*
 * Decompiled with CFR 0.152.
 */
package net.fortytwo.sesametools.ldserver.query;

import java.util.Map;
import net.fortytwo.sesametools.ldserver.query.QueryException;
import net.fortytwo.sesametools.ldserver.query.QueryResource;
import net.fortytwo.sesametools.ldserver.query.SparqlQueryRepresentation;
import net.fortytwo.sesametools.ldserver.query.SparqlTools;
import org.openrdf.sail.SailException;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.data.MediaType;
import org.restlet.data.Method;
import org.restlet.data.Status;
import org.restlet.representation.Representation;
import org.restlet.resource.ResourceException;

public class SparqlResource
extends QueryResource {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void handle(Request request, Response response) {
        MediaType mt;
        Map<String, String> arguments;
        String query = null;
        try {
            arguments = this.getArguments(request);
            if (request.getMethod() == Method.POST) {
                String type = request.getEntity().getMediaType().toString();
                String ent = request.getEntity().getText();
                if (type.equals("application/x-www-form-urlencoded")) {
                    arguments = this.parseParams(ent);
                } else {
                    if (!type.equals("application/sparql-query")) throw new IllegalArgumentException("POST entity has unsupported media type for SPARQL");
                    query = ent;
                }
            }
            if (null == query) {
                query = arguments.get("query");
            }
            if (null == query) {
                throw new IllegalArgumentException("no query argument specified");
            }
            String output = arguments.get("output");
            if (null != output) {
                if (output.equals("json")) {
                    mt = SparqlTools.SparqlResultFormat.JSON.getMediaType();
                } else {
                    if (!output.equals("xml")) throw new IllegalArgumentException("bad value for 'output' parameter: " + output);
                    mt = SparqlTools.SparqlResultFormat.XML.getMediaType();
                }
            } else {
                mt = SparqlTools.SparqlResultFormat.getVariants().get(0).getMediaType();
            }
        }
        catch (Throwable t) {
            t.printStackTrace(System.err);
            throw new ResourceException(t);
        }
        try {
            response.setEntity((Representation)new SparqlQueryRepresentation(query, this.sail, this.readLimit(arguments), mt));
            return;
        }
        catch (QueryException e) {
            throw new ResourceException(Status.CLIENT_ERROR_BAD_REQUEST, (Throwable)e);
        }
        catch (SailException e) {
            e.printStackTrace(System.err);
            System.err.flush();
            throw new ResourceException(Status.SERVER_ERROR_INTERNAL, (Throwable)e);
        }
        catch (Throwable e) {
            e.printStackTrace(System.err);
            System.err.flush();
            throw new ResourceException(Status.SERVER_ERROR_INTERNAL, e);
        }
    }
}

