/*
 * Decompiled with CFR 0.152.
 */
package net.fortytwo.sesametools.ldserver;

import info.aduna.iteration.CloseableIteration;
import java.util.Collection;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.fortytwo.sesametools.ldserver.LinkedDataServer;
import net.fortytwo.sesametools.ldserver.RDFMediaTypes;
import net.fortytwo.sesametools.ldserver.RDFRepresentation;
import org.openrdf.model.Namespace;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.rio.RDFFormat;
import org.openrdf.sail.Sail;
import org.openrdf.sail.SailConnection;
import org.openrdf.sail.SailException;
import org.restlet.data.MediaType;
import org.restlet.representation.Representation;
import org.restlet.resource.Get;
import org.restlet.resource.ServerResource;

public class GraphResource
extends ServerResource {
    private static final Logger LOGGER = Logger.getLogger(GraphResource.class.getName());
    protected final String selfURI = this.getRequest().getResourceRef().toString();
    protected Sail sail;

    public GraphResource() {
        this.getVariants().addAll(RDFMediaTypes.getRDFVariants());
        this.sail = LinkedDataServer.getInstance().getSail();
    }

    @Get
    private Representation representInformationResource(Representation entity) {
        MediaType type = entity.getMediaType();
        RDFFormat format = RDFMediaTypes.findRdfFormat(type);
        try {
            URI subject = this.sail.getValueFactory().createURI(this.selfURI);
            return this.getRDFRepresentation(subject, format);
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addStatementsInGraph(Resource graph, Collection<Statement> statements, SailConnection c) throws SailException {
        CloseableIteration stIter = c.getStatements(null, null, null, false, new Resource[]{graph});
        try {
            while (stIter.hasNext()) {
                statements.add((Statement)stIter.next());
            }
        }
        finally {
            stIter.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Representation getRDFRepresentation(URI graph, RDFFormat format) {
        try {
            LinkedList<Namespace> namespaces = new LinkedList<Namespace>();
            LinkedList<Statement> statements = new LinkedList<Statement>();
            SailConnection c = this.sail.getConnection();
            try {
                this.addStatementsInGraph((Resource)graph, statements, c);
                CloseableIteration ns = c.getNamespaces();
                try {
                    while (ns.hasNext()) {
                        namespaces.add((Namespace)ns.next());
                    }
                }
                finally {
                    ns.close();
                }
            }
            finally {
                c.close();
            }
            return new RDFRepresentation(statements, namespaces, format);
        }
        catch (Throwable t) {
            t.printStackTrace();
            LOGGER.log(Level.WARNING, "failed to create RDF representation", t);
            return null;
        }
    }
}

