/*
 * Decompiled with CFR 0.152.
 */
package net.fortytwo.sesametools;

import info.aduna.iteration.CloseableIteration;
import net.fortytwo.sesametools.EmptyCloseableIteration;
import org.openrdf.model.Namespace;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.query.BindingSet;
import org.openrdf.query.Dataset;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.algebra.TupleExpr;
import org.openrdf.query.algebra.UpdateExpr;
import org.openrdf.query.impl.DatasetImpl;
import org.openrdf.sail.Sail;
import org.openrdf.sail.SailConnection;
import org.openrdf.sail.SailException;

class SingleContextSailConnection
implements SailConnection {
    private SailConnection baseSailConnection;
    private Resource singleContext;

    public SingleContextSailConnection(Sail baseSail, Resource context) throws SailException {
        this.baseSailConnection = baseSail.getConnection();
        this.singleContext = context;
    }

    public void addStatement(Resource subj, URI pred, Value obj, Resource ... contexts) throws SailException {
        if (0 == contexts.length) {
            this.baseSailConnection.addStatement(subj, pred, obj, new Resource[]{this.singleContext});
        } else {
            for (Resource context : contexts) {
                if (null == context || !context.equals(this.singleContext)) continue;
                this.baseSailConnection.addStatement(subj, pred, obj, new Resource[]{this.singleContext});
                break;
            }
        }
    }

    public void clear(Resource ... contexts) throws SailException {
        if (0 == contexts.length) {
            this.baseSailConnection.clear(new Resource[]{this.singleContext});
        } else {
            for (Resource context : contexts) {
                if (null == context || !context.equals(this.singleContext)) continue;
                this.baseSailConnection.clear(new Resource[]{this.singleContext});
                break;
            }
        }
    }

    public void clearNamespaces() throws SailException {
        this.baseSailConnection.clearNamespaces();
    }

    public void close() throws SailException {
        this.baseSailConnection.close();
    }

    public void commit() throws SailException {
        this.baseSailConnection.commit();
    }

    public CloseableIteration<? extends BindingSet, QueryEvaluationException> evaluate(TupleExpr tupleExpr, Dataset dataSet, BindingSet bindingSet, boolean includeInferred) throws SailException {
        DatasetImpl singleContextDataset = new DatasetImpl();
        if (this.singleContext instanceof URI) {
            singleContextDataset.setDefaultInsertGraph((URI)this.singleContext);
            singleContextDataset.addDefaultGraph((URI)this.singleContext);
            singleContextDataset.addNamedGraph((URI)this.singleContext);
            singleContextDataset.addDefaultRemoveGraph((URI)this.singleContext);
        }
        return this.baseSailConnection.evaluate(tupleExpr, (Dataset)singleContextDataset, bindingSet, includeInferred);
    }

    public void executeUpdate(UpdateExpr updateExpr, Dataset dataSet, BindingSet bindingSet, boolean includeInferred) throws SailException {
        DatasetImpl singleContextDataset = new DatasetImpl();
        if (this.singleContext instanceof URI) {
            singleContextDataset.setDefaultInsertGraph((URI)this.singleContext);
            singleContextDataset.addDefaultGraph((URI)this.singleContext);
            singleContextDataset.addNamedGraph((URI)this.singleContext);
            singleContextDataset.addDefaultRemoveGraph((URI)this.singleContext);
        }
        this.baseSailConnection.executeUpdate(updateExpr, (Dataset)singleContextDataset, bindingSet, includeInferred);
    }

    public CloseableIteration<? extends Resource, SailException> getContextIDs() throws SailException {
        return new SingleContextIteration();
    }

    public String getNamespace(String prefix) throws SailException {
        return this.baseSailConnection.getNamespace(prefix);
    }

    public CloseableIteration<? extends Namespace, SailException> getNamespaces() throws SailException {
        return this.baseSailConnection.getNamespaces();
    }

    public CloseableIteration<? extends Statement, SailException> getStatements(Resource subj, URI pred, Value obj, boolean includeInferred, Resource ... contexts) throws SailException {
        if (0 == contexts.length) {
            return this.baseSailConnection.getStatements(subj, pred, obj, includeInferred, new Resource[]{this.singleContext});
        }
        for (Resource context : contexts) {
            if (null == context || !context.equals(this.singleContext)) continue;
            return this.baseSailConnection.getStatements(subj, pred, obj, includeInferred, new Resource[]{this.singleContext});
        }
        return new EmptyCloseableIteration();
    }

    public boolean isOpen() throws SailException {
        return this.baseSailConnection.isOpen();
    }

    public void removeNamespace(String prefix) throws SailException {
        this.baseSailConnection.removeNamespace(prefix);
    }

    public void removeStatements(Resource subj, URI pred, Value obj, Resource ... contexts) throws SailException {
        if (0 == contexts.length) {
            this.baseSailConnection.removeStatements(subj, pred, obj, new Resource[]{this.singleContext});
        } else {
            for (Resource context : contexts) {
                if (null == context || !context.equals(this.singleContext)) continue;
                this.baseSailConnection.removeStatements(subj, pred, obj, new Resource[]{this.singleContext});
                break;
            }
        }
    }

    public void rollback() throws SailException {
        this.baseSailConnection.rollback();
    }

    public void setNamespace(String prefix, String name) throws SailException {
        this.baseSailConnection.setNamespace(prefix, name);
    }

    public long size(Resource ... contexts) throws SailException {
        if (0 == contexts.length) {
            return this.baseSailConnection.size(new Resource[]{this.singleContext});
        }
        for (Resource context : contexts) {
            if (null == context || !context.equals(this.singleContext)) continue;
            return this.baseSailConnection.size(new Resource[]{this.singleContext});
        }
        return 0L;
    }

    private class SingleContextIteration
    implements CloseableIteration<Resource, SailException> {
        private Resource nextContext;

        public SingleContextIteration() {
            this.nextContext = SingleContextSailConnection.this.singleContext;
        }

        public void close() throws SailException {
        }

        public boolean hasNext() throws SailException {
            return null != this.nextContext;
        }

        public Resource next() throws SailException {
            Resource r = this.nextContext;
            this.nextContext = null;
            return r;
        }

        public void remove() throws SailException {
        }
    }
}

