/*
 * Decompiled with CFR 0.152.
 */
package net.fortytwo.sesametools;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import net.fortytwo.sesametools.PatternIterator;
import org.openrdf.OpenRDFUtil;
import org.openrdf.model.Graph;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.impl.ValueFactoryImpl;

public class ArrayListGraphImpl
extends AbstractCollection<Statement>
implements Graph {
    private static final long serialVersionUID = -5307095904382050478L;
    protected List<Statement> statements = new ArrayList<Statement>(50);
    protected transient ValueFactory valueFactory;

    public ArrayListGraphImpl(ValueFactory valueFactory) {
        this.setValueFactory(valueFactory);
    }

    public ArrayListGraphImpl() {
        this((ValueFactory)new ValueFactoryImpl());
    }

    public ArrayListGraphImpl(ValueFactory valueFactory, Collection<? extends Statement> statements) {
        this(valueFactory);
        this.addAll(statements);
    }

    public ArrayListGraphImpl(Collection<? extends Statement> statements) {
        this((ValueFactory)new ValueFactoryImpl(), statements);
    }

    public ValueFactory getValueFactory() {
        return this.valueFactory;
    }

    public void setValueFactory(ValueFactory valueFactory) {
        this.valueFactory = valueFactory;
    }

    @Override
    public Iterator<Statement> iterator() {
        return this.statements.iterator();
    }

    @Override
    public int size() {
        return this.statements.size();
    }

    @Override
    public boolean add(Statement st) {
        return this.statements.add(st);
    }

    public boolean add(Resource subj, URI pred, Value obj, Resource ... contexts) {
        OpenRDFUtil.verifyContextNotNull((Resource[])contexts);
        boolean graphChanged = false;
        if (contexts.length == 0) {
            graphChanged = this.add(this.valueFactory.createStatement(subj, pred, obj));
        } else {
            for (Resource context : contexts) {
                graphChanged |= this.add(this.valueFactory.createStatement(subj, pred, obj, context));
            }
        }
        return graphChanged;
    }

    public Iterator<Statement> match(Resource subj, URI pred, Value obj, Resource ... contexts) {
        OpenRDFUtil.verifyContextNotNull((Resource[])contexts);
        return new PatternIterator(this.iterator(), subj, pred, obj, contexts);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.setValueFactory((ValueFactory)new ValueFactoryImpl());
    }
}

