/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.internal.utils.config.sharding;

import java.util.ArrayList;
import java.util.List;
import java.util.function.IntFunction;
import net.dv8tion.jda.api.hooks.IEventManager;
import net.dv8tion.jda.internal.utils.Checks;

public class EventConfig {
    private final List<Object> listeners = new ArrayList<Object>();
    private final List<IntFunction<Object>> listenerProviders = new ArrayList<IntFunction<Object>>();
    private final IntFunction<? extends IEventManager> eventManagerProvider;

    public EventConfig(IntFunction<? extends IEventManager> eventManagerProvider) {
        this.eventManagerProvider = eventManagerProvider;
    }

    public void addEventListener(Object listener) {
        Checks.notNull(listener, "Listener");
        this.listeners.add(listener);
    }

    public void removeEventListener(Object listener) {
        Checks.notNull(listener, "Listener");
        this.listeners.remove(listener);
    }

    public void addEventListenerProvider(IntFunction<Object> provider) {
        Checks.notNull(provider, "Provider");
        this.listenerProviders.add(provider);
    }

    public void removeEventListenerProvider(IntFunction<Object> provider) {
        Checks.notNull(provider, "Provider");
        this.listenerProviders.remove(provider);
    }

    public List<Object> getListeners() {
        return this.listeners;
    }

    public List<IntFunction<Object>> getListenerProviders() {
        return this.listenerProviders;
    }

    public IntFunction<? extends IEventManager> getEventManagerProvider() {
        return this.eventManagerProvider;
    }

    public static EventConfig getDefault() {
        return new EventConfig(null);
    }
}

