/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.internal.requests.restaction;

import java.util.function.BooleanSupplier;
import javax.annotation.CheckReturnValue;
import net.dv8tion.jda.api.JDA;
import net.dv8tion.jda.api.Permission;
import net.dv8tion.jda.api.entities.GuildChannel;
import net.dv8tion.jda.api.entities.IPermissionHolder;
import net.dv8tion.jda.api.entities.Member;
import net.dv8tion.jda.api.entities.PermissionOverride;
import net.dv8tion.jda.api.entities.Role;
import net.dv8tion.jda.api.requests.Request;
import net.dv8tion.jda.api.requests.Response;
import net.dv8tion.jda.api.requests.restaction.PermissionOverrideAction;
import net.dv8tion.jda.internal.entities.AbstractChannelImpl;
import net.dv8tion.jda.internal.entities.PermissionOverrideImpl;
import net.dv8tion.jda.internal.requests.Route;
import net.dv8tion.jda.internal.requests.restaction.AuditableRestActionImpl;
import net.dv8tion.jda.internal.utils.Checks;
import okhttp3.RequestBody;
import org.json.JSONObject;

public class PermissionOverrideActionImpl
extends AuditableRestActionImpl<PermissionOverride>
implements PermissionOverrideAction {
    private long allow = 0L;
    private long deny = 0L;
    private final GuildChannel channel;
    private final IPermissionHolder permissionHolder;

    public PermissionOverrideActionImpl(JDA api, GuildChannel channel, IPermissionHolder permissionHolder) {
        super(api, Route.Channels.CREATE_PERM_OVERRIDE.compile(channel.getId(), permissionHolder.getId()));
        this.channel = channel;
        this.permissionHolder = permissionHolder;
    }

    @Override
    public PermissionOverrideActionImpl setCheck(BooleanSupplier checks) {
        return (PermissionOverrideActionImpl)super.setCheck(checks);
    }

    @Override
    public GuildChannel getChannel() {
        return this.channel;
    }

    @Override
    public Role getRole() {
        return this.isRole() ? (Role)this.permissionHolder : null;
    }

    @Override
    public Member getMember() {
        return this.isMember() ? (Member)this.permissionHolder : null;
    }

    @Override
    public long getAllow() {
        return this.allow;
    }

    @Override
    public long getDeny() {
        return this.deny;
    }

    @Override
    public long getInherited() {
        return (this.allow ^ 0xFFFFFFFFFFFFFFFFL) & (this.deny ^ 0xFFFFFFFFFFFFFFFFL);
    }

    @Override
    public boolean isMember() {
        return this.permissionHolder instanceof Member;
    }

    @Override
    public boolean isRole() {
        return this.permissionHolder instanceof Role;
    }

    @Override
    @CheckReturnValue
    public PermissionOverrideActionImpl setAllow(long allowBits) {
        Checks.notNegative(allowBits, "Granted permissions value");
        Checks.check(allowBits <= Permission.ALL_PERMISSIONS, "Specified allow value may not be greater than a full permission set");
        this.allow = allowBits;
        this.deny &= allowBits ^ 0xFFFFFFFFFFFFFFFFL;
        return this;
    }

    @Override
    @CheckReturnValue
    public PermissionOverrideActionImpl setDeny(long denyBits) {
        Checks.notNegative(denyBits, "Denied permissions value");
        Checks.check(denyBits <= Permission.ALL_PERMISSIONS, "Specified deny value may not be greater than a full permission set");
        this.deny = denyBits;
        this.allow &= denyBits ^ 0xFFFFFFFFFFFFFFFFL;
        return this;
    }

    @Override
    @CheckReturnValue
    public PermissionOverrideActionImpl setPermissions(long allowBits, long denyBits) {
        this.setAllow(allowBits);
        this.setDeny(denyBits);
        return this;
    }

    @Override
    protected RequestBody finalizeData() {
        JSONObject object = new JSONObject();
        object.put("type", (Object)(this.isRole() ? "role" : "member"));
        object.put("allow", this.allow);
        object.put("deny", this.deny);
        return this.getRequestBody(object);
    }

    @Override
    protected void handleSuccess(Response response, Request<PermissionOverride> request) {
        long id = this.permissionHolder.getIdLong();
        JSONObject object = (JSONObject)request.getRawBody();
        PermissionOverrideImpl override = new PermissionOverrideImpl(this.channel, id, this.permissionHolder);
        override.setAllow(object.getLong("allow"));
        override.setDeny(object.getLong("deny"));
        ((AbstractChannelImpl)this.channel).getOverrideMap().put(id, (Object)override);
        request.onSuccess(override);
    }
}

