/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.internal.requests.restaction;

import java.util.function.BiFunction;
import java.util.function.BooleanSupplier;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import net.dv8tion.jda.api.JDA;
import net.dv8tion.jda.api.audit.ThreadLocalReason;
import net.dv8tion.jda.api.requests.Request;
import net.dv8tion.jda.api.requests.Response;
import net.dv8tion.jda.api.requests.restaction.AuditableRestAction;
import net.dv8tion.jda.api.utils.MiscUtil;
import net.dv8tion.jda.internal.requests.RestActionImpl;
import net.dv8tion.jda.internal.requests.Route;
import okhttp3.RequestBody;
import org.apache.commons.collections4.map.CaseInsensitiveMap;
import org.json.JSONObject;

public class AuditableRestActionImpl<T>
extends RestActionImpl<T>
implements AuditableRestAction<T> {
    protected String reason = null;

    public AuditableRestActionImpl(JDA api, Route.CompiledRoute route) {
        super(api, route);
    }

    public AuditableRestActionImpl(JDA api, Route.CompiledRoute route, RequestBody data) {
        super(api, route, data);
    }

    public AuditableRestActionImpl(JDA api, Route.CompiledRoute route, JSONObject data) {
        super(api, route, data);
    }

    public AuditableRestActionImpl(JDA api, Route.CompiledRoute route, BiFunction<Response, Request<T>, T> handler) {
        super(api, route, handler);
    }

    public AuditableRestActionImpl(JDA api, Route.CompiledRoute route, JSONObject data, BiFunction<Response, Request<T>, T> handler) {
        super(api, route, data, handler);
    }

    public AuditableRestActionImpl(JDA api, Route.CompiledRoute route, RequestBody data, BiFunction<Response, Request<T>, T> handler) {
        super(api, route, data, handler);
    }

    @Override
    public AuditableRestAction<T> setCheck(BooleanSupplier checks) {
        return (AuditableRestActionImpl)super.setCheck(checks);
    }

    @Override
    @CheckReturnValue
    public AuditableRestActionImpl<T> reason(String reason) {
        this.reason = reason;
        return this;
    }

    @Override
    protected CaseInsensitiveMap<String, String> finalizeHeaders() {
        CaseInsensitiveMap<String, String> headers = super.finalizeHeaders();
        if (this.reason == null || this.reason.isEmpty()) {
            String localReason = ThreadLocalReason.getCurrent();
            if (localReason == null || localReason.isEmpty()) {
                return headers;
            }
            return this.generateHeaders(headers, localReason);
        }
        return this.generateHeaders(headers, this.reason);
    }

    @Nonnull
    private CaseInsensitiveMap<String, String> generateHeaders(CaseInsensitiveMap<String, String> headers, String reason) {
        if (headers == null) {
            headers = new CaseInsensitiveMap();
        }
        headers.put((Object)"X-Audit-Log-Reason", (Object)this.uriEncode(reason));
        return headers;
    }

    private String uriEncode(String input) {
        String formEncode = MiscUtil.encodeUTF8(input);
        return formEncode.replace('+', ' ');
    }
}

