/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.internal.managers;

import java.util.Collection;
import java.util.EnumSet;
import javax.annotation.CheckReturnValue;
import net.dv8tion.jda.api.Permission;
import net.dv8tion.jda.api.entities.Member;
import net.dv8tion.jda.api.entities.Role;
import net.dv8tion.jda.api.exceptions.HierarchyException;
import net.dv8tion.jda.api.exceptions.InsufficientPermissionException;
import net.dv8tion.jda.api.managers.RoleManager;
import net.dv8tion.jda.internal.managers.ManagerBase;
import net.dv8tion.jda.internal.requests.Route;
import net.dv8tion.jda.internal.utils.Checks;
import net.dv8tion.jda.internal.utils.PermissionUtil;
import net.dv8tion.jda.internal.utils.cache.UpstreamReference;
import okhttp3.RequestBody;
import org.json.JSONObject;

public class RoleManagerImpl
extends ManagerBase<RoleManager>
implements RoleManager {
    protected final UpstreamReference<Role> role;
    protected String name;
    protected int color;
    protected long permissions;
    protected boolean hoist;
    protected boolean mentionable;

    public RoleManagerImpl(Role role) {
        super(role.getJDA(), Route.Roles.MODIFY_ROLE.compile(role.getGuild().getId(), role.getId()));
        this.role = new UpstreamReference<Role>(role);
        if (RoleManagerImpl.isPermissionChecksEnabled()) {
            this.checkPermissions();
        }
    }

    @Override
    public Role getRole() {
        return this.role.get();
    }

    @Override
    @CheckReturnValue
    public RoleManagerImpl reset(long fields) {
        super.reset(fields);
        if ((fields & 1L) == 1L) {
            this.name = null;
        }
        if ((fields & 2L) == 2L) {
            this.color = 0x1FFFFFFF;
        }
        return this;
    }

    @Override
    @CheckReturnValue
    public RoleManagerImpl reset(long ... fields) {
        super.reset(fields);
        return this;
    }

    @Override
    @CheckReturnValue
    public RoleManagerImpl reset() {
        super.reset();
        this.name = null;
        this.color = 0x1FFFFFFF;
        return this;
    }

    @Override
    @CheckReturnValue
    public RoleManagerImpl setName(String name) {
        Checks.notBlank(name, "Name");
        Checks.check(name.length() <= 32, "Name must be within 32 characters in length");
        this.name = name;
        this.set |= 1L;
        return this;
    }

    @Override
    @CheckReturnValue
    public RoleManagerImpl setPermissions(long perms) {
        EnumSet<Permission> permissionList;
        long selfPermissions = PermissionUtil.getEffectivePermission(this.getGuild().getSelfMember());
        this.setupPermissions();
        long missingPerms = perms;
        missingPerms &= selfPermissions ^ 0xFFFFFFFFFFFFFFFFL;
        if ((missingPerms &= this.permissions ^ 0xFFFFFFFFFFFFFFFFL) != 0L && RoleManagerImpl.isPermissionChecksEnabled() && !(permissionList = Permission.getPermissions(missingPerms)).isEmpty()) {
            throw new InsufficientPermissionException((Permission)((Object)permissionList.iterator().next()));
        }
        this.permissions = perms;
        this.set |= 4L;
        return this;
    }

    @Override
    @CheckReturnValue
    public RoleManagerImpl setColor(int rgb) {
        this.color = rgb;
        this.set |= 2L;
        return this;
    }

    @Override
    @CheckReturnValue
    public RoleManagerImpl setHoisted(boolean hoisted) {
        this.hoist = hoisted;
        this.set |= 8L;
        return this;
    }

    @Override
    @CheckReturnValue
    public RoleManagerImpl setMentionable(boolean mentionable) {
        this.mentionable = mentionable;
        this.set |= 0x10L;
        return this;
    }

    @Override
    @CheckReturnValue
    public RoleManagerImpl givePermissions(Collection<Permission> perms) {
        Checks.noneNull(perms, "Permissions");
        this.setupPermissions();
        return this.setPermissions(this.permissions | Permission.getRaw(perms));
    }

    @Override
    @CheckReturnValue
    public RoleManagerImpl revokePermissions(Collection<Permission> perms) {
        Checks.noneNull(perms, "Permissions");
        this.setupPermissions();
        return this.setPermissions(this.permissions & (Permission.getRaw(perms) ^ 0xFFFFFFFFFFFFFFFFL));
    }

    @Override
    protected RequestBody finalizeData() {
        JSONObject object = new JSONObject().put("name", (Object)this.getRole().getName());
        if (this.shouldUpdate(1L)) {
            object.put("name", (Object)this.name);
        }
        if (this.shouldUpdate(4L)) {
            object.put("permissions", this.permissions);
        }
        if (this.shouldUpdate(8L)) {
            object.put("hoist", this.hoist);
        }
        if (this.shouldUpdate(16L)) {
            object.put("mentionable", this.mentionable);
        }
        if (this.shouldUpdate(2L)) {
            object.put("color", this.color == 0x1FFFFFFF ? 0 : this.color & 0xFFFFFF);
        }
        this.reset();
        return this.getRequestBody(object);
    }

    @Override
    protected boolean checkPermissions() {
        Member selfMember = this.getGuild().getSelfMember();
        if (!selfMember.hasPermission(Permission.MANAGE_ROLES)) {
            throw new InsufficientPermissionException(Permission.MANAGE_ROLES);
        }
        if (!selfMember.canInteract(this.getRole())) {
            throw new HierarchyException("Cannot modify a role that is higher or equal in hierarchy");
        }
        return super.checkPermissions();
    }

    private void setupPermissions() {
        if (!this.shouldUpdate(4L)) {
            this.permissions = this.getRole().getPermissionsRaw();
        }
    }
}

