/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.internal.managers;

import javax.annotation.CheckReturnValue;
import net.dv8tion.jda.api.Permission;
import net.dv8tion.jda.api.Region;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.Icon;
import net.dv8tion.jda.api.entities.TextChannel;
import net.dv8tion.jda.api.entities.VoiceChannel;
import net.dv8tion.jda.api.exceptions.InsufficientPermissionException;
import net.dv8tion.jda.api.managers.GuildManager;
import net.dv8tion.jda.internal.managers.ManagerBase;
import net.dv8tion.jda.internal.requests.Route;
import net.dv8tion.jda.internal.utils.Checks;
import net.dv8tion.jda.internal.utils.cache.UpstreamReference;
import okhttp3.RequestBody;
import org.json.JSONObject;

public class GuildManagerImpl
extends ManagerBase<GuildManager>
implements GuildManager {
    protected final UpstreamReference<Guild> guild;
    protected String name;
    protected String region;
    protected Icon icon;
    protected Icon splash;
    protected String afkChannel;
    protected String systemChannel;
    protected int afkTimeout;
    protected int mfaLevel;
    protected int notificationLevel;
    protected int explicitContentLevel;
    protected int verificationLevel;

    public GuildManagerImpl(Guild guild) {
        super(guild.getJDA(), Route.Guilds.MODIFY_GUILD.compile(guild.getId()));
        this.guild = new UpstreamReference<Guild>(guild);
        if (GuildManagerImpl.isPermissionChecksEnabled()) {
            this.checkPermissions();
        }
    }

    @Override
    public Guild getGuild() {
        return this.guild.get();
    }

    @Override
    @CheckReturnValue
    public GuildManagerImpl reset(long fields) {
        super.reset(fields);
        if ((fields & 1L) == 1L) {
            this.name = null;
        }
        if ((fields & 2L) == 2L) {
            this.region = null;
        }
        if ((fields & 4L) == 4L) {
            this.icon = null;
        }
        if ((fields & 8L) == 8L) {
            this.splash = null;
        }
        if ((fields & 0x10L) == 16L) {
            this.afkChannel = null;
        }
        if ((fields & 0x40L) == 64L) {
            this.systemChannel = null;
        }
        return this;
    }

    @Override
    @CheckReturnValue
    public GuildManagerImpl reset(long ... fields) {
        super.reset(fields);
        return this;
    }

    @Override
    @CheckReturnValue
    public GuildManagerImpl reset() {
        super.reset();
        this.name = null;
        this.region = null;
        this.icon = null;
        this.splash = null;
        this.afkChannel = null;
        this.systemChannel = null;
        return this;
    }

    @Override
    @CheckReturnValue
    public GuildManagerImpl setName(String name) {
        Checks.notNull(name, "Name");
        Checks.check(name.length() >= 2 && name.length() <= 100, "Name must be between 2-100 characters long");
        this.name = name;
        this.set |= 1L;
        return this;
    }

    @Override
    @CheckReturnValue
    public GuildManagerImpl setRegion(Region region) {
        Checks.notNull((Object)region, "Region");
        Checks.check(region != Region.UNKNOWN, "Region must not be UNKNOWN");
        Checks.check(!region.isVip() || this.getGuild().getFeatures().contains("VIP_REGIONS"), "Cannot set a VIP voice region on this guild");
        this.region = region.getKey();
        this.set |= 2L;
        return this;
    }

    @Override
    @CheckReturnValue
    public GuildManagerImpl setIcon(Icon icon) {
        this.icon = icon;
        this.set |= 4L;
        return this;
    }

    @Override
    @CheckReturnValue
    public GuildManagerImpl setSplash(Icon splash) {
        Checks.check(splash == null || this.getGuild().getFeatures().contains("INVITE_SPLASH"), "Cannot set a splash on this guild");
        this.splash = splash;
        this.set |= 8L;
        return this;
    }

    @Override
    @CheckReturnValue
    public GuildManagerImpl setAfkChannel(VoiceChannel afkChannel) {
        Checks.check(afkChannel == null || afkChannel.getGuild().equals(this.getGuild()), "Channel must be from the same guild");
        this.afkChannel = afkChannel == null ? null : afkChannel.getId();
        this.set |= 0x10L;
        return this;
    }

    @Override
    @CheckReturnValue
    public GuildManagerImpl setSystemChannel(TextChannel systemChannel) {
        Checks.check(systemChannel == null || systemChannel.getGuild().equals(this.getGuild()), "Channel must be from the same guild");
        this.systemChannel = systemChannel == null ? null : systemChannel.getId();
        this.set |= 0x40L;
        return this;
    }

    @Override
    @CheckReturnValue
    public GuildManagerImpl setAfkTimeout(Guild.Timeout timeout) {
        Checks.notNull((Object)timeout, "Timeout");
        this.afkTimeout = timeout.getSeconds();
        this.set |= 0x20L;
        return this;
    }

    @Override
    @CheckReturnValue
    public GuildManagerImpl setVerificationLevel(Guild.VerificationLevel level) {
        Checks.notNull((Object)level, "Level");
        Checks.check(level != Guild.VerificationLevel.UNKNOWN, "Level must not be UNKNOWN");
        this.verificationLevel = level.getKey();
        this.set |= 0x400L;
        return this;
    }

    @Override
    @CheckReturnValue
    public GuildManagerImpl setDefaultNotificationLevel(Guild.NotificationLevel level) {
        Checks.notNull((Object)level, "Level");
        Checks.check(level != Guild.NotificationLevel.UNKNOWN, "Level must not be UNKNOWN");
        this.notificationLevel = level.getKey();
        this.set |= 0x100L;
        return this;
    }

    @Override
    @CheckReturnValue
    public GuildManagerImpl setRequiredMFALevel(Guild.MFALevel level) {
        Checks.notNull((Object)level, "Level");
        Checks.check(level != Guild.MFALevel.UNKNOWN, "Level must not be UNKNOWN");
        this.mfaLevel = level.getKey();
        this.set |= 0x80L;
        return this;
    }

    @Override
    @CheckReturnValue
    public GuildManagerImpl setExplicitContentLevel(Guild.ExplicitContentLevel level) {
        Checks.notNull((Object)level, "Level");
        Checks.check(level != Guild.ExplicitContentLevel.UNKNOWN, "Level must not be UNKNOWN");
        this.explicitContentLevel = level.getKey();
        this.set |= 0x200L;
        return this;
    }

    @Override
    protected RequestBody finalizeData() {
        JSONObject body = new JSONObject().put("name", (Object)this.getGuild().getName());
        if (this.shouldUpdate(1L)) {
            body.put("name", (Object)this.name);
        }
        if (this.shouldUpdate(2L)) {
            body.put("region", (Object)this.region);
        }
        if (this.shouldUpdate(32L)) {
            body.put("afk_timeout", this.afkTimeout);
        }
        if (this.shouldUpdate(4L)) {
            body.put("icon", this.icon == null ? JSONObject.NULL : this.icon.getEncoding());
        }
        if (this.shouldUpdate(8L)) {
            body.put("splash", this.splash == null ? JSONObject.NULL : this.splash.getEncoding());
        }
        if (this.shouldUpdate(16L)) {
            body.put("afk_channel_id", this.opt(this.afkChannel));
        }
        if (this.shouldUpdate(64L)) {
            body.put("system_channel_id", this.opt(this.systemChannel));
        }
        if (this.shouldUpdate(1024L)) {
            body.put("verification_level", this.verificationLevel);
        }
        if (this.shouldUpdate(256L)) {
            body.put("default_message_notifications", this.notificationLevel);
        }
        if (this.shouldUpdate(128L)) {
            body.put("mfa_level", this.mfaLevel);
        }
        if (this.shouldUpdate(512L)) {
            body.put("explicit_content_filter", this.explicitContentLevel);
        }
        this.reset();
        return this.getRequestBody(body);
    }

    @Override
    protected boolean checkPermissions() {
        if (!this.getGuild().getSelfMember().hasPermission(Permission.MANAGE_SERVER)) {
            throw new InsufficientPermissionException(Permission.MANAGE_SERVER);
        }
        return super.checkPermissions();
    }
}

