/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.internal.handle;

import net.dv8tion.jda.api.entities.ChannelType;
import net.dv8tion.jda.internal.JDAImpl;
import net.dv8tion.jda.internal.entities.EntityBuilder;
import net.dv8tion.jda.internal.handle.SocketHandler;
import net.dv8tion.jda.internal.requests.WebSocketClient;
import org.json.JSONArray;
import org.json.JSONObject;

public class ReadyHandler
extends SocketHandler {
    public ReadyHandler(JDAImpl api) {
        super(api);
    }

    @Override
    protected Long handleInternally(JSONObject content) {
        EntityBuilder builder = this.getJDA().getEntityBuilder();
        JSONArray guilds = content.getJSONArray("guilds");
        JSONObject selfJson = content.getJSONObject("user");
        builder.createSelfUser(selfJson);
        if (this.getJDA().getGuildSetupController().setIncompleteCount(guilds.length())) {
            for (int i = 0; i < guilds.length(); ++i) {
                JSONObject guild = guilds.getJSONObject(i);
                this.getJDA().getGuildSetupController().onReady(guild.getLong("id"), guild);
            }
        }
        this.handleReady(content);
        return null;
    }

    public void handleReady(JSONObject content) {
        EntityBuilder builder = this.getJDA().getEntityBuilder();
        JSONArray privateChannels = content.getJSONArray("private_channels");
        block3: for (int i = 0; i < privateChannels.length(); ++i) {
            JSONObject chan = privateChannels.getJSONObject(i);
            ChannelType type = ChannelType.fromId(chan.getInt("type"));
            switch (type) {
                case PRIVATE: {
                    builder.createPrivateChannel(chan);
                    continue block3;
                }
                default: {
                    WebSocketClient.LOG.warn("Received a Channel in the private_channels array in READY of an unknown type! Type: {}", (Object)type);
                }
            }
        }
    }
}

