/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.internal.handle;

import net.dv8tion.jda.api.entities.ChannelType;
import net.dv8tion.jda.api.events.channel.category.CategoryCreateEvent;
import net.dv8tion.jda.api.events.channel.priv.PrivateChannelCreateEvent;
import net.dv8tion.jda.api.events.channel.text.TextChannelCreateEvent;
import net.dv8tion.jda.api.events.channel.voice.VoiceChannelCreateEvent;
import net.dv8tion.jda.internal.JDAImpl;
import net.dv8tion.jda.internal.handle.SocketHandler;
import net.dv8tion.jda.internal.requests.WebSocketClient;
import org.json.JSONObject;

public class ChannelCreateHandler
extends SocketHandler {
    public ChannelCreateHandler(JDAImpl api) {
        super(api);
    }

    @Override
    protected Long handleInternally(JSONObject content) {
        ChannelType type = ChannelType.fromId(content.getInt("type"));
        long guildId = 0L;
        if (type.isGuild()) {
            guildId = content.getLong("guild_id");
            if (this.getJDA().getGuildSetupController().isLocked(guildId)) {
                return guildId;
            }
        }
        switch (type) {
            case TEXT: {
                this.getJDA().getEventManager().handle(new TextChannelCreateEvent(this.getJDA(), this.responseNumber, this.getJDA().getEntityBuilder().createTextChannel(content, guildId)));
                break;
            }
            case VOICE: {
                this.getJDA().getEventManager().handle(new VoiceChannelCreateEvent(this.getJDA(), this.responseNumber, this.getJDA().getEntityBuilder().createVoiceChannel(content, guildId)));
                break;
            }
            case CATEGORY: {
                this.getJDA().getEventManager().handle(new CategoryCreateEvent(this.getJDA(), this.responseNumber, this.getJDA().getEntityBuilder().createCategory(content, guildId)));
                break;
            }
            case PRIVATE: {
                this.getJDA().getEventManager().handle(new PrivateChannelCreateEvent(this.getJDA(), this.responseNumber, this.getJDA().getEntityBuilder().createPrivateChannel(content)));
                break;
            }
            case GROUP: {
                WebSocketClient.LOG.warn("Received a CREATE_CHANNEL for a group which is not supported");
                return null;
            }
            default: {
                throw new IllegalArgumentException("Discord provided an CREATE_CHANNEL event with an unknown channel type! JSON: " + content);
            }
        }
        return null;
    }
}

