/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.internal.entities;

import gnu.trove.map.TLongObjectMap;
import java.time.OffsetDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.dv8tion.jda.api.AccountType;
import net.dv8tion.jda.api.JDA;
import net.dv8tion.jda.api.Permission;
import net.dv8tion.jda.api.Region;
import net.dv8tion.jda.api.entities.Category;
import net.dv8tion.jda.api.entities.Emote;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.GuildChannel;
import net.dv8tion.jda.api.entities.GuildVoiceState;
import net.dv8tion.jda.api.entities.Invite;
import net.dv8tion.jda.api.entities.ListedEmote;
import net.dv8tion.jda.api.entities.Member;
import net.dv8tion.jda.api.entities.Role;
import net.dv8tion.jda.api.entities.TextChannel;
import net.dv8tion.jda.api.entities.User;
import net.dv8tion.jda.api.entities.VoiceChannel;
import net.dv8tion.jda.api.entities.Webhook;
import net.dv8tion.jda.api.exceptions.InsufficientPermissionException;
import net.dv8tion.jda.api.exceptions.PermissionException;
import net.dv8tion.jda.api.managers.AudioManager;
import net.dv8tion.jda.api.managers.GuildController;
import net.dv8tion.jda.api.managers.GuildManager;
import net.dv8tion.jda.api.requests.RestAction;
import net.dv8tion.jda.api.requests.restaction.MemberAction;
import net.dv8tion.jda.api.requests.restaction.pagination.AuditLogPaginationAction;
import net.dv8tion.jda.api.utils.MiscUtil;
import net.dv8tion.jda.api.utils.cache.MemberCacheView;
import net.dv8tion.jda.api.utils.cache.SnowflakeCacheView;
import net.dv8tion.jda.api.utils.cache.SortedSnowflakeCacheView;
import net.dv8tion.jda.internal.JDAImpl;
import net.dv8tion.jda.internal.entities.EmoteImpl;
import net.dv8tion.jda.internal.entities.EntityBuilder;
import net.dv8tion.jda.internal.entities.WebhookImpl;
import net.dv8tion.jda.internal.managers.AudioManagerImpl;
import net.dv8tion.jda.internal.managers.GuildManagerImpl;
import net.dv8tion.jda.internal.requests.EmptyRestAction;
import net.dv8tion.jda.internal.requests.RestActionImpl;
import net.dv8tion.jda.internal.requests.Route;
import net.dv8tion.jda.internal.requests.restaction.MemberActionImpl;
import net.dv8tion.jda.internal.requests.restaction.pagination.AuditLogPaginationActionImpl;
import net.dv8tion.jda.internal.utils.Checks;
import net.dv8tion.jda.internal.utils.Helpers;
import net.dv8tion.jda.internal.utils.UnlockHook;
import net.dv8tion.jda.internal.utils.cache.AbstractCacheView;
import net.dv8tion.jda.internal.utils.cache.MemberCacheViewImpl;
import net.dv8tion.jda.internal.utils.cache.SnowflakeCacheViewImpl;
import net.dv8tion.jda.internal.utils.cache.SortedSnowflakeCacheViewImpl;
import net.dv8tion.jda.internal.utils.cache.UpstreamReference;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class GuildImpl
implements Guild {
    private final long id;
    private final UpstreamReference<JDAImpl> api;
    private final SortedSnowflakeCacheViewImpl<Category> categoryCache = new SortedSnowflakeCacheViewImpl<Category>(Category.class, GuildChannel::getName, Comparator.naturalOrder());
    private final SortedSnowflakeCacheViewImpl<VoiceChannel> voiceChannelCache = new SortedSnowflakeCacheViewImpl<VoiceChannel>(VoiceChannel.class, GuildChannel::getName, Comparator.naturalOrder());
    private final SortedSnowflakeCacheViewImpl<TextChannel> textChannelCache = new SortedSnowflakeCacheViewImpl<TextChannel>(TextChannel.class, GuildChannel::getName, Comparator.naturalOrder());
    private final SortedSnowflakeCacheViewImpl<Role> roleCache = new SortedSnowflakeCacheViewImpl<Role>(Role.class, Role::getName, Comparator.reverseOrder());
    private final SnowflakeCacheViewImpl<Emote> emoteCache = new SnowflakeCacheViewImpl<Emote>(Emote.class, Emote::getName);
    private final MemberCacheViewImpl memberCache = new MemberCacheViewImpl();
    private final TLongObjectMap<JSONObject> cachedPresences = MiscUtil.newLongMap();
    private final ReentrantLock mngLock = new ReentrantLock();
    private volatile GuildManager manager;
    private volatile GuildController controller;
    private Member owner;
    private String name;
    private String iconId;
    private String splashId;
    private String region;
    private long ownerId;
    private Set<String> features;
    private VoiceChannel afkChannel;
    private TextChannel systemChannel;
    private Role publicRole;
    private Guild.VerificationLevel verificationLevel;
    private Guild.NotificationLevel defaultNotificationLevel;
    private Guild.MFALevel mfaLevel;
    private Guild.ExplicitContentLevel explicitContentLevel;
    private Guild.Timeout afkTimeout;
    private boolean available;
    private boolean canSendVerification = false;

    public GuildImpl(JDAImpl api, long id) {
        this.id = id;
        this.api = new UpstreamReference<JDAImpl>(api);
    }

    @Override
    public RestAction<EnumSet<Region>> retrieveRegions(boolean includeDeprecated) {
        Route.CompiledRoute route = Route.Guilds.GET_VOICE_REGIONS.compile(this.getId());
        return new RestActionImpl<EnumSet<Region>>((JDA)this.getJDA(), route, (response, request) -> {
            EnumSet<Region> set = EnumSet.noneOf(Region.class);
            JSONArray arr = response.getArray();
            for (int i = 0; arr != null && i < arr.length(); ++i) {
                String id;
                Region region;
                JSONObject obj = arr.getJSONObject(i);
                if (!includeDeprecated && Helpers.optBoolean(obj, "deprecated") || (region = Region.fromKey(id = obj.optString("id"))) == Region.UNKNOWN) continue;
                set.add(region);
            }
            return set;
        });
    }

    @Override
    public MemberAction addMember(String accessToken, String userId) {
        Checks.notBlank(accessToken, "Access-Token");
        Checks.isSnowflake(userId, "User ID");
        Checks.check(this.getMemberById(userId) == null, "User is already in this guild");
        if (!this.getSelfMember().hasPermission(Permission.CREATE_INSTANT_INVITE)) {
            throw new InsufficientPermissionException(Permission.CREATE_INSTANT_INVITE);
        }
        return new MemberActionImpl((JDA)this.getJDA(), this, userId, accessToken);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getIconId() {
        return this.iconId;
    }

    @Override
    public String getIconUrl() {
        return this.iconId == null ? null : "https://cdn.discordapp.com/icons/" + this.id + "/" + this.iconId + ".png";
    }

    @Override
    public Set<String> getFeatures() {
        return this.features;
    }

    @Override
    public String getSplashId() {
        return this.splashId;
    }

    @Override
    public String getSplashUrl() {
        return this.splashId == null ? null : "https://cdn.discordapp.com/splashes/" + this.id + "/" + this.splashId + ".png";
    }

    @Override
    public RestAction<String> retrieveVanityUrl() {
        if (!this.getSelfMember().hasPermission(Permission.MANAGE_SERVER)) {
            throw new InsufficientPermissionException(Permission.MANAGE_SERVER);
        }
        if (!this.getFeatures().contains("VANITY_URL")) {
            throw new IllegalStateException("This guild doesn't have a vanity url");
        }
        Route.CompiledRoute route = Route.Guilds.GET_VANITY_URL.compile(this.getId());
        return new RestActionImpl<String>((JDA)this.getJDA(), route, (response, request) -> response.getObject().getString("code"));
    }

    @Override
    public VoiceChannel getAfkChannel() {
        return this.afkChannel;
    }

    @Override
    public TextChannel getSystemChannel() {
        return this.systemChannel;
    }

    @Override
    public RestAction<List<Webhook>> retrieveWebhooks() {
        if (!this.getSelfMember().hasPermission(Permission.MANAGE_WEBHOOKS)) {
            throw new InsufficientPermissionException(Permission.MANAGE_WEBHOOKS);
        }
        Route.CompiledRoute route = Route.Guilds.GET_WEBHOOKS.compile(this.getId());
        return new RestActionImpl<List<Webhook>>((JDA)this.getJDA(), route, (response, request) -> {
            JSONArray array = response.getArray();
            ArrayList<WebhookImpl> webhooks = new ArrayList<WebhookImpl>(array.length());
            EntityBuilder builder = this.api.get().getEntityBuilder();
            for (Object object : array) {
                try {
                    webhooks.add(builder.createWebhook((JSONObject)object));
                }
                catch (NullPointerException | JSONException e) {
                    JDAImpl.LOG.error("Error creating webhook from json", e);
                }
            }
            return Collections.unmodifiableList(webhooks);
        });
    }

    @Override
    public Member getOwner() {
        return this.owner;
    }

    @Override
    public long getOwnerIdLong() {
        return this.ownerId;
    }

    @Override
    public Guild.Timeout getAfkTimeout() {
        return this.afkTimeout;
    }

    @Override
    public String getRegionRaw() {
        return this.region;
    }

    @Override
    public boolean isMember(User user) {
        return this.memberCache.get(user.getIdLong()) != null;
    }

    @Override
    public Member getSelfMember() {
        return this.getMember(this.getJDA().getSelfUser());
    }

    @Override
    public Member getMember(User user) {
        return this.getMemberById(user.getIdLong());
    }

    @Override
    public MemberCacheView getMemberCache() {
        return this.memberCache;
    }

    @Override
    public SortedSnowflakeCacheView<Category> getCategoryCache() {
        return this.categoryCache;
    }

    @Override
    public SortedSnowflakeCacheView<TextChannel> getTextChannelCache() {
        return this.textChannelCache;
    }

    @Override
    public SortedSnowflakeCacheView<VoiceChannel> getVoiceChannelCache() {
        return this.voiceChannelCache;
    }

    @Override
    public SortedSnowflakeCacheView<Role> getRoleCache() {
        return this.roleCache;
    }

    @Override
    public SnowflakeCacheView<Emote> getEmoteCache() {
        return this.emoteCache;
    }

    @Override
    public List<GuildChannel> getChannels(boolean includeHidden) {
        ArrayList<GuildChannel> channels;
        List categories;
        List voiceChannels;
        List textChannels;
        Member self = this.getSelfMember();
        Predicate<GuildChannel> filterHidden = it -> self.hasPermission((GuildChannel)it, Permission.VIEW_CHANNEL);
        SnowflakeCacheViewImpl<Category> categoryView = this.getCategoriesView();
        SnowflakeCacheViewImpl<VoiceChannel> voiceView = this.getVoiceChannelsView();
        SnowflakeCacheViewImpl<TextChannel> textView = this.getTextChannelsView();
        try (UnlockHook categoryHook = categoryView.readLock();
             UnlockHook voiceHook = voiceView.readLock();
             UnlockHook textHook = textView.readLock();){
            if (includeHidden) {
                textChannels = textView.asList();
                voiceChannels = voiceView.asList();
            } else {
                textChannels = textView.stream().filter(filterHidden).collect(Collectors.toList());
                voiceChannels = voiceView.stream().filter(filterHidden).collect(Collectors.toList());
            }
            categories = categoryView.asList();
            channels = new ArrayList<GuildChannel>((int)categoryView.size() + voiceChannels.size() + textChannels.size());
        }
        textChannels.stream().filter(it -> it.getParent() == null).forEach(channels::add);
        voiceChannels.stream().filter(it -> it.getParent() == null).forEach(channels::add);
        for (Category category : categories) {
            List<VoiceChannel> childVoiceChannels;
            List<TextChannel> childTextChannels;
            if (includeHidden) {
                childTextChannels = category.getTextChannels();
                childVoiceChannels = category.getVoiceChannels();
            } else {
                childTextChannels = category.getTextChannels().stream().filter(filterHidden).collect(Collectors.toList());
                childVoiceChannels = category.getVoiceChannels().stream().filter(filterHidden).collect(Collectors.toList());
                if (childTextChannels.isEmpty() && childVoiceChannels.isEmpty()) continue;
            }
            channels.add(category);
            channels.addAll(childTextChannels);
            channels.addAll(childVoiceChannels);
        }
        return Collections.unmodifiableList(channels);
    }

    @Override
    public RestAction<List<ListedEmote>> retrieveEmotes() {
        Route.CompiledRoute route = Route.Emotes.GET_EMOTES.compile(this.getId());
        return new RestActionImpl<List<ListedEmote>>((JDA)this.getJDA(), route, (response, request) -> {
            EntityBuilder builder = this.getJDA().getEntityBuilder();
            JSONArray emotes = response.getArray();
            ArrayList<EmoteImpl> list = new ArrayList<EmoteImpl>(emotes.length());
            for (int i = 0; i < emotes.length(); ++i) {
                JSONObject emote = emotes.getJSONObject(i);
                list.add(builder.createEmote(this, emote, true));
            }
            return Collections.unmodifiableList(list);
        });
    }

    @Override
    public RestAction<ListedEmote> retrieveEmoteById(String id) {
        ListedEmote listedEmote;
        Checks.isSnowflake(id, "Emote ID");
        Emote emote = this.getEmoteById(id);
        if (emote != null && ((listedEmote = (ListedEmote)emote).hasUser() || !this.getSelfMember().hasPermission(Permission.MANAGE_EMOTES))) {
            return new EmptyRestAction<ListedEmote>(this.getJDA(), listedEmote);
        }
        Route.CompiledRoute route = Route.Emotes.GET_EMOTE.compile(this.getId(), id);
        return new RestActionImpl<ListedEmote>((JDA)this.getJDA(), route, (response, request) -> {
            EntityBuilder builder = this.getJDA().getEntityBuilder();
            return builder.createEmote(this, response.getObject(), true);
        });
    }

    @Nonnull
    public RestActionImpl<List<Guild.Ban>> retrieveBanList() {
        if (!this.getSelfMember().hasPermission(Permission.BAN_MEMBERS)) {
            throw new InsufficientPermissionException(Permission.BAN_MEMBERS);
        }
        Route.CompiledRoute route = Route.Guilds.GET_BANS.compile(this.getId());
        return new RestActionImpl<List<Guild.Ban>>((JDA)this.getJDA(), route, (response, request) -> {
            EntityBuilder builder = this.api.get().getEntityBuilder();
            LinkedList<Guild.Ban> bans = new LinkedList<Guild.Ban>();
            JSONArray bannedArr = response.getArray();
            for (int i = 0; i < bannedArr.length(); ++i) {
                JSONObject object = bannedArr.getJSONObject(i);
                JSONObject user = object.getJSONObject("user");
                bans.add(new Guild.Ban(builder.createFakeUser(user, false), object.optString("reason", null)));
            }
            return Collections.unmodifiableList(bans);
        });
    }

    @Override
    @Nonnull
    public RestAction<Guild.Ban> retrieveBanById(@Nonnull String userId) {
        if (!this.getSelfMember().hasPermission(Permission.BAN_MEMBERS)) {
            throw new InsufficientPermissionException(Permission.BAN_MEMBERS);
        }
        Checks.isSnowflake(userId, "User ID");
        Route.CompiledRoute route = Route.Guilds.GET_BAN.compile(this.getId(), userId);
        return new RestActionImpl<Guild.Ban>((JDA)this.getJDA(), route, (response, request) -> {
            EntityBuilder builder = this.api.get().getEntityBuilder();
            JSONObject bannedObj = response.getObject();
            JSONObject user = bannedObj.getJSONObject("user");
            return new Guild.Ban(builder.createFakeUser(user, false), bannedObj.optString("reason", null));
        });
    }

    @Override
    public RestAction<Integer> retrievePrunableMemberCount(int days) {
        if (!this.getSelfMember().hasPermission(Permission.KICK_MEMBERS)) {
            throw new InsufficientPermissionException(Permission.KICK_MEMBERS);
        }
        if (days < 1) {
            throw new IllegalArgumentException("Days amount must be at minimum 1 day.");
        }
        Route.CompiledRoute route = Route.Guilds.PRUNABLE_COUNT.compile(this.getId()).withQueryParams("days", Integer.toString(days));
        return new RestActionImpl<Integer>((JDA)this.getJDA(), route, (response, request) -> response.getObject().getInt("pruned"));
    }

    @Override
    public Role getPublicRole() {
        return this.publicRole;
    }

    @Override
    @Nullable
    public TextChannel getDefaultChannel() {
        Role role = this.getPublicRole();
        return this.getTextChannelsView().stream().filter(c -> role.hasPermission((GuildChannel)c, Permission.MESSAGE_READ)).sorted(Comparator.naturalOrder()).findFirst().orElse(null);
    }

    @Override
    public GuildManager getManager() {
        GuildManager mng = this.manager;
        if (mng == null) {
            mng = MiscUtil.locked(this.mngLock, () -> {
                if (this.manager == null) {
                    this.manager = new GuildManagerImpl(this);
                }
                return this.manager;
            });
        }
        return mng;
    }

    @Override
    public GuildController getController() {
        GuildController ctrl = this.controller;
        if (ctrl == null) {
            ctrl = MiscUtil.locked(this.mngLock, () -> {
                if (this.controller == null) {
                    this.controller = new GuildController(this);
                }
                return this.controller;
            });
        }
        return ctrl;
    }

    @Override
    public AuditLogPaginationAction retrieveAuditLogs() {
        return new AuditLogPaginationActionImpl(this);
    }

    @Override
    public RestAction<Void> leave() {
        if (this.owner.equals(this.getSelfMember())) {
            throw new IllegalStateException("Cannot leave a guild that you are the owner of! Transfer guild ownership first!");
        }
        Route.CompiledRoute route = Route.Self.LEAVE_GUILD.compile(this.getId());
        return new RestActionImpl<Void>(this.getJDA(), route);
    }

    @Override
    public RestAction<Void> delete() {
        if (!this.getJDA().getSelfUser().isBot() && this.getJDA().getSelfUser().isMfaEnabled()) {
            throw new IllegalStateException("Cannot delete a guild without providing MFA code. Use Guild#delete(String)");
        }
        return this.delete(null);
    }

    @Override
    public RestAction<Void> delete(String mfaCode) {
        if (!this.owner.equals(this.getSelfMember())) {
            throw new PermissionException("Cannot delete a guild that you do not own!");
        }
        JSONObject mfaBody = null;
        if (!this.getJDA().getSelfUser().isBot() && this.getJDA().getSelfUser().isMfaEnabled()) {
            Checks.notEmpty(mfaCode, "Provided MultiFactor Auth code");
            mfaBody = new JSONObject().put("code", (Object)mfaCode);
        }
        Route.CompiledRoute route = Route.Guilds.DELETE_GUILD.compile(this.getId());
        return new RestActionImpl<Void>((JDA)this.getJDA(), route, mfaBody);
    }

    @Override
    public AudioManager getAudioManager() {
        if (!this.getJDA().isAudioEnabled()) {
            throw new IllegalStateException("Audio is disabled. Cannot retrieve an AudioManager while audio is disabled.");
        }
        AbstractCacheView<AudioManager> managerMap = this.getJDA().getAudioManagersView();
        AudioManager mng = managerMap.get(this.id);
        if (mng == null) {
            try (UnlockHook hook = managerMap.writeLock();){
                GuildImpl cachedGuild = (GuildImpl)this.getJDA().getGuildById(this.id);
                if (cachedGuild == null) {
                    throw new IllegalStateException("Cannot get an AudioManager instance on an uncached Guild");
                }
                mng = managerMap.get(this.id);
                if (mng == null) {
                    mng = new AudioManagerImpl(cachedGuild);
                    managerMap.getMap().put(this.id, (Object)mng);
                }
            }
        }
        return mng;
    }

    @Override
    public JDAImpl getJDA() {
        return this.api.get();
    }

    @Override
    public List<GuildVoiceState> getVoiceStates() {
        return Collections.unmodifiableList(this.getMembersView().stream().map(Member::getVoiceState).filter(Objects::nonNull).collect(Collectors.toList()));
    }

    @Override
    public Guild.VerificationLevel getVerificationLevel() {
        return this.verificationLevel;
    }

    @Override
    public Guild.NotificationLevel getDefaultNotificationLevel() {
        return this.defaultNotificationLevel;
    }

    @Override
    public Guild.MFALevel getRequiredMFALevel() {
        return this.mfaLevel;
    }

    @Override
    public Guild.ExplicitContentLevel getExplicitContentLevel() {
        return this.explicitContentLevel;
    }

    @Override
    public boolean checkVerification() {
        if (this.getJDA().getAccountType() == AccountType.BOT) {
            return true;
        }
        if (this.canSendVerification) {
            return true;
        }
        if (this.getJDA().getSelfUser().getPhoneNumber() != null) {
            this.canSendVerification = true;
            return true;
        }
        switch (this.verificationLevel) {
            case VERY_HIGH: {
                break;
            }
            case HIGH: {
                if (ChronoUnit.MINUTES.between(this.getSelfMember().getTimeJoined(), OffsetDateTime.now()) < 10L) break;
            }
            case MEDIUM: {
                if (ChronoUnit.MINUTES.between(this.getJDA().getSelfUser().getTimeCreated(), OffsetDateTime.now()) < 5L) break;
            }
            case LOW: {
                if (!this.getJDA().getSelfUser().isVerified()) break;
            }
            case NONE: {
                this.canSendVerification = true;
                return true;
            }
            case UNKNOWN: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isAvailable() {
        return this.available;
    }

    @Override
    public long getIdLong() {
        return this.id;
    }

    public GuildImpl setAvailable(boolean available) {
        this.available = available;
        return this;
    }

    public GuildImpl setOwner(Member owner) {
        this.owner = owner;
        return this;
    }

    public GuildImpl setName(String name) {
        this.name = name;
        return this;
    }

    public GuildImpl setIconId(String iconId) {
        this.iconId = iconId;
        return this;
    }

    public GuildImpl setFeatures(Set<String> features) {
        this.features = Collections.unmodifiableSet(features);
        return this;
    }

    public GuildImpl setSplashId(String splashId) {
        this.splashId = splashId;
        return this;
    }

    public GuildImpl setRegion(String region) {
        this.region = region;
        return this;
    }

    public GuildImpl setAfkChannel(VoiceChannel afkChannel) {
        this.afkChannel = afkChannel;
        return this;
    }

    public GuildImpl setSystemChannel(TextChannel systemChannel) {
        this.systemChannel = systemChannel;
        return this;
    }

    public GuildImpl setPublicRole(Role publicRole) {
        this.publicRole = publicRole;
        return this;
    }

    public GuildImpl setVerificationLevel(Guild.VerificationLevel level) {
        this.verificationLevel = level;
        this.canSendVerification = false;
        return this;
    }

    public GuildImpl setDefaultNotificationLevel(Guild.NotificationLevel level) {
        this.defaultNotificationLevel = level;
        return this;
    }

    public GuildImpl setRequiredMFALevel(Guild.MFALevel level) {
        this.mfaLevel = level;
        return this;
    }

    public GuildImpl setExplicitContentLevel(Guild.ExplicitContentLevel level) {
        this.explicitContentLevel = level;
        return this;
    }

    public GuildImpl setAfkTimeout(Guild.Timeout afkTimeout) {
        this.afkTimeout = afkTimeout;
        return this;
    }

    public GuildImpl setOwnerId(long ownerId) {
        this.ownerId = ownerId;
        return this;
    }

    public SnowflakeCacheViewImpl<Category> getCategoriesView() {
        return this.categoryCache;
    }

    public SnowflakeCacheViewImpl<TextChannel> getTextChannelsView() {
        return this.textChannelCache;
    }

    public SnowflakeCacheViewImpl<VoiceChannel> getVoiceChannelsView() {
        return this.voiceChannelCache;
    }

    public SnowflakeCacheViewImpl<Role> getRolesView() {
        return this.roleCache;
    }

    public SnowflakeCacheViewImpl<Emote> getEmotesView() {
        return this.emoteCache;
    }

    public MemberCacheViewImpl getMembersView() {
        return this.memberCache;
    }

    public TLongObjectMap<JSONObject> getCachedPresenceMap() {
        return this.cachedPresences;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GuildImpl)) {
            return false;
        }
        GuildImpl oGuild = (GuildImpl)o;
        return this.id == oGuild.id;
    }

    public int hashCode() {
        return Long.hashCode(this.id);
    }

    public String toString() {
        return "G:" + this.getName() + '(' + this.id + ')';
    }

    @Override
    public RestAction<List<Invite>> retrieveInvites() {
        if (!this.getSelfMember().hasPermission(Permission.MANAGE_SERVER)) {
            throw new InsufficientPermissionException(Permission.MANAGE_SERVER);
        }
        Route.CompiledRoute route = Route.Invites.GET_GUILD_INVITES.compile(this.getId());
        return new RestActionImpl<List<Invite>>((JDA)this.getJDA(), route, (response, request) -> {
            EntityBuilder entityBuilder = this.api.get().getEntityBuilder();
            JSONArray array = response.getArray();
            ArrayList<Invite> invites = new ArrayList<Invite>(array.length());
            for (int i = 0; i < array.length(); ++i) {
                invites.add(entityBuilder.createInvite(array.getJSONObject(i)));
            }
            return Collections.unmodifiableList(invites);
        });
    }
}

