/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.internal.entities;

import gnu.trove.map.TLongObjectMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import net.dv8tion.jda.api.JDA;
import net.dv8tion.jda.api.Permission;
import net.dv8tion.jda.api.entities.Category;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.GuildChannel;
import net.dv8tion.jda.api.entities.IPermissionHolder;
import net.dv8tion.jda.api.entities.Invite;
import net.dv8tion.jda.api.entities.PermissionOverride;
import net.dv8tion.jda.api.exceptions.InsufficientPermissionException;
import net.dv8tion.jda.api.managers.ChannelManager;
import net.dv8tion.jda.api.requests.RestAction;
import net.dv8tion.jda.api.requests.restaction.AuditableRestAction;
import net.dv8tion.jda.api.requests.restaction.ChannelAction;
import net.dv8tion.jda.api.requests.restaction.InviteAction;
import net.dv8tion.jda.api.requests.restaction.PermissionOverrideAction;
import net.dv8tion.jda.api.utils.MiscUtil;
import net.dv8tion.jda.internal.JDAImpl;
import net.dv8tion.jda.internal.entities.EntityBuilder;
import net.dv8tion.jda.internal.entities.GuildImpl;
import net.dv8tion.jda.internal.managers.ChannelManagerImpl;
import net.dv8tion.jda.internal.requests.RestActionImpl;
import net.dv8tion.jda.internal.requests.Route;
import net.dv8tion.jda.internal.requests.restaction.AuditableRestActionImpl;
import net.dv8tion.jda.internal.requests.restaction.InviteActionImpl;
import net.dv8tion.jda.internal.requests.restaction.PermissionOverrideActionImpl;
import net.dv8tion.jda.internal.utils.Checks;
import net.dv8tion.jda.internal.utils.cache.UpstreamReference;
import org.json.JSONArray;

public abstract class AbstractChannelImpl<T extends GuildChannel, M extends AbstractChannelImpl<T, M>>
implements GuildChannel {
    protected final long id;
    protected final UpstreamReference<GuildImpl> guild;
    protected final TLongObjectMap<PermissionOverride> overrides = MiscUtil.newLongMap();
    protected final ReentrantLock mngLock = new ReentrantLock();
    protected volatile ChannelManager manager;
    protected long parentId;
    protected String name;
    protected int rawPosition;

    public AbstractChannelImpl(long id, GuildImpl guild) {
        this.id = id;
        this.guild = new UpstreamReference<GuildImpl>(guild);
    }

    public abstract ChannelAction<T> createCopy(Guild var1);

    public ChannelAction<T> createCopy() {
        return this.createCopy(this.getGuild());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public GuildImpl getGuild() {
        return this.guild.get();
    }

    @Override
    public Category getParent() {
        return (Category)this.getGuild().getCategoriesView().get(this.parentId);
    }

    @Override
    public int getPositionRaw() {
        return this.rawPosition;
    }

    @Override
    public JDA getJDA() {
        return this.getGuild().getJDA();
    }

    @Override
    public PermissionOverride getPermissionOverride(IPermissionHolder permissionHolder) {
        Checks.notNull(permissionHolder, "Permission Holder");
        Checks.check(permissionHolder.getGuild().equals(this.getGuild()), "Provided permission holder is not from the same guild as this channel!");
        return (PermissionOverride)this.overrides.get(permissionHolder.getIdLong());
    }

    @Override
    public List<PermissionOverride> getPermissionOverrides() {
        return Arrays.asList((PermissionOverride[])this.overrides.values((Object[])new PermissionOverride[this.overrides.size()]));
    }

    @Override
    public List<PermissionOverride> getMemberPermissionOverrides() {
        return Collections.unmodifiableList(this.getPermissionOverrides().stream().filter(PermissionOverride::isMemberOverride).collect(Collectors.toList()));
    }

    @Override
    public List<PermissionOverride> getRolePermissionOverrides() {
        return Collections.unmodifiableList(this.getPermissionOverrides().stream().filter(PermissionOverride::isRoleOverride).collect(Collectors.toList()));
    }

    @Override
    public ChannelManager getManager() {
        ChannelManager mng = this.manager;
        if (mng == null) {
            mng = MiscUtil.locked(this.mngLock, () -> {
                if (this.manager == null) {
                    this.manager = new ChannelManagerImpl(this);
                }
                return this.manager;
            });
        }
        return mng;
    }

    @Override
    public AuditableRestAction<Void> delete() {
        this.checkPermission(Permission.MANAGE_CHANNEL);
        Route.CompiledRoute route = Route.Channels.DELETE_CHANNEL.compile(this.getId());
        return new AuditableRestActionImpl<Void>(this.getJDA(), route);
    }

    @Override
    public PermissionOverrideAction createPermissionOverride(IPermissionHolder permissionHolder) {
        Checks.notNull(permissionHolder, "PermissionHolder");
        if (this.getPermissionOverride(permissionHolder) != null) {
            throw new IllegalStateException("Provided member already has a PermissionOverride in this channel!");
        }
        return this.putPermissionOverride(permissionHolder);
    }

    @Override
    public PermissionOverrideAction putPermissionOverride(IPermissionHolder permissionHolder) {
        this.checkPermission(Permission.MANAGE_PERMISSIONS);
        Checks.notNull(permissionHolder, "PermissionHolder");
        Checks.check(permissionHolder.getGuild().equals(this.getGuild()), "Provided permission holder is not from the same guild as this channel!");
        return new PermissionOverrideActionImpl(this.getJDA(), this, permissionHolder);
    }

    @Override
    public InviteAction createInvite() {
        if (!this.getGuild().getSelfMember().hasPermission((GuildChannel)this, Permission.CREATE_INSTANT_INVITE)) {
            throw new InsufficientPermissionException(Permission.CREATE_INSTANT_INVITE);
        }
        return new InviteActionImpl(this.getJDA(), this.getId());
    }

    @Override
    public RestAction<List<Invite>> retrieveInvites() {
        if (!this.getGuild().getSelfMember().hasPermission((GuildChannel)this, Permission.MANAGE_CHANNEL)) {
            throw new InsufficientPermissionException(Permission.MANAGE_CHANNEL);
        }
        Route.CompiledRoute route = Route.Invites.GET_CHANNEL_INVITES.compile(this.getId());
        JDAImpl jda = (JDAImpl)this.getJDA();
        return new RestActionImpl<List<Invite>>((JDA)jda, route, (response, request) -> {
            EntityBuilder entityBuilder = jda.getEntityBuilder();
            JSONArray array = response.getArray();
            ArrayList<Invite> invites = new ArrayList<Invite>(array.length());
            for (int i = 0; i < array.length(); ++i) {
                invites.add(entityBuilder.createInvite(array.getJSONObject(i)));
            }
            return Collections.unmodifiableList(invites);
        });
    }

    @Override
    public long getIdLong() {
        return this.id;
    }

    public int hashCode() {
        return Long.hashCode(this.id);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof GuildChannel)) {
            return false;
        }
        GuildChannel channel = (GuildChannel)obj;
        return channel.getIdLong() == this.getIdLong();
    }

    public TLongObjectMap<PermissionOverride> getOverrideMap() {
        return this.overrides;
    }

    public M setName(String name) {
        this.name = name;
        return (M)this;
    }

    public M setParent(long parentId) {
        this.parentId = parentId;
        return (M)this;
    }

    public M setPosition(int rawPosition) {
        this.rawPosition = rawPosition;
        return (M)this;
    }

    protected void checkPermission(Permission permission) {
        this.checkPermission(permission, null);
    }

    protected void checkPermission(Permission permission, String message) {
        if (!this.getGuild().getSelfMember().hasPermission((GuildChannel)this, permission)) {
            if (message != null) {
                throw new InsufficientPermissionException(permission, message);
            }
            throw new InsufficientPermissionException(permission);
        }
    }
}

