/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.api.utils.cache;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.dv8tion.jda.api.entities.ISnowflake;
import net.dv8tion.jda.api.utils.ClosableIterator;
import net.dv8tion.jda.api.utils.cache.MemberCacheView;
import net.dv8tion.jda.api.utils.cache.ShardCacheView;
import net.dv8tion.jda.api.utils.cache.SnowflakeCacheView;
import net.dv8tion.jda.api.utils.cache.UnifiedMemberCacheView;
import net.dv8tion.jda.internal.utils.Checks;
import net.dv8tion.jda.internal.utils.cache.AbstractCacheView;
import net.dv8tion.jda.internal.utils.cache.ShardCacheViewImpl;
import net.dv8tion.jda.internal.utils.cache.UnifiedCacheViewImpl;

public interface CacheView<T>
extends Iterable<T> {
    public List<T> asList();

    public Set<T> asSet();

    public ClosableIterator<T> lockedIterator();

    default public void forEachUnordered(Consumer<? super T> action) {
        this.forEach(action);
    }

    default public <R> R applyStream(Function<? super Stream<T>, ? extends R> action) {
        Checks.notNull(action, "Action");
        try (ClosableIterator<T> it = this.lockedIterator();){
            Spliterator<T> spliterator = Spliterators.spliterator(it, this.size(), 1280);
            Stream<T> stream = StreamSupport.stream(spliterator, false);
            R r = action.apply(stream);
            return r;
        }
    }

    default public void acceptStream(Consumer<? super Stream<T>> action) {
        Checks.notNull(action, "Action");
        try (ClosableIterator<T> it = this.lockedIterator();){
            Spliterator<T> spliterator = Spliterators.spliterator(it, this.size(), 1280);
            Stream<T> stream = StreamSupport.stream(spliterator, false);
            action.accept(stream);
        }
    }

    public long size();

    public boolean isEmpty();

    public List<T> getElementsByName(String var1, boolean var2);

    default public List<T> getElementsByName(String name) {
        return this.getElementsByName(name, false);
    }

    public Stream<T> stream();

    public Stream<T> parallelStream();

    default public <R, A> R collect(Collector<? super T, A, R> collector) {
        return this.stream().collect(collector);
    }

    public static <E> CacheView<E> all(Collection<? extends CacheView<E>> cacheViews) {
        Checks.noneNull(cacheViews, "Collection");
        return new UnifiedCacheViewImpl(cacheViews::stream);
    }

    public static <E> CacheView<E> all(Supplier<? extends Stream<? extends CacheView<E>>> generator) {
        Checks.notNull(generator, "Generator");
        return new UnifiedCacheViewImpl(generator);
    }

    public static ShardCacheView allShards(Collection<ShardCacheView> cacheViews) {
        Checks.noneNull(cacheViews, "Collection");
        return new ShardCacheViewImpl.UnifiedShardCacheViewImpl(cacheViews::stream);
    }

    public static ShardCacheView allShards(Supplier<? extends Stream<? extends ShardCacheView>> generator) {
        Checks.notNull(generator, "Generator");
        return new ShardCacheViewImpl.UnifiedShardCacheViewImpl(generator);
    }

    public static <E extends ISnowflake> SnowflakeCacheView<E> allSnowflakes(Collection<? extends SnowflakeCacheView<E>> cacheViews) {
        Checks.noneNull(cacheViews, "Collection");
        return new UnifiedCacheViewImpl.UnifiedSnowflakeCacheView(cacheViews::stream);
    }

    public static <E extends ISnowflake> SnowflakeCacheView<E> allSnowflakes(Supplier<? extends Stream<? extends SnowflakeCacheView<E>>> generator) {
        Checks.notNull(generator, "Generator");
        return new UnifiedCacheViewImpl.UnifiedSnowflakeCacheView(generator);
    }

    public static UnifiedMemberCacheView allMembers(Collection<? extends MemberCacheView> cacheViews) {
        Checks.noneNull(cacheViews, "Collection");
        return new UnifiedCacheViewImpl.UnifiedMemberCacheViewImpl((Supplier<? extends Stream<? extends MemberCacheView>>)((Supplier<Stream>)cacheViews::stream));
    }

    public static UnifiedMemberCacheView allMembers(Supplier<? extends Stream<? extends MemberCacheView>> generator) {
        Checks.notNull(generator, "Generator");
        return new UnifiedCacheViewImpl.UnifiedMemberCacheViewImpl(generator);
    }

    public static class SimpleCacheView<T>
    extends AbstractCacheView<T> {
        public SimpleCacheView(Class<T> type, Function<T, String> nameMapper) {
            super(type, nameMapper);
        }
    }
}

