/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.api.requests.restaction;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.function.BiConsumer;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import javax.annotation.CheckReturnValue;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.entities.MessageChannel;
import net.dv8tion.jda.api.entities.MessageEmbed;
import net.dv8tion.jda.api.requests.RestAction;
import net.dv8tion.jda.internal.utils.Checks;

public interface MessageAction
extends RestAction<Message>,
Appendable {
    public MessageAction setCheck(BooleanSupplier var1);

    public MessageChannel getChannel();

    public boolean isEmpty();

    public boolean isEdit();

    @CheckReturnValue
    public MessageAction apply(Message var1);

    @CheckReturnValue
    public MessageAction tts(boolean var1);

    @CheckReturnValue
    public MessageAction reset();

    @CheckReturnValue
    public MessageAction nonce(String var1);

    @CheckReturnValue
    public MessageAction content(String var1);

    @CheckReturnValue
    public MessageAction embed(MessageEmbed var1);

    @Override
    @CheckReturnValue
    default public MessageAction append(CharSequence csq) {
        return this.append(csq, 0, csq.length());
    }

    @Override
    @CheckReturnValue
    public MessageAction append(CharSequence var1, int var2, int var3);

    @Override
    @CheckReturnValue
    public MessageAction append(char var1);

    @CheckReturnValue
    default public MessageAction appendFormat(String format, Object ... args) {
        return this.append(String.format(format, args));
    }

    @CheckReturnValue
    public MessageAction addFile(InputStream var1, String var2);

    @CheckReturnValue
    default public MessageAction addFile(byte[] data, String name) {
        Checks.notNull(data, "Data");
        long maxSize = this.getJDA().getSelfUser().getAllowedFileSize();
        Checks.check((long)data.length <= maxSize, "File may not exceed the maximum file length of %d bytes!", (Object)maxSize);
        return this.addFile(new ByteArrayInputStream(data), name);
    }

    @CheckReturnValue
    default public MessageAction addFile(File file) {
        Checks.notNull(file, "File");
        return this.addFile(file, file.getName());
    }

    @CheckReturnValue
    public MessageAction addFile(File var1, String var2);

    @CheckReturnValue
    public MessageAction clearFiles();

    @CheckReturnValue
    public MessageAction clearFiles(BiConsumer<String, InputStream> var1);

    @CheckReturnValue
    public MessageAction clearFiles(Consumer<InputStream> var1);

    @CheckReturnValue
    public MessageAction override(boolean var1);
}

